/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.plugins;

import java.util.Map;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class BuildInfoPlugin
implements SmithyBuildPlugin {
    private static final String BUILD_INFO_VERSION = "1.0";
    private static final String NAME = "build-info";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean requiresValidModel() {
        return false;
    }

    @Override
    public void execute(PluginContext context) {
        if (context.getOriginalModel().isPresent() && context.getProjection().isPresent()) {
            context.getFileManifest().writeJson("smithy-build-info.json", BuildInfoPlugin.serializeBuildInfo(context));
        }
    }

    private static Node serializeBuildInfo(PluginContext context) {
        return Node.objectNodeBuilder().withMember("version", (ToNode)Node.from((String)BUILD_INFO_VERSION)).withMember("projectionName", (ToNode)Node.from((String)context.getProjectionName())).withMember("projection", (ToNode)context.getProjection().get().toNode()).withMember("validationEvents", (ToNode)((ArrayNode)context.getEvents().stream().map(ValidationEvent::toNode).collect(ArrayNode.collect()))).withMember("traitNames", (ToNode)BuildInfoPlugin.findTraitNames(context.getModel())).withMember("traitDefNames", (ToNode)((ArrayNode)context.getModel().getTraitShapes().stream().map(Shape::getId).map(ShapeId::toString).sorted().map(Node::from).collect(ArrayNode.collect()))).withMember("serviceShapeIds", (ToNode)BuildInfoPlugin.findShapeIds(context.getModel(), ServiceShape.class)).withMember("operationShapeIds", (ToNode)BuildInfoPlugin.findShapeIds(context.getModel(), OperationShape.class)).withMember("resourceShapeIds", (ToNode)BuildInfoPlugin.findShapeIds(context.getModel(), ResourceShape.class)).withMember("metadata", (ToNode)((ObjectNode)context.getModel().getMetadata().entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)))).build();
    }

    private static Node findTraitNames(Model model) {
        return (Node)model.shapes().flatMap(shape -> shape.getAllTraits().keySet().stream()).map(ShapeId::toString).distinct().sorted().map(Node::from).collect(ArrayNode.collect());
    }

    private static <T extends Shape> Node findShapeIds(Model model, Class<T> clazz) {
        return (Node)model.shapes(clazz).map(Shape::getId).map(Object::toString).sorted().map(Node::from).collect(ArrayNode.collect());
    }
}

