/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.ListUtils;

public interface ProjectionTransformer {
    public String getName();

    default public Collection<String> getAliases() {
        return ListUtils.of();
    }

    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> var1);

    public static Function<String, Optional<ProjectionTransformer>> createServiceFactory() {
        return ProjectionTransformer.createServiceFactory(ServiceLoader.load(ProjectionTransformer.class));
    }

    public static Function<String, Optional<ProjectionTransformer>> createServiceFactory(Iterable<ProjectionTransformer> transformers) {
        HashMap<String, ProjectionTransformer> map = new HashMap<String, ProjectionTransformer>();
        for (ProjectionTransformer transformer : transformers) {
            map.put(transformer.getName(), transformer);
            transformer.getAliases().forEach(alias -> map.put((String)alias, transformer));
        }
        return name -> Optional.ofNullable((ProjectionTransformer)map.get(name));
    }

    public static Function<String, Optional<ProjectionTransformer>> createServiceFactory(ClassLoader classLoader) {
        return ProjectionTransformer.createServiceFactory(ServiceLoader.load(ProjectionTransformer.class, classLoader));
    }
}

