/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.util.Map;
import java.util.regex.Pattern;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.Pair;

public final class JsonSubstitutions {
    private static final Pattern SUBSTITUTIONS_KEY_PATTERN = Pattern.compile("^[A-Za-z_][A-Za-z_0-9-]+$");
    private final Map<String, Node> findAndReplace;

    private JsonSubstitutions(Map<String, Node> findAndReplace) {
        for (String key : findAndReplace.keySet()) {
            if (SUBSTITUTIONS_KEY_PATTERN.matcher(key).find()) continue;
            throw new SmithyBuildException(String.format("JSON substitution key found named `%s`, but each key must match the following regular expression: %s", key, SUBSTITUTIONS_KEY_PATTERN.pattern()));
        }
        this.findAndReplace = MapUtils.copyOf(findAndReplace);
    }

    public static JsonSubstitutions create(ObjectNode node) {
        return JsonSubstitutions.create(node.getStringMap());
    }

    public static JsonSubstitutions create(Map<String, Node> map) {
        return new JsonSubstitutions(map);
    }

    public Node apply(Node node) {
        return ((Node)node.accept((NodeVisitor)new SubstitutionVisitor())).expectObjectNode();
    }

    private final class SubstitutionVisitor
    extends NodeVisitor.Default<Node> {
        private SubstitutionVisitor() {
        }

        protected Node getDefault(Node value) {
            return value;
        }

        public Node arrayNode(ArrayNode node) {
            return (Node)node.getElements().stream().map(element -> (Node)element.accept((NodeVisitor)this)).collect(ArrayNode.collect());
        }

        public Node objectNode(ObjectNode node) {
            return (Node)node.getMembers().entrySet().stream().map(entry -> Pair.of((Object)((StringNode)entry.getKey()), (Object)((Node)((Node)entry.getValue()).accept((NodeVisitor)this)))).collect(ObjectNode.collect(Pair::getLeft, Pair::getRight));
        }

        public Node stringNode(StringNode node) {
            return (Node)JsonSubstitutions.this.findAndReplace.getOrDefault(node.getValue(), node);
        }
    }
}

