/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.Tagged;

public final class IncludeTraitsByTag
implements ProjectionTransformer {
    @Override
    public String getName() {
        return "includeTraitsByTag";
    }

    @Override
    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> arguments) {
        return (transformer, model) -> transformer.removeShapesIf(model, shape -> !Prelude.isPreludeShape((ToShapeId)shape) && shape.hasTrait(TraitDefinition.class) && !this.hasAnyTag((Tagged)shape, arguments));
    }

    private boolean hasAnyTag(Tagged tagged, Collection<String> tags) {
        return tagged.getTags().stream().anyMatch(tags::contains);
    }
}

