/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.TagsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;

abstract class AbstractTagMapper
implements ProjectionTransformer {
    private final boolean exclude;

    AbstractTagMapper(boolean exclude) {
        this.exclude = exclude;
    }

    @Override
    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> arguments) {
        HashSet<String> tags = new HashSet<String>(arguments);
        return (transformer, model) -> this.removeShapeTags((ModelTransformer)transformer, (Model)model, (Set<String>)tags);
    }

    private Model removeShapeTags(ModelTransformer transformer, Model model, Set<String> tags) {
        return transformer.mapShapes(model, shape -> this.intersectIfChanged(shape.getTags(), tags).map(intersection -> {
            TagsTrait.Builder builder = TagsTrait.builder();
            intersection.forEach(arg_0 -> ((TagsTrait.Builder)builder).addValue(arg_0));
            return (Shape)Shape.shapeToBuilder((Shape)shape).addTrait((Trait)builder.build()).build();
        }).orElse((Shape)shape));
    }

    private Optional<Set<String>> intersectIfChanged(Collection<String> subject, Collection<String> other) {
        HashSet<String> temp = new HashSet<String>(subject);
        if (this.exclude) {
            temp.removeAll(other);
        } else {
            temp.retainAll(other);
        }
        return temp.size() == subject.size() ? Optional.empty() : Optional.of(temp);
    }
}

