/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.aws.traits.tagging.TaggableTrait;
import software.amazon.smithy.aws.traits.tagging.TaggingShapeUtils;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TagResourcePropertyNameValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ResourceShape resource : model.getResourceShapesWithTrait(TaggableTrait.class)) {
            TaggableTrait trait = (TaggableTrait)resource.expectTrait(TaggableTrait.class);
            if (!trait.getProperty().isPresent() || TaggingShapeUtils.isTagDesiredName(trait.getProperty().get())) continue;
            events.add(this.warning((Shape)resource, String.format("Suggested tag property name is '%s'.", TaggingShapeUtils.getDesiredTagsPropertyName())));
        }
        return events;
    }
}

