/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.aws.traits.ArnTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ArnTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ResourceShape resource : model.getResourceShapesWithTrait(ArnTrait.class)) {
            ArnTrait trait = (ArnTrait)resource.expectTrait(ArnTrait.class);
            if (trait.isAbsolute() || !trait.getResourceDelimiter().isPresent()) continue;
            events.add(this.error((Shape)resource, (FromSourceLocation)trait, "A `resourceDelimiter` can only be set for an `absolute` ARN."));
        }
        return events;
    }
}

