/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.HashMap;
import java.util.Map;
import software.amazon.smithy.aws.traits.ControlPlaneTrait;
import software.amazon.smithy.aws.traits.DataPlaneTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.selector.PathFinder;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class PlaneIndex
implements KnowledgeIndex {
    private static final Selector SELECTOR = Selector.parse((String)":test(operation, resource)");
    private final Map<ShapeId, Plane> servicePlanes = new HashMap<ShapeId, Plane>();
    private final PathFinder pathFinder;

    public PlaneIndex(Model model) {
        this.pathFinder = PathFinder.create((Model)model);
        model.shapes(ServiceShape.class).forEach(service -> {
            Plane plane = this.extractPlane((Shape)service);
            if (plane != null) {
                this.servicePlanes.put(service.getId(), plane);
            }
        });
    }

    public static PlaneIndex of(Model model) {
        return (PlaneIndex)model.getKnowledge(PlaneIndex.class, PlaneIndex::new);
    }

    public boolean isControlPlane(ToShapeId service) {
        return this.servicePlanes.getOrDefault(service.toShapeId(), null) == Plane.CONTROL;
    }

    public boolean isControlPlane(ToShapeId service, ToShapeId operationOrResource) {
        return this.resolvePlane(service, operationOrResource.toShapeId()) == Plane.CONTROL;
    }

    public boolean isDataPlane(ToShapeId service) {
        return this.servicePlanes.getOrDefault(service.toShapeId(), null) == Plane.DATA;
    }

    public boolean isDataPlane(ToShapeId service, ToShapeId operationOrResource) {
        return this.resolvePlane(service, operationOrResource.toShapeId()) == Plane.DATA;
    }

    public boolean isPlaneDefined(ToShapeId service) {
        return this.servicePlanes.containsKey(service.toShapeId());
    }

    public boolean isPlaneDefined(ToShapeId service, ToShapeId operationOrResource) {
        return this.resolvePlane(service, operationOrResource.toShapeId()) != null;
    }

    private Plane resolvePlane(ToShapeId service, ShapeId operationOrResource) {
        Plane result = null;
        for (PathFinder.Path path : this.pathFinder.search(service, SELECTOR)) {
            for (Shape shape : path.getShapes()) {
                Plane nextPlane = this.extractPlane(shape);
                if (nextPlane != null) {
                    result = nextPlane;
                }
                if (!shape.getId().equals((Object)operationOrResource)) continue;
                return result;
            }
        }
        return null;
    }

    private Plane extractPlane(Shape shape) {
        if (shape.hasTrait(ControlPlaneTrait.ID)) {
            return Plane.CONTROL;
        }
        if (shape.hasTrait(DataPlaneTrait.ID)) {
            return Plane.DATA;
        }
        return null;
    }

    private static enum Plane {
        CONTROL,
        DATA;

    }
}

