/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.ArnTrait;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.IdentifierBindingIndex;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.Pair;

public final class ArnIndex
implements KnowledgeIndex {
    private final Map<ShapeId, String> arnServices = new HashMap<ShapeId, String>();
    private final Map<ShapeId, Map<ShapeId, ArnTrait>> templates;
    private final Map<ShapeId, Map<ShapeId, ArnTrait>> effectiveArns = new HashMap<ShapeId, Map<ShapeId, ArnTrait>>();

    public ArnIndex(Model model) {
        for (Shape service2 : model.getServiceShapesWithTrait(ServiceTrait.class)) {
            this.arnServices.put(service2.getId(), ((ServiceTrait)service2.expectTrait(ServiceTrait.class)).getArnNamespace());
        }
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        List services = model.shapes(ServiceShape.class).filter(shape -> shape.hasTrait(ServiceTrait.class)).collect(Collectors.toList());
        this.templates = Collections.unmodifiableMap(services.stream().map(service -> this.compileServiceArns(topDownIndex, (ServiceShape)service)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        IdentifierBindingIndex bindingIndex = IdentifierBindingIndex.of((Model)model);
        for (ServiceShape service3 : services) {
            this.compileEffectiveArns(topDownIndex, bindingIndex, service3);
        }
    }

    public static ArnIndex of(Model model) {
        return (ArnIndex)model.getKnowledge(ArnIndex.class, ArnIndex::new);
    }

    private Pair<ShapeId, Map<ShapeId, ArnTrait>> compileServiceArns(TopDownIndex index, ServiceShape service) {
        HashMap mapping = new HashMap();
        for (ResourceShape resource : index.getContainedResources((ToShapeId)service.getId())) {
            resource.getTrait(ArnTrait.class).ifPresent(arnTrait -> mapping.put(resource.getId(), arnTrait));
        }
        return Pair.of((Object)service.getId(), Collections.unmodifiableMap(mapping));
    }

    private void compileEffectiveArns(TopDownIndex index, IdentifierBindingIndex bindings, ServiceShape service) {
        HashMap<ShapeId, ArnTrait> operationMappings = new HashMap<ShapeId, ArnTrait>();
        this.effectiveArns.put(service.getId(), operationMappings);
        for (Map.Entry<ShapeId, ArnTrait> entry : this.templates.get(service.getId()).entrySet()) {
            ShapeId resourceId = entry.getKey();
            ArnTrait arnTrait = entry.getValue();
            for (OperationShape operation : index.getContainedOperations((ToShapeId)resourceId)) {
                IdentifierBindingIndex.BindingType bindingType = bindings.getOperationBindingType((ToShapeId)resourceId, (ToShapeId)operation);
                if (bindingType == IdentifierBindingIndex.BindingType.INSTANCE) {
                    operationMappings.put(operation.getId(), arnTrait);
                    continue;
                }
                if (bindingType != IdentifierBindingIndex.BindingType.COLLECTION) continue;
                for (ResourceShape resource : index.getContainedResources((ToShapeId)service)) {
                    if (!resource.getResources().contains(entry.getKey())) continue;
                    resource.getTrait(ArnTrait.class).ifPresent(trait -> operationMappings.put(operation.getId(), (ArnTrait)((Object)trait)));
                }
            }
        }
    }

    public String getServiceArnNamespace(ToShapeId serviceId) {
        return this.arnServices.containsKey(serviceId.toShapeId()) ? this.arnServices.get(serviceId.toShapeId()) : serviceId.toShapeId().getName().toLowerCase(Locale.US);
    }

    public Map<ShapeId, ArnTrait> getServiceResourceArns(ToShapeId service) {
        return this.templates.getOrDefault(service.toShapeId(), Collections.emptyMap());
    }

    public Optional<ArnTrait> getEffectiveOperationArn(ToShapeId service, ToShapeId operation) {
        return Optional.ofNullable(this.effectiveArns.get(service.toShapeId())).flatMap(operationArns -> Optional.ofNullable((ArnTrait)((Object)((Object)operationArns.get(operation.toShapeId())))));
    }

    public Optional<String> getFullResourceArnTemplate(ToShapeId service, ToShapeId resource) {
        return Optional.ofNullable(this.getServiceResourceArns(service).get(resource.toShapeId())).map(trait -> {
            StringBuilder result = new StringBuilder();
            if (!trait.isAbsolute()) {
                result.append("arn:").append("{AWS::Partition}:").append(this.getServiceArnNamespace(service)).append(":");
                if (!trait.isNoRegion()) {
                    result.append("{AWS::Region}");
                }
                result.append(":");
                if (!trait.isNoAccount()) {
                    result.append("{AWS::AccountId}");
                }
                result.append(":");
            }
            return result.append(trait.getTemplate()).toString();
        });
    }
}

