/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ArnReferenceTrait
extends AbstractTrait
implements ToSmithyBuilder<ArnReferenceTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.api#arnReference");
    private static final String TYPE = "type";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private String type;
    private ShapeId service;
    private ShapeId resource;

    private ArnReferenceTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.type = builder.type;
        this.service = builder.service;
        this.resource = builder.resource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<ShapeId> getResource() {
        return Optional.ofNullable(this.resource);
    }

    public Optional<ShapeId> getService() {
        return Optional.ofNullable(this.service);
    }

    public Builder toBuilder() {
        return ((Builder)new Builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).type(this.type).service(this.service).resource(this.resource);
    }

    protected Node createNode() {
        return Node.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withOptionalMember(TYPE, this.getType().map(Node::from)).withOptionalMember(SERVICE, this.getService().map(ShapeId::toString).map(Node::from)).withOptionalMember(RESOURCE, this.getResource().map(ShapeId::toString).map(Node::from)).build();
    }

    public static final class Builder
    extends AbstractTraitBuilder<ArnReferenceTrait, Builder> {
        private String type;
        private ShapeId service;
        private ShapeId resource;

        private Builder() {
        }

        public ArnReferenceTrait build() {
            return new ArnReferenceTrait(this);
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder service(ShapeId service) {
            this.service = service;
            return this;
        }

        public Builder resource(ShapeId resource) {
            this.resource = resource;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Builder builder = (Builder)ArnReferenceTrait.builder().sourceLocation((FromSourceLocation)value);
            objectNode.getStringMember(ArnReferenceTrait.TYPE).map(StringNode::getValue).ifPresent(builder::type);
            objectNode.getStringMember(ArnReferenceTrait.SERVICE).map(stringNode -> stringNode.expectShapeId(target.getNamespace())).ifPresent(builder::service);
            objectNode.getStringMember(ArnReferenceTrait.RESOURCE).map(stringNode -> stringNode.expectShapeId(target.getNamespace())).ifPresent(builder::resource);
            return builder.build();
        }
    }
}

