/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.protocols.AwsProtocolTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ProtocolHttpValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ServiceIndex serviceIndex = (ServiceIndex)model.getKnowledge(ServiceIndex.class);
        return model.shapes(ServiceShape.class).flatMap(service -> this.validateService((ServiceShape)service, serviceIndex).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(ServiceShape service, ServiceIndex index) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Trait protocol : index.getProtocols((ToShapeId)service).values()) {
            if (!(protocol instanceof AwsProtocolTrait)) continue;
            AwsProtocolTrait awsProtocolTrait = (AwsProtocolTrait)protocol;
            ArrayList<String> invalid = new ArrayList<String>(awsProtocolTrait.getEventStreamHttp());
            invalid.removeAll(awsProtocolTrait.getHttp());
            if (invalid.isEmpty()) continue;
            events.add(this.error((Shape)service, (FromSourceLocation)protocol, String.format("The following values of the `eventStreamHttp` property do not also appear in the `http` property of the %s protocol trait: %s", protocol.toShapeId(), invalid)));
        }
        return events;
    }
}

