/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.apigateway;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.apigateway.AuthorizerDefinition;
import software.amazon.smithy.aws.traits.apigateway.AuthorizersTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.ProtocolsTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SetUtils;

public class AuthorizersTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.getShapeIndex().shapes(ServiceShape.class).flatMap(service -> OptionalUtils.stream(this.validateService((ServiceShape)service))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> validateService(ServiceShape service) {
        Set schemeNames = service.getTrait(ProtocolsTrait.class).map(ProtocolsTrait::getAllAuthSchemes).orElse(SetUtils.of());
        String invalidMappings = service.getTrait(AuthorizersTrait.class).map(AuthorizersTrait::getAllAuthorizers).orElseGet(HashMap::new).entrySet().stream().filter(entry -> !schemeNames.contains(((AuthorizerDefinition)entry.getValue()).getScheme())).map(entry -> (String)entry.getKey() + " -> " + ((AuthorizerDefinition)entry.getValue()).getScheme()).sorted().collect(Collectors.joining(", "));
        if (invalidMappings.isEmpty()) {
            return Optional.empty();
        }
        AuthorizersTrait authorizersTrait = (AuthorizersTrait)((Object)service.getTrait(AuthorizersTrait.class).get());
        return Optional.of(this.error((Shape)service, (FromSourceLocation)authorizersTrait, String.format("Each `scheme` of the `%s` trait must target one of the auth schemes defined in the `protocols` trait of a service (i.e., [%s]). The following mappings of authorizer names to schemes are invalid: %s", AuthorizersTrait.ID, ValidationUtils.tickedList((Collection)schemeNames), invalidMappings)));
    }
}

