/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.smithy.aws.cloudformation.schema.CfnConfig;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.traits.ExternalDocumentationTrait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class DocumentationMapper
implements CfnMapper {
    DocumentationMapper() {
    }

    @Override
    public void before(Context context, ResourceSchema.Builder builder) {
        ResourceShape resource = context.getResource();
        ExternalDocumentationTrait trait = resource.getTrait(ExternalDocumentationTrait.class).orElse(null);
        if (trait == null) {
            return;
        }
        CfnConfig config = context.getConfig();
        this.getResolvedExternalDocs(trait, config.getSourceDocs()).ifPresent(builder::sourceUrl);
        this.getResolvedExternalDocs(trait, config.getExternalDocs()).ifPresent(builder::documentationUrl);
    }

    private Optional<String> getResolvedExternalDocs(ExternalDocumentationTrait trait, List<String> enabledKeys) {
        List<String> externalDocKeys = this.listToLowerCase(enabledKeys);
        Map traitUrls = trait.getUrls();
        Map lowercaseKeyMap = (Map)traitUrls.keySet().stream().collect(MapUtils.toUnmodifiableMap(this::toLowerCase, Function.identity()));
        for (String externalDocKey : externalDocKeys) {
            if (!lowercaseKeyMap.containsKey(externalDocKey)) continue;
            String traitKey = (String)lowercaseKeyMap.get(externalDocKey);
            return Optional.of(traitUrls.get(traitKey));
        }
        return Optional.empty();
    }

    private List<String> listToLowerCase(List<String> inputs) {
        ArrayList<String> outputs = new ArrayList<String>(inputs.size());
        for (String input : inputs) {
            outputs.add(this.toLowerCase(input));
        }
        return outputs;
    }

    private String toLowerCase(String input) {
        return input.toLowerCase(Locale.US);
    }
}

