/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;

final class AdditionalPropertiesMapper
implements CfnMapper {
    AdditionalPropertiesMapper() {
    }

    @Override
    public byte getOrder() {
        return 124;
    }

    @Override
    public ObjectNode updateNode(Context context, ResourceSchema resourceSchema, ObjectNode node) {
        Optional definitionsOptional = node.getObjectMember("definitions");
        LinkedHashMap updatedNodes = new LinkedHashMap();
        if (definitionsOptional.isPresent()) {
            for (Map.Entry entry : ((ObjectNode)definitionsOptional.get()).getMembers().entrySet()) {
                ObjectNode valueNode = ((Node)entry.getValue()).expectObjectNode();
                if (valueNode.expectStringMember("type").getValue().equals("object")) {
                    valueNode = valueNode.withMember("additionalProperties", false);
                }
                updatedNodes.put(entry.getKey(), valueNode);
            }
            node = node.withMember("definitions", (ToNode)Node.objectNode(updatedNodes));
        }
        return node;
    }
}

