/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import software.amazon.smithy.aws.cloudformation.schema.CfnException;
import software.amazon.smithy.aws.cloudformation.schema.model.Handler;
import software.amazon.smithy.aws.cloudformation.schema.model.Property;
import software.amazon.smithy.aws.cloudformation.schema.model.Remote;
import software.amazon.smithy.aws.cloudformation.schema.model.Tagging;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ResourceSchema
implements ToNode,
ToSmithyBuilder<ResourceSchema> {
    private final String typeName;
    private final String description;
    private final String sourceUrl;
    private final String documentationUrl;
    private final Map<String, Schema> definitions;
    private final Map<String, Property> properties;
    private final Set<String> required;
    private final Set<String> readOnlyProperties;
    private final Set<String> writeOnlyProperties;
    private final Set<String> primaryIdentifier;
    private final Set<String> createOnlyProperties;
    private final Set<String> deprecatedProperties;
    private final List<List<String>> additionalIdentifiers;
    private final Map<String, Handler> handlers;
    private final Map<String, Remote> remotes;
    private final Tagging tagging;
    private final Schema additionalProperties;

    private ResourceSchema(Builder builder) {
        this.typeName = (String)SmithyBuilder.requiredState((String)"typeName", (Object)builder.typeName);
        this.description = (String)SmithyBuilder.requiredState((String)"description", (Object)builder.description);
        if (((Map)builder.properties.peek()).isEmpty()) {
            throw new CfnException(String.format("Expected CloudFormation resource %s to have properties, found none", this.typeName));
        }
        this.properties = new TreeMap<String, Property>((Map)builder.properties.peek());
        this.required = new TreeSet<String>((Collection)builder.required.copy());
        this.sourceUrl = builder.sourceUrl;
        this.documentationUrl = builder.documentationUrl;
        this.definitions = new TreeMap<String, Schema>((Map)builder.definitions.peek());
        this.readOnlyProperties = new TreeSet<String>((Collection)builder.readOnlyProperties.peek());
        this.writeOnlyProperties = new TreeSet<String>((Collection)builder.writeOnlyProperties.peek());
        this.primaryIdentifier = new TreeSet<String>((Collection)builder.primaryIdentifier.peek());
        this.createOnlyProperties = new TreeSet<String>((Collection)builder.createOnlyProperties.peek());
        this.deprecatedProperties = new TreeSet<String>((Collection)builder.deprecatedProperties.peek());
        this.additionalIdentifiers = (List)builder.additionalIdentifiers.copy();
        this.handlers = new TreeMap<String, Handler>((Map)builder.handlers.peek());
        this.remotes = new TreeMap<String, Remote>((Map)builder.remotes.peek());
        this.tagging = builder.tagging;
        this.additionalProperties = builder.additionalProperties;
    }

    public Node toNode() {
        NodeMapper mapper = new NodeMapper();
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        builder.withMember("typeName", this.typeName);
        builder.withMember("description", this.description);
        this.getSourceUrl().ifPresent(sourceUrl -> builder.withMember("sourceUrl", sourceUrl));
        this.getDocumentationUrl().ifPresent(documentationUrl -> builder.withMember("documentationUrl", documentationUrl));
        if (!this.definitions.isEmpty()) {
            builder.withMember("definitions", (ToNode)mapper.serialize(this.definitions));
        }
        builder.withMember("properties", (ToNode)mapper.serialize(this.properties));
        if (!this.required.isEmpty()) {
            builder.withMember("required", (ToNode)mapper.serialize(this.required));
        }
        if (!this.readOnlyProperties.isEmpty()) {
            builder.withMember("readOnlyProperties", (ToNode)mapper.serialize(this.readOnlyProperties));
        }
        if (!this.writeOnlyProperties.isEmpty()) {
            builder.withMember("writeOnlyProperties", (ToNode)mapper.serialize(this.writeOnlyProperties));
        }
        if (!this.createOnlyProperties.isEmpty()) {
            builder.withMember("createOnlyProperties", (ToNode)mapper.serialize(this.createOnlyProperties));
        }
        if (!this.deprecatedProperties.isEmpty()) {
            builder.withMember("deprecatedProperties", (ToNode)mapper.serialize(this.deprecatedProperties));
        }
        if (!this.primaryIdentifier.isEmpty()) {
            builder.withMember("primaryIdentifier", (ToNode)mapper.serialize(this.primaryIdentifier));
        }
        if (!this.additionalIdentifiers.isEmpty()) {
            builder.withMember("additionalIdentifiers", (ToNode)mapper.serialize(this.additionalIdentifiers));
        }
        if (!this.handlers.isEmpty()) {
            builder.withMember("handlers", (ToNode)mapper.serialize(this.handlers));
        }
        if (!this.remotes.isEmpty()) {
            builder.withMember("remotes", (ToNode)mapper.serialize(this.remotes));
        }
        if (this.tagging != null) {
            builder.withMember("tagging", (ToNode)mapper.serialize((Object)this.tagging));
        }
        if (this.additionalProperties != null) {
            builder.withMember("additionalProperties", (ToNode)mapper.serialize((Object)this.additionalProperties));
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return ResourceSchema.builder().typeName(this.typeName).description(this.description).sourceUrl(this.sourceUrl).documentationUrl(this.documentationUrl).definitions(this.definitions).properties(this.properties).required(this.required).readOnlyProperties(this.readOnlyProperties).writeOnlyProperties(this.writeOnlyProperties).primaryIdentifier(this.primaryIdentifier).createOnlyProperties(this.createOnlyProperties).deprecatedProperties(this.deprecatedProperties).additionalIdentifiers(this.additionalIdentifiers).handlers(this.handlers).remotes(this.remotes).tagging(this.tagging);
    }

    public static ResourceSchema fromNode(Node node) {
        NodeMapper mapper = new NodeMapper();
        return ((Builder)mapper.deserializeInto(node, (Object)ResourceSchema.builder())).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<String> getSourceUrl() {
        return Optional.ofNullable(this.sourceUrl);
    }

    public Optional<String> getDocumentationUrl() {
        return Optional.ofNullable(this.documentationUrl);
    }

    public Map<String, Schema> getDefinitions() {
        return this.definitions;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public Set<String> getRequired() {
        return this.required;
    }

    public Set<String> getReadOnlyProperties() {
        return this.readOnlyProperties;
    }

    public Set<String> getWriteOnlyProperties() {
        return this.writeOnlyProperties;
    }

    public Set<String> getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    public Set<String> getCreateOnlyProperties() {
        return this.createOnlyProperties;
    }

    public Set<String> getDeprecatedProperties() {
        return this.deprecatedProperties;
    }

    public List<List<String>> getAdditionalIdentifiers() {
        return this.additionalIdentifiers;
    }

    public Map<String, Handler> getHandlers() {
        return this.handlers;
    }

    public Map<String, Remote> getRemotes() {
        return this.remotes;
    }

    public Tagging getTagging() {
        return this.tagging;
    }

    public Schema getAdditionalProperties() {
        return this.additionalProperties;
    }

    public static final class Builder
    implements SmithyBuilder<ResourceSchema> {
        private String typeName;
        private String description;
        private String sourceUrl;
        private String documentationUrl;
        private final BuilderRef<Map<String, Schema>> definitions = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, Property>> properties = BuilderRef.forSortedMap();
        private final BuilderRef<Set<String>> required = BuilderRef.forSortedSet();
        private final BuilderRef<Set<String>> readOnlyProperties = BuilderRef.forSortedSet();
        private final BuilderRef<Set<String>> writeOnlyProperties = BuilderRef.forSortedSet();
        private final BuilderRef<Set<String>> primaryIdentifier = BuilderRef.forSortedSet();
        private final BuilderRef<Set<String>> createOnlyProperties = BuilderRef.forSortedSet();
        private final BuilderRef<Set<String>> deprecatedProperties = BuilderRef.forSortedSet();
        private final BuilderRef<List<List<String>>> additionalIdentifiers = BuilderRef.forList();
        private final BuilderRef<Map<String, Handler>> handlers = BuilderRef.forSortedMap(Comparator.comparing(Handler::getHandlerNameOrder));
        private final BuilderRef<Map<String, Remote>> remotes = BuilderRef.forSortedMap();
        private Tagging tagging;
        private Schema additionalProperties;

        private Builder() {
        }

        public ResourceSchema build() {
            return new ResourceSchema(this);
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public Builder definitions(Map<String, Schema> definitions) {
            this.definitions.clear();
            definitions.forEach(this::addDefinition);
            return this;
        }

        public Builder addDefinition(String name, Schema definition) {
            ((Map)this.definitions.get()).put(name, definition);
            return this;
        }

        public Builder removeDefinition(String name) {
            ((Map)this.definitions.get()).remove(name);
            return this;
        }

        public Builder clearDefinitions() {
            this.definitions.clear();
            return this;
        }

        public Builder properties(Map<String, Property> properties) {
            this.properties.clear();
            properties.forEach(this::addProperty);
            return this;
        }

        public Builder addProperty(String name, Property property) {
            ((Map)this.properties.get()).put(name, property);
            return this;
        }

        public Builder removeProperty(String name) {
            ((Map)this.properties.get()).remove(name);
            return this;
        }

        public Builder clearProperties() {
            this.properties.clear();
            return this;
        }

        public Builder required(Collection<String> required) {
            this.required.clear();
            required.forEach(this::addRequired);
            return this;
        }

        public Builder addRequired(String required) {
            ((Set)this.required.get()).add(required);
            return this;
        }

        public Builder removeRequired(String required) {
            ((Set)this.required.get()).remove(required);
            return this;
        }

        public Builder clearRequired() {
            this.required.clear();
            return this;
        }

        public Builder addReadOnlyProperty(String propertyRef) {
            ((Set)this.readOnlyProperties.get()).add(propertyRef);
            return this;
        }

        public Builder readOnlyProperties(Collection<String> readOnlyProperties) {
            this.readOnlyProperties.clear();
            readOnlyProperties.forEach(this::addReadOnlyProperty);
            return this;
        }

        public Builder clearReadOnlyProperties() {
            this.readOnlyProperties.clear();
            return this;
        }

        public Builder addWriteOnlyProperty(String propertyRef) {
            ((Set)this.writeOnlyProperties.get()).add(propertyRef);
            return this;
        }

        public Builder writeOnlyProperties(Collection<String> writeOnlyProperties) {
            this.writeOnlyProperties.clear();
            writeOnlyProperties.forEach(this::addWriteOnlyProperty);
            return this;
        }

        public Builder clearWriteOnlyProperties() {
            this.writeOnlyProperties.clear();
            return this;
        }

        public Builder primaryIdentifier(Collection<String> primaryIdentifier) {
            this.primaryIdentifier.clear();
            ((Set)this.primaryIdentifier.get()).addAll(primaryIdentifier);
            return this;
        }

        public Builder clearPrimaryIdentifier() {
            this.primaryIdentifier.clear();
            return this;
        }

        public Builder addCreateOnlyProperty(String propertyRef) {
            ((Set)this.createOnlyProperties.get()).add(propertyRef);
            return this;
        }

        public Builder createOnlyProperties(Collection<String> createOnlyProperties) {
            this.createOnlyProperties.clear();
            createOnlyProperties.forEach(this::addCreateOnlyProperty);
            return this;
        }

        public Builder clearCreateOnlyProperties() {
            this.createOnlyProperties.clear();
            return this;
        }

        public Builder addDeprecatedProperty(String propertyRef) {
            ((Set)this.deprecatedProperties.get()).add(propertyRef);
            return this;
        }

        public Builder deprecatedProperties(Collection<String> deprecatedProperties) {
            this.deprecatedProperties.clear();
            deprecatedProperties.forEach(this::addDeprecatedProperty);
            return this;
        }

        public Builder clearDeprecatedProperties() {
            this.deprecatedProperties.clear();
            return this;
        }

        public Builder addAdditionalIdentifier(List<String> additionalIdentifier) {
            ((List)this.additionalIdentifiers.get()).add(additionalIdentifier);
            return this;
        }

        public Builder additionalIdentifiers(List<List<String>> additionalIdentifiers) {
            this.additionalIdentifiers.clear();
            additionalIdentifiers.forEach(this::addAdditionalIdentifier);
            return this;
        }

        public Builder clearAdditionalIdentifiers() {
            this.additionalIdentifiers.clear();
            return this;
        }

        public Builder handlers(Map<String, Handler> handlers) {
            this.handlers.clear();
            handlers.forEach(this::addHandler);
            return this;
        }

        public Builder addHandler(String name, Handler handler) {
            ((Map)this.handlers.get()).put(name, handler);
            return this;
        }

        public Builder removeHandler(String name) {
            ((Map)this.handlers.get()).remove(name);
            return this;
        }

        public Builder clearHandlers() {
            this.handlers.clear();
            return this;
        }

        public Builder remotes(Map<String, Remote> remotes) {
            this.remotes.clear();
            remotes.forEach(this::addRemote);
            return this;
        }

        public Builder tagging(Tagging tagging) {
            this.tagging = tagging;
            return this;
        }

        public Builder addRemote(String name, Remote remote) {
            ((Map)this.remotes.get()).put(name, remote);
            return this;
        }

        public Builder removeRemote(String name) {
            ((Map)this.remotes.get()).remove(name);
            return this;
        }

        public Builder clearRemotes() {
            this.remotes.clear();
            return this;
        }

        public Builder additionalProperties(Schema additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }
    }
}

