/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.model;

import java.util.Map;
import java.util.TreeMap;
import software.amazon.smithy.aws.cloudformation.schema.model.Property;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Remote
implements ToNode,
ToSmithyBuilder<Remote> {
    private final Map<String, Schema> definitions;
    private final Map<String, Property> properties;

    private Remote(Builder builder) {
        this.definitions = new TreeMap<String, Schema>((Map)builder.definitions.copy());
        this.properties = new TreeMap<String, Property>((Map)builder.properties.copy());
    }

    public Node toNode() {
        NodeMapper mapper = new NodeMapper();
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        if (!this.definitions.isEmpty()) {
            builder.withMember("definitions", (ToNode)mapper.serialize(this.definitions));
        }
        if (!this.properties.isEmpty()) {
            builder.withMember("properties", (ToNode)mapper.serialize(this.properties));
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return Remote.builder().definitions(this.definitions).properties(this.properties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Schema> getDefinitions() {
        return this.definitions;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public static final class Builder
    implements SmithyBuilder<Remote> {
        private final BuilderRef<Map<String, Schema>> definitions = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, Property>> properties = BuilderRef.forSortedMap();

        private Builder() {
        }

        public Remote build() {
            return new Remote(this);
        }

        public Builder definitions(Map<String, Schema> definitions) {
            this.definitions.clear();
            definitions.forEach(this::addDefinition);
            return this;
        }

        public Builder addDefinition(String name, Schema definition) {
            ((Map)this.definitions.get()).put(name, definition);
            return this;
        }

        public Builder removeDefinition(String name) {
            ((Map)this.definitions.get()).remove(name);
            return this;
        }

        public Builder clearDefinitions() {
            this.definitions.clear();
            return this;
        }

        public Builder properties(Map<String, Property> properties) {
            this.properties.clear();
            properties.forEach(this::addProperty);
            return this;
        }

        public Builder addProperty(String name, Property property) {
            ((Map)this.properties.get()).put(name, property);
            return this;
        }

        public Builder removeProperty(String name) {
            ((Map)this.properties.get()).remove(name);
            return this;
        }

        public Builder clearProperties() {
            this.properties.clear();
            return this;
        }
    }
}

