/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Property
implements ToNode,
ToSmithyBuilder<Property> {
    private final Schema schema;

    private Property(Builder builder) {
        Schema.Builder schemaBuilder = builder.schema == null ? Schema.builder() : builder.schema.toBuilder();
        if (builder.insertionOrder) {
            schemaBuilder.putExtension("insertionOrder", (ToNode)Node.from((boolean)true));
        }
        if (!builder.dependencies.isEmpty()) {
            schemaBuilder.putExtension("dependencies", (ToNode)Node.fromStrings((Collection)builder.dependencies));
        }
        this.schema = schemaBuilder.build();
    }

    public Node toNode() {
        return this.schema.toNode().expectObjectNode();
    }

    public Builder toBuilder() {
        return Property.builder().schema(this.schema);
    }

    public static Property fromNode(Node node) {
        ObjectNode objectNode = node.expectObjectNode();
        Builder builder = Property.builder();
        builder.schema(Schema.fromNode((Node)objectNode));
        return builder.build();
    }

    public static Property fromSchema(Schema schema) {
        return Property.builder().schema(schema).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isInsertionOrder() {
        Optional<Boolean> insertionOrder = this.schema.getExtension("insertionOrder").map(n -> n.toNode().expectBooleanNode().getValue());
        return insertionOrder.orElse(false);
    }

    public List<String> getDependencies() {
        Optional<List> dependencies = this.schema.getExtension("dependencies").map(n -> n.toNode().expectArrayNode().getElementsAs(StringNode::getValue));
        return dependencies.orElse(Collections.emptyList());
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static final class Builder
    implements SmithyBuilder<Property> {
        private boolean insertionOrder = false;
        private final List<String> dependencies = new ArrayList<String>();
        private Schema schema;

        private Builder() {
        }

        public Property build() {
            return new Property(this);
        }

        public Builder insertionOrder(boolean insertionOrder) {
            this.insertionOrder = insertionOrder;
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.dependencies.clear();
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder addDependency(String dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Builder clearDependencies() {
            this.dependencies.clear();
            return this;
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }
    }
}

