/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers;

import java.util.Optional;
import software.amazon.smithy.aws.cloudformation.schema.CfnConfig;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers.HandlerPermissionMapper;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.aws.cloudformation.schema.model.Tagging;
import software.amazon.smithy.aws.cloudformation.traits.CfnResource;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceIndex;
import software.amazon.smithy.aws.traits.tagging.AwsTagIndex;
import software.amazon.smithy.aws.traits.tagging.TaggableTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public final class TaggingMapper
implements CfnMapper {
    private static final String DEFAULT_TAGS_NAME = "Tags";

    @SmithyInternalApi
    public static void injectTagsMember(CfnConfig config, Model model, ResourceShape resource, StructureShape.Builder builder) {
        String tagMemberName = TaggingMapper.getTagMemberName(config, resource);
        if (resource.hasTrait(TaggableTrait.ID)) {
            AwsTagIndex tagIndex = AwsTagIndex.of((Model)model);
            TaggableTrait trait = (TaggableTrait)resource.expectTrait(TaggableTrait.class);
            CfnResourceIndex resourceIndex = CfnResourceIndex.of((Model)model);
            CfnResource cfnResource = (CfnResource)resourceIndex.getResource((ToShapeId)resource).get();
            if (!trait.getProperty().isPresent() || !cfnResource.getProperties().containsKey(trait.getProperty().get())) {
                if (trait.getProperty().isPresent()) {
                    ShapeId definition = (ShapeId)resource.getProperties().get(trait.getProperty().get());
                    builder.addMember(tagMemberName, definition);
                } else {
                    Optional tagOperation = tagIndex.getTagResourceOperation((ToShapeId)resource.getId());
                    MemberShape member = (MemberShape)tagIndex.getTagsMember((ToShapeId)tagOperation.get()).get();
                    member = ((MemberShape.Builder)member.toBuilder().id(builder.getId().withMember(tagMemberName))).build();
                    builder.addMember(member);
                }
            }
        }
    }

    @Override
    public ResourceSchema after(Context context, ResourceSchema resourceSchema) {
        ResourceShape resourceShape = context.getResource();
        if (!resourceShape.hasTrait(TaggableTrait.ID)) {
            return resourceSchema;
        }
        Model model = context.getModel();
        ServiceShape service = context.getService();
        AwsTagIndex tagsIndex = AwsTagIndex.of((Model)model);
        TaggableTrait trait = (TaggableTrait)resourceShape.expectTrait(TaggableTrait.class);
        Tagging.Builder tagBuilder = Tagging.builder().taggable(true).tagOnCreate(tagsIndex.isResourceTagOnCreate((ToShapeId)resourceShape.getId())).tagProperty("/properties/" + TaggingMapper.getTagMemberName(context.getConfig(), resourceShape)).cloudFormationSystemTags(!trait.getDisableSystemTags()).tagUpdatable(true);
        tagsIndex.getTagResourceOperation((ToShapeId)resourceShape).map(operation -> HandlerPermissionMapper.getPermissionsEntriesForOperation(model, service, operation)).ifPresent(tagBuilder::addPermissions);
        tagsIndex.getListTagsForResourceOperation((ToShapeId)resourceShape).map(operation -> HandlerPermissionMapper.getPermissionsEntriesForOperation(model, service, operation)).ifPresent(tagBuilder::addPermissions);
        tagsIndex.getUntagResourceOperation((ToShapeId)resourceShape).map(operation -> HandlerPermissionMapper.getPermissionsEntriesForOperation(model, service, operation)).ifPresent(tagBuilder::addPermissions);
        return resourceSchema.toBuilder().tagging(tagBuilder.build()).build();
    }

    private static String getTagMemberName(CfnConfig config, ResourceShape resource) {
        return resource.getTrait(TaggableTrait.class).flatMap(TaggableTrait::getProperty).map(property -> {
            if (config.getDisableCapitalizedProperties()) {
                return property;
            }
            return StringUtils.capitalize((String)property);
        }).orElse(DEFAULT_TAGS_NAME);
    }
}

