/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.model.Handler;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.aws.iam.traits.IamActionTrait;
import software.amazon.smithy.aws.iam.traits.RequiredActionsTrait;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.NoReplaceTrait;
import software.amazon.smithy.model.traits.StringListTrait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class HandlerPermissionMapper
implements CfnMapper {
    @Override
    public void before(Context context, ResourceSchema.Builder resourceSchema) {
        if (context.getConfig().getDisableHandlerPermissionGeneration()) {
            return;
        }
        Model model = context.getModel();
        ServiceShape service = context.getService();
        ResourceShape resource = context.getResource();
        Set createPermissions = resource.getCreate().map(operation -> this.getPermissionsEntriesForOperation(model, service, (ShapeId)operation)).orElseGet(TreeSet::new);
        Set updatePermissions = resource.getUpdate().map(operation -> this.getPermissionsEntriesForOperation(model, service, (ShapeId)operation)).orElseGet(TreeSet::new);
        Set putPermissions = resource.getPut().map(operation -> this.getPermissionsEntriesForOperation(model, service, (ShapeId)operation)).orElse(SetUtils.of());
        createPermissions.addAll(putPermissions);
        resource.getPut().map(arg_0 -> ((Model)model).expectShape(arg_0)).filter(shape -> !shape.hasTrait(NoReplaceTrait.class)).ifPresent(shape -> updatePermissions.addAll(putPermissions));
        if (!createPermissions.isEmpty()) {
            resourceSchema.addHandler("create", Handler.builder().permissions(createPermissions).build());
        }
        if (!updatePermissions.isEmpty()) {
            resourceSchema.addHandler("update", Handler.builder().permissions(updatePermissions).build());
        }
        resource.getRead().map(operation -> this.getPermissionsEntriesForOperation(model, service, (ShapeId)operation)).ifPresent(permissions -> resourceSchema.addHandler("read", Handler.builder().permissions((Collection<String>)permissions).build()));
        resource.getDelete().map(operation -> this.getPermissionsEntriesForOperation(model, service, (ShapeId)operation)).ifPresent(permissions -> resourceSchema.addHandler("delete", Handler.builder().permissions((Collection<String>)permissions).build()));
        resource.getList().map(operation -> this.getPermissionsEntriesForOperation(model, service, (ShapeId)operation)).ifPresent(permissions -> resourceSchema.addHandler("list", Handler.builder().permissions((Collection<String>)permissions).build()));
    }

    private Set<String> getPermissionsEntriesForOperation(Model model, ServiceShape service, ShapeId operationId) {
        OperationShape operation = (OperationShape)model.expectShape(operationId, OperationShape.class);
        TreeSet<String> permissionsEntries = new TreeSet<String>();
        String operationActionName = service.getTrait(ServiceTrait.class).map(ServiceTrait::getArnNamespace).orElse(service.getId().getName()).toLowerCase(Locale.US);
        operationActionName = operationActionName + ":" + operationId.getName(service);
        permissionsEntries.add(operationActionName);
        permissionsEntries.addAll(operation.getTrait(IamActionTrait.class).map(IamActionTrait::getRequiredActions).orElseGet(() -> operation.getTrait(RequiredActionsTrait.class).map(StringListTrait::getValues).orElse(ListUtils.of())));
        return permissionsEntries;
    }
}

