/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers;

import java.util.Map;
import java.util.logging.Logger;
import software.amazon.smithy.aws.cloudformation.schema.CfnException;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodePointer;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class JsonAddMapper
implements CfnMapper {
    private static final Logger LOGGER = Logger.getLogger(JsonAddMapper.class.getName());

    JsonAddMapper() {
    }

    @Override
    public byte getOrder() {
        return 124;
    }

    @Override
    public ObjectNode updateNode(Context context, ResourceSchema resourceSchema, ObjectNode node) {
        ShapeId resourceShapeId = context.getResource().getId();
        Map<ShapeId, Map<String, Node>> add = context.getConfig().getJsonAdd();
        if (add.isEmpty() || !add.containsKey(resourceShapeId)) {
            return node;
        }
        ObjectNode result = node;
        for (Map.Entry<String, Node> entry : add.get(resourceShapeId).entrySet()) {
            try {
                LOGGER.info(() -> String.format("CloudFormation `jsonAdd` for `%s`: adding `%s`", resourceShapeId, entry.getKey()));
                result = NodePointer.parse((String)entry.getKey()).addWithIntermediateValues((Node)result, entry.getValue().toNode()).expectObjectNode();
            }
            catch (IllegalArgumentException e) {
                throw new CfnException(e.getMessage(), e);
            }
        }
        return result;
    }
}

