/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.traits;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceIndex;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class CfnResourceProperty
implements ToSmithyBuilder<CfnResourceProperty> {
    private final Set<ShapeId> shapeIds;
    private final Set<CfnResourceIndex.Mutability> mutabilities;
    private final boolean hasExplicitMutability;

    private CfnResourceProperty(Builder builder) {
        this.shapeIds = new TreeSet<ShapeId>((Collection)builder.shapeIds.peek());
        this.mutabilities = (Set)builder.mutabilities.copy();
        this.hasExplicitMutability = builder.hasExplicitMutability;
    }

    public static Builder builder() {
        return new Builder();
    }

    Set<ShapeId> getShapeIds() {
        return this.shapeIds;
    }

    public ShapeId getShapeId() {
        return this.shapeIds.iterator().next();
    }

    public boolean hasExplicitMutability() {
        return this.hasExplicitMutability;
    }

    public Set<CfnResourceIndex.Mutability> getMutabilities() {
        return this.mutabilities;
    }

    public Builder toBuilder() {
        return CfnResourceProperty.builder().shapeIds(this.shapeIds).mutabilities(this.mutabilities);
    }

    public static final class Builder
    implements SmithyBuilder<CfnResourceProperty> {
        private final BuilderRef<Set<ShapeId>> shapeIds = BuilderRef.forSortedSet();
        private final BuilderRef<Set<CfnResourceIndex.Mutability>> mutabilities = BuilderRef.forUnorderedSet();
        private boolean hasExplicitMutability = false;

        public CfnResourceProperty build() {
            return new CfnResourceProperty(this);
        }

        public Builder addShapeId(ShapeId shapeId) {
            ((Set)this.shapeIds.get()).add(shapeId);
            return this;
        }

        public Builder removeShapeId(ShapeId shapeId) {
            ((Set)this.shapeIds.get()).remove(shapeId);
            return this;
        }

        public Builder shapeIds(Set<ShapeId> shapeIds) {
            this.shapeIds.clear();
            shapeIds.forEach(this::addShapeId);
            return this;
        }

        public Builder mutabilities(Set<CfnResourceIndex.Mutability> mutabilities) {
            this.mutabilities.clear();
            ((Set)this.mutabilities.get()).addAll(mutabilities);
            return this;
        }

        public Builder hasExplicitMutability(boolean hasExplicitMutability) {
            this.hasExplicitMutability = hasExplicitMutability;
            return this;
        }
    }
}

