/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import software.amazon.smithy.aws.cloudformation.traits.CfnResource;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceIndex;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceProperty;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;

public final class CfnResourcePropertyValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        CfnResourceIndex cfnResourceIndex = CfnResourceIndex.of(model);
        model.shapes(ResourceShape.class).filter(shape -> shape.hasTrait(CfnResourceTrait.ID)).map(shape -> this.validateResource(model, cfnResourceIndex, (ResourceShape)shape)).forEach(events::addAll);
        return events;
    }

    private List<ValidationEvent> validateResource(Model model, CfnResourceIndex cfnResourceIndex, ResourceShape resource) {
        CfnResourceTrait trait = (CfnResourceTrait)resource.expectTrait(CfnResourceTrait.class);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        String resourceName = trait.getName().orElse(resource.getId().getName());
        cfnResourceIndex.getResource((ToShapeId)resource).map(CfnResource::getProperties).ifPresent(properties -> {
            for (Map.Entry<String, CfnResourceProperty> entry : properties.entrySet()) {
                this.validateResourceProperty(model, resource, resourceName, entry).ifPresent(events::add);
            }
        });
        return events;
    }

    private Optional<ValidationEvent> validateResourceProperty(Model model, ResourceShape resource, String resourceName, Map.Entry<String, CfnResourceProperty> property) {
        TreeSet propertyTargets = new TreeSet();
        for (ShapeId shapeId : property.getValue().getShapeIds()) {
            model.getShape(shapeId).ifPresent(shape -> OptionalUtils.ifPresentOrElse((Optional)shape.asMemberShape(), memberShape -> propertyTargets.add(memberShape.getTarget()), () -> propertyTargets.add(shapeId)));
        }
        if (propertyTargets.size() > 1) {
            return Optional.of(this.error((Shape)resource, String.format("The `%s` property of the generated `%s` CloudFormation resource targets multiple shapes: %s. Reusing member names that target different shapes can cause confusion for users of the API. This target discrepancy must either be resolved in the model or one of the members must be excluded from the conversion.", property.getKey(), resourceName, propertyTargets)));
        }
        return Optional.empty();
    }
}

