/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.traits;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceIndex;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class CfnResourceProperty
implements ToSmithyBuilder<CfnResourceProperty> {
    private final Set<ShapeId> shapeIds = new TreeSet<ShapeId>();
    private final Set<CfnResourceIndex.Mutability> mutabilities;
    private final boolean hasExplicitMutability;

    private CfnResourceProperty(Builder builder) {
        this.shapeIds.addAll(builder.shapeIds);
        this.mutabilities = SetUtils.copyOf((Collection)builder.mutabilities);
        this.hasExplicitMutability = builder.hasExplicitMutability;
    }

    public static Builder builder() {
        return new Builder();
    }

    Set<ShapeId> getShapeIds() {
        return this.shapeIds;
    }

    public ShapeId getShapeId() {
        return this.shapeIds.iterator().next();
    }

    public boolean hasExplicitMutability() {
        return this.hasExplicitMutability;
    }

    public Set<CfnResourceIndex.Mutability> getMutabilities() {
        return this.mutabilities;
    }

    public Builder toBuilder() {
        return CfnResourceProperty.builder().shapeIds(this.shapeIds).mutabilities(this.mutabilities);
    }

    public static final class Builder
    implements SmithyBuilder<CfnResourceProperty> {
        private final Set<ShapeId> shapeIds = new TreeSet<ShapeId>();
        private Set<CfnResourceIndex.Mutability> mutabilities = new HashSet<CfnResourceIndex.Mutability>();
        private boolean hasExplicitMutability = false;

        public CfnResourceProperty build() {
            return new CfnResourceProperty(this);
        }

        public Builder addShapeId(ShapeId shapeId) {
            this.shapeIds.add(shapeId);
            return this;
        }

        public Builder removeShapeId(ShapeId shapeId) {
            this.shapeIds.remove(shapeId);
            return this;
        }

        public Builder shapeIds(Set<ShapeId> shapeIds) {
            this.shapeIds.clear();
            this.shapeIds.addAll(shapeIds);
            return this;
        }

        public Builder mutabilities(Set<CfnResourceIndex.Mutability> mutabilities) {
            this.mutabilities = mutabilities;
            return this;
        }

        public Builder hasExplicitMutability(boolean hasExplicitMutability) {
            this.hasExplicitMutability = hasExplicitMutability;
            return this;
        }
    }
}

