/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware.factories;

import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.RequestCompressionTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.config.RangeConstraint;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;
import software.amazon.smithy.ruby.codegen.util.Streaming;

public final class RequestCompressionMiddlewareFactory {
    private RequestCompressionMiddlewareFactory() {
    }

    public static Middleware build(GenerationContext context) {
        String disableRequestCompressionDocumentation = "When set to 'true' the request body will not be compressed for supported operations.\n";
        ClientConfig disableRequestCompression = ClientConfig.builder().name("disable_request_compression").defaultValue("false").documentation(disableRequestCompressionDocumentation).documentationRbsAndValidationType("Boolean").build();
        String minCompressionDocumentation = "The minimum size bytes that triggers compression for request bodies.\nThe value must be non-negative integer value between 0 and 10485780 bytes inclusive.\n";
        ClientConfig requestMinCompressionSizeBytes = ClientConfig.builder().name("request_min_compression_size_bytes").defaultValue("10240").documentation(minCompressionDocumentation).documentationRbsAndValidationType("Integer").constraint(new RangeConstraint(0L, 0xA00000L)).build();
        Middleware.Relative compressionRelative = Middleware.Relative.builder().before("Hearth::HTTP::Middleware::ContentMD5").optional().build();
        Middleware.Builder compressionBuilder = Middleware.builder().klass("Hearth::HTTP::Middleware::RequestCompression").step(MiddlewareStackStep.AFTER_BUILD).relative(compressionRelative).operationPredicate((model, service, operation) -> operation.hasTrait(RequestCompressionTrait.class)).operationParams((ctx, operation) -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            RequestCompressionTrait requestCompression = (RequestCompressionTrait)operation.expectTrait(RequestCompressionTrait.class);
            Shape inputShape = ctx.model().expectShape(operation.getInputShape());
            params.put("encodings", "[" + requestCompression.getEncodings().stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ")) + "]");
            params.put("streaming", Streaming.isStreaming(ctx.model(), inputShape) ? "true" : "false");
            return params;
        });
        TopDownIndex topDownIndex = TopDownIndex.of((Model)context.model());
        Set containedOperations = topDownIndex.getContainedOperations((ToShapeId)context.service());
        boolean hasCompressionTrait = containedOperations.stream().anyMatch(o -> o.hasTrait(RequestCompressionTrait.class));
        if (hasCompressionTrait) {
            compressionBuilder.addConfig(disableRequestCompression);
            compressionBuilder.addConfig(requestMinCompressionSizeBytes);
        }
        return compressionBuilder.build();
    }
}

