/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.ruby.codegen.ApplicationTransport;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;
import software.amazon.smithy.ruby.codegen.middleware.factories.AuthMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.EndpointMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.HostPrefixMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.InitializeMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.RetryMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.SendMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.SignMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.ValidateMiddlewareFactory;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class MiddlewareBuilder {
    private final Map<MiddlewareStackStep, List<Middleware>> middlewares = new HashMap<MiddlewareStackStep, List<Middleware>>();

    public MiddlewareBuilder() {
        Arrays.stream(MiddlewareStackStep.values()).forEach(step -> this.middlewares.put((MiddlewareStackStep)((Object)step), new ArrayList()));
    }

    public void remove(MiddlewareStackStep step, String klass) {
        this.middlewares.get((Object)step).removeIf(m -> m.getKlass().equals(klass));
    }

    public void register(Middleware middleware) {
        this.middlewares.get((Object)middleware.getStep()).add(middleware);
    }

    public void register(List<Middleware> middleware) {
        middleware.forEach(m -> this.register((Middleware)m));
    }

    public Set<ClientConfig> getClientConfig(GenerationContext context) {
        Model model = context.model();
        ServiceShape service = context.service();
        HashSet<ClientConfig> config = new HashSet<ClientConfig>();
        for (MiddlewareStackStep step : MiddlewareStackStep.values()) {
            Set stepConfig = this.middlewares.get((Object)step).stream().filter(m -> m.includeFor(model, service)).map(m -> m.getClientConfig()).flatMap(Collection::stream).collect(Collectors.toSet());
            config.addAll(stepConfig);
        }
        config.addAll(this.getDefaultClientConfig());
        return config;
    }

    public List<String> writeAdditionalFiles(GenerationContext context) {
        return this.middlewares.values().stream().flatMap(Collection::stream).map(m -> m.writeAdditionalFiles(context)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public void render(RubyCodeWriter writer, GenerationContext context, OperationShape operation) {
        Model model = context.model();
        ServiceShape service = context.service();
        for (MiddlewareStackStep step : MiddlewareStackStep.values()) {
            List<Middleware> orderedStepMiddleware = this.resolveAndFilter(step, model, service, operation);
            for (Middleware middleware : orderedStepMiddleware) {
                middleware.renderAdd(writer, context, operation);
            }
        }
    }

    private List<Middleware> resolveAndFilter(MiddlewareStackStep step, Model model, ServiceShape service, OperationShape operation) {
        HashSet<Middleware> resolved = new HashSet<Middleware>();
        HashSet<Middleware> visiting = new HashSet<Middleware>();
        HashMap<Middleware, Integer> order = new HashMap<Middleware, Integer>();
        HashMap<String, Middleware> klassToMiddlewareMap = new HashMap<String, Middleware>();
        List<Middleware> filteredMiddleware = this.middlewares.get((Object)step).stream().filter(m -> m.includeFor(model, service, operation)).collect(Collectors.toList());
        filteredMiddleware.forEach(m -> klassToMiddlewareMap.put(m.getKlass(), (Middleware)m));
        for (Middleware middleware : filteredMiddleware) {
            this.resolve(middleware, resolved, visiting, order, klassToMiddlewareMap);
        }
        return filteredMiddleware.stream().sorted(Comparator.comparingInt(order::get)).collect(Collectors.toList());
    }

    private void resolve(Middleware middleware, Set<Middleware> resolved, Set<Middleware> visiting, Map<Middleware, Integer> order, Map<String, Middleware> klassToMiddlewareMap) {
        if (visiting.contains(middleware)) {
            throw new IllegalArgumentException("Circular dependency detected when resolving order for middleware: " + middleware.getKlass());
        }
        if (!resolved.contains(middleware)) {
            visiting.add(middleware);
            if (middleware.getRelative().isPresent()) {
                Middleware.Relative relative = middleware.getRelative().get();
                Middleware relativeTo = klassToMiddlewareMap.get(relative.getTo());
                if (relativeTo != null) {
                    this.resolve(relativeTo, resolved, visiting, order, klassToMiddlewareMap);
                    if (relative.getType().equals((Object)Middleware.Relative.Type.BEFORE)) {
                        order.put(middleware, order.get(relativeTo) - 1);
                    } else {
                        order.put(middleware, order.get(relativeTo) + 1);
                    }
                } else {
                    this.resolveMissingRelativeTo(relative, middleware, order);
                }
            } else {
                order.put(middleware, Integer.valueOf(middleware.getOrder()));
            }
            visiting.remove(middleware);
            resolved.add(middleware);
        }
    }

    private void resolveMissingRelativeTo(Middleware.Relative relative, Middleware middleware, Map<Middleware, Integer> order) {
        if (relative.getRelativeRequired()) {
            throw new IllegalArgumentException(middleware.getKlass() + " relative references a required middleware class (" + relative.getTo() + ") that is not available in stack.");
        }
        order.put(middleware, Integer.valueOf(middleware.getOrder()));
    }

    public void addDefaultMiddleware(GenerationContext context) {
        ApplicationTransport transport = context.applicationTransport();
        this.register(InitializeMiddlewareFactory.build(context));
        this.register(ValidateMiddlewareFactory.build(context));
        this.register(RetryMiddlewareFactory.build(context));
        this.register(AuthMiddlewareFactory.build(context));
        this.register(EndpointMiddlewareFactory.build(context));
        this.register(HostPrefixMiddlewareFactory.build(context));
        this.register(SignMiddlewareFactory.build(context));
        this.register(SendMiddlewareFactory.build(context));
        this.register(transport.defaultMiddleware(context));
    }

    private Collection<? extends ClientConfig> getDefaultClientConfig() {
        ClientConfig logger = ClientConfig.builder().name("logger").defaultValue("Logger.new(IO::NULL)").documentation("The Logger instance to use for logging.").documentationRbsAndValidationType("Logger").documentationDefaultValue("Logger.new(IO::NULL)").build();
        String pluginDocumentation = "A list of Plugins to apply to the client. Plugins are callables that\ntake {Config} as an argument. Plugins may modify the provided config.\n";
        ClientConfig plugins = ClientConfig.builder().name("plugins").defaultValue(Hearth.PLUGIN_LIST + ".new").documentation(pluginDocumentation).rbsType(Hearth.PLUGIN_LIST + "[Config]").validateType(Hearth.PLUGIN_LIST.toString()).documentationType(Hearth.PLUGIN_LIST.toString()).documentationDefaultValue(Hearth.PLUGIN_LIST + ".new").build();
        String interceptorDocumentation = "A list of Interceptors to apply to the client.  Interceptors are a generic\nextension point that allows injecting logic at specific stages of execution\nwithin the SDK. Logic injection is done with hooks that the interceptor\nimplements.  Hooks are either read-only or read/write. Read-only hooks allow\nan interceptor to read the input, transport request, transport response or\noutput messages. Read/write hooks allow an interceptor to modify one of these\nmessages.\n";
        ClientConfig interceptors = ClientConfig.builder().name("interceptors").defaultValue(Hearth.INTERCEPTOR_LIST + ".new").documentation(interceptorDocumentation).rbsType(Hearth.INTERCEPTOR_LIST.toString()).documentationRbsAndValidationType(Hearth.INTERCEPTOR_LIST.toString()).documentationDefaultValue(Hearth.INTERCEPTOR_LIST + ".new").build();
        return Arrays.asList(logger, plugins, interceptors);
    }
}

