/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.CustomizeDirective;
import software.amazon.smithy.jmespath.ExpressionSerializer;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathExpression;
import software.amazon.smithy.jmespath.ast.AndExpression;
import software.amazon.smithy.jmespath.ast.ComparatorExpression;
import software.amazon.smithy.jmespath.ast.CurrentExpression;
import software.amazon.smithy.jmespath.ast.ExpressionTypeExpression;
import software.amazon.smithy.jmespath.ast.FieldExpression;
import software.amazon.smithy.jmespath.ast.FilterProjectionExpression;
import software.amazon.smithy.jmespath.ast.FlattenExpression;
import software.amazon.smithy.jmespath.ast.FunctionExpression;
import software.amazon.smithy.jmespath.ast.IndexExpression;
import software.amazon.smithy.jmespath.ast.LiteralExpression;
import software.amazon.smithy.jmespath.ast.MultiSelectHashExpression;
import software.amazon.smithy.jmespath.ast.MultiSelectListExpression;
import software.amazon.smithy.jmespath.ast.NotExpression;
import software.amazon.smithy.jmespath.ast.ObjectProjectionExpression;
import software.amazon.smithy.jmespath.ast.OrExpression;
import software.amazon.smithy.jmespath.ast.ProjectionExpression;
import software.amazon.smithy.jmespath.ast.SliceExpression;
import software.amazon.smithy.jmespath.ast.Subexpression;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.waiters.Acceptor;
import software.amazon.smithy.waiters.AcceptorState;
import software.amazon.smithy.waiters.Matcher;
import software.amazon.smithy.waiters.WaitableTrait;
import software.amazon.smithy.waiters.Waiter;

@SmithyInternalApi
public class WaitersGenerator
extends RubyGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(WaitersGenerator.class.getName());
    private final Set<OperationShape> operations;

    public WaitersGenerator(CustomizeDirective<GenerationContext, RubySettings> directive) {
        super((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.operations = directive.operations();
    }

    @Override
    String getModule() {
        return "Waiters";
    }

    public void render() {
        this.write(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("module Waiters", new Object[0])).call(() -> this.renderWaiters((RubyCodeWriter)((Object)writer), false))).write("", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote waiters to " + this.rbFile());
    }

    public void renderRbs() {
        this.writeRbs(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("module Waiters", new Object[0])).call(() -> this.renderWaiters((RubyCodeWriter)((Object)writer), true))).write("", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote waiters rbs to " + this.rbsFile());
    }

    private void renderWaiters(RubyCodeWriter writer, Boolean rbs) {
        this.operations.forEach(operation -> {
            if (operation.hasTrait(WaitableTrait.class)) {
                Map waiters = ((WaitableTrait)operation.getTrait(WaitableTrait.class).get()).getWaiters();
                Iterator iterator = waiters.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String waiterName = (String)entry.getKey();
                    Waiter waiter = (Waiter)entry.getValue();
                    if (rbs.booleanValue()) {
                        this.renderRbsWaiter(writer, waiterName);
                    } else {
                        this.renderWaiter(writer, waiterName, waiter, (OperationShape)operation);
                    }
                    if (!iterator.hasNext()) continue;
                    writer.write("", new Object[0]);
                }
            }
        });
    }

    private void renderWaiter(RubyCodeWriter writer, String waiterName, Waiter waiter, OperationShape operation) {
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).call(() -> this.renderWaiterDocumentation(writer, waiter))).openBlock("class $L", new Object[]{waiterName})).call(() -> this.renderWaiterInitializeDocumentation(writer, waiter))).openBlock("def initialize(client, options = {})", new Object[0])).write("@client = client", new Object[0])).openBlock("@waiter = $T.new({", new Object[]{Hearth.WAITER})).write("max_wait_time: options[:max_wait_time],", new Object[0])).write("min_delay: options[:min_delay] || $L,", new Object[]{waiter.getMinDelay()})).write("max_delay: options[:max_delay] || $L,", new Object[]{waiter.getMaxDelay()})).openBlock("poller: $T.new(", new Object[]{Hearth.POLLER})).write("operation_name: :$L,", new Object[]{operationName})).call(() -> this.renderAcceptors(writer, waiter))).closeBlock(")", new Object[0])).closeBlock("}.merge(options))", new Object[0])).call(() -> this.renderWaiterTags(writer, waiter))).closeBlock("end", new Object[0])).write("", new Object[0])).writeYardReturn("Array<String>", "").write("attr_reader :tags", new Object[0])).write("", new Object[0])).call(() -> this.renderWaiterWaitDocumentation(writer, operationName))).openBlock("def wait(params = {}, options = {})", new Object[0])).write("@waiter.wait(@client, params, options)", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderRbsWaiter(RubyCodeWriter writer, String waiterName) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).openBlock("class $L", new Object[]{waiterName})).write("def initialize: (Client, ?::Hash[::Symbol, untyped] options) -> void\n", new Object[0])).write("attr_reader tags: Array[::String]\n", new Object[0])).write("def wait: (?::Hash[::Symbol, untyped] params, ?::Hash[::Symbol, untyped] options) -> true", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderWaiterDocumentation(RubyCodeWriter writer, Waiter waiter) {
        if (waiter.getDocumentation().isPresent()) {
            writer.writeDocstring((String)waiter.getDocumentation().get());
        }
        if (waiter.isDeprecated()) {
            writer.writeYardDeprecated("This waiter is deprecated.", "");
        }
    }

    private void renderWaiterTags(RubyCodeWriter writer, Waiter waiter) {
        String tags = waiter.getTags().stream().map(tag -> "\"" + tag + "\"").collect(Collectors.joining(", "));
        writer.write("@tags = [$L]", new Object[]{tags});
    }

    private void renderAcceptors(RubyCodeWriter writer, Waiter waiter) {
        List acceptorsList = waiter.getAcceptors();
        if (acceptorsList.isEmpty()) {
            writer.write("acceptors: []", new Object[0]);
        } else {
            writer.openBlock("acceptors: [", new Object[0]);
            Iterator iterator = acceptorsList.iterator();
            while (iterator.hasNext()) {
                Acceptor acceptor = (Acceptor)iterator.next();
                Matcher matcher = acceptor.getMatcher();
                AcceptorState state = acceptor.getState();
                ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("{", new Object[0])).write("state: '$L',", new Object[]{state})).openBlock("matcher: {", new Object[0])).call(() -> matcher.accept((Matcher.Visitor)new AcceptorVisitor(writer)))).closeBlock("}", new Object[0]);
                if (iterator.hasNext()) {
                    writer.closeBlock("},", new Object[0]);
                    continue;
                }
                writer.closeBlock("}", new Object[0]);
            }
            writer.closeBlock("]", new Object[0]);
        }
    }

    private String translatePath(String path) {
        JmespathExpression transformedExpression = (JmespathExpression)JmespathExpression.parse((String)path).accept((ExpressionVisitor)new JmespathTranslator());
        String transformedPath = new ExpressionSerializer().serialize(transformedExpression);
        return transformedPath;
    }

    private void renderWaiterWaitDocumentation(RubyCodeWriter writer, String operationName) {
        writer.writeYardReference("param", "Client#" + operationName).writeYardReturn("true", "").writeYardRaise("Hearth::Waiters::FailureStateError", "").writeYardRaise("Hearth::Waiters::MaxWaitTimeExceededError", "").writeYardRaise("Hearth::Waiters::UnexpectedError", "");
    }

    private void renderWaiterInitializeDocumentation(RubyCodeWriter writer, Waiter waiter) {
        writer.writeYardParam("Client", "client", "").writeYardParam("Hash", "options", "Waiter options").writeYardOption("options", "required, Integer", ":max_wait_time", "", "The maximum time in seconds to wait before the waiter gives up.").writeYardOption("options", "Integer", ":min_delay", "" + waiter.getMinDelay(), "The minimum time in seconds to delay polling attempts.").writeYardOption("options", "Integer", ":max_delay", "" + waiter.getMaxDelay(), "The maximum time in seconds to delay polling attempts.");
    }

    private static class JmespathTranslator
    implements ExpressionVisitor<JmespathExpression> {
        private JmespathTranslator() {
        }

        public JmespathExpression visitComparator(ComparatorExpression expression) {
            return new ComparatorExpression(expression.getComparator(), (JmespathExpression)expression.getLeft().accept((ExpressionVisitor)this), (JmespathExpression)expression.getRight().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitCurrentNode(CurrentExpression expression) {
            return new CurrentExpression(expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitExpressionType(ExpressionTypeExpression expression) {
            return new ExpressionTypeExpression((JmespathExpression)expression.getExpression().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitFlatten(FlattenExpression expression) {
            return new FlattenExpression((JmespathExpression)expression.getExpression().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitFunction(FunctionExpression expression) {
            return new FunctionExpression(expression.getName(), expression.getArguments().stream().map(e -> (JmespathExpression)e.accept((ExpressionVisitor)this)).collect(Collectors.toList()), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitField(FieldExpression expression) {
            return new FieldExpression(RubySymbolProvider.toMemberName(expression.getName()), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitIndex(IndexExpression expression) {
            return new IndexExpression(expression.getIndex(), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitLiteral(LiteralExpression expression) {
            return new LiteralExpression(expression.getValue(), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitMultiSelectList(MultiSelectListExpression expression) {
            return new MultiSelectListExpression(expression.getExpressions().stream().map(e -> (JmespathExpression)e.accept((ExpressionVisitor)this)).collect(Collectors.toList()), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitMultiSelectHash(MultiSelectHashExpression expression) {
            HashMap<String, JmespathExpression> newExpression = new HashMap<String, JmespathExpression>();
            for (Map.Entry entry : expression.getExpressions().entrySet()) {
                newExpression.put((String)entry.getKey(), (JmespathExpression)((JmespathExpression)entry.getValue()).accept((ExpressionVisitor)this));
            }
            return new MultiSelectHashExpression(newExpression, expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitAnd(AndExpression expression) {
            return new AndExpression((JmespathExpression)expression.getLeft().accept((ExpressionVisitor)this), (JmespathExpression)expression.getRight().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitOr(OrExpression expression) {
            return new OrExpression((JmespathExpression)expression.getLeft().accept((ExpressionVisitor)this), (JmespathExpression)expression.getRight().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitNot(NotExpression expression) {
            return new NotExpression((JmespathExpression)expression.getExpression().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitProjection(ProjectionExpression expression) {
            return new ProjectionExpression((JmespathExpression)expression.getLeft().accept((ExpressionVisitor)this), (JmespathExpression)expression.getRight().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitFilterProjection(FilterProjectionExpression expression) {
            return new FilterProjectionExpression((JmespathExpression)expression.getLeft().accept((ExpressionVisitor)this), (JmespathExpression)expression.getComparison().accept((ExpressionVisitor)this), (JmespathExpression)expression.getRight().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitObjectProjection(ObjectProjectionExpression expression) {
            return new ObjectProjectionExpression((JmespathExpression)expression.getLeft().accept((ExpressionVisitor)this), (JmespathExpression)expression.getRight().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitSlice(SliceExpression expression) {
            return new SliceExpression(expression.getStart().isPresent() ? Integer.valueOf(expression.getStart().getAsInt()) : null, expression.getStop().isPresent() ? Integer.valueOf(expression.getStop().getAsInt()) : null, expression.getStep(), expression.getLine(), expression.getColumn());
        }

        public JmespathExpression visitSubexpression(Subexpression expression) {
            return new Subexpression((JmespathExpression)expression.getLeft().accept((ExpressionVisitor)this), (JmespathExpression)expression.getRight().accept((ExpressionVisitor)this), expression.getLine(), expression.getColumn(), expression.isPipe());
        }
    }

    private final class AcceptorVisitor
    implements Matcher.Visitor<Void> {
        private final RubyCodeWriter writer;

        private AcceptorVisitor(RubyCodeWriter writer) {
            this.writer = writer;
        }

        private void renderPathMatcher(String memberName, String path, String comparator, String expected) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("$L: {", new Object[]{memberName})).write("path: $S,", new Object[]{WaitersGenerator.this.translatePath(path)})).write("comparator: \"$L\",", new Object[]{comparator})).write("expected: '$L'", new Object[]{expected})).closeBlock("}", new Object[0]);
        }

        public Void visitOutput(Matcher.OutputMember outputPath) {
            this.renderPathMatcher(outputPath.getMemberName(), outputPath.getValue().getPath(), outputPath.getValue().getComparator().toString(), outputPath.getValue().getExpected());
            return null;
        }

        public Void visitInputOutput(Matcher.InputOutputMember inputOutputPath) {
            this.renderPathMatcher(inputOutputPath.getMemberName(), inputOutputPath.getValue().getPath(), inputOutputPath.getValue().getComparator().toString(), inputOutputPath.getValue().getExpected());
            return null;
        }

        public Void visitSuccess(Matcher.SuccessMember success) {
            this.writer.write("$L: $L", new Object[]{success.getMemberName(), success.getValue() != false ? "true" : "false"});
            return null;
        }

        public Void visitErrorType(Matcher.ErrorTypeMember errorType) {
            this.writer.write("$L: '$L'", new Object[]{errorType.getMemberName(), errorType.getValue()});
            return null;
        }

        public Void visitUnknown(Matcher.UnknownMember unknown) {
            return null;
        }
    }
}

