/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.nio.file.Paths;
import java.util.function.Consumer;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;

abstract class RubyGeneratorBase {
    final Model model;
    final SymbolProvider symbolProvider;
    final RubySettings settings;
    final GenerationContext context;

    RubyGeneratorBase(ContextualDirective<GenerationContext, RubySettings> directive) {
        this.symbolProvider = directive.symbolProvider();
        this.settings = (RubySettings)directive.settings();
        this.context = (GenerationContext)directive.context();
        this.model = directive.model();
    }

    abstract String getModule();

    public final void write(Consumer<RubyCodeWriter> writerConsumer) {
        this.write(this.rbFile(), this.nameSpace(), writerConsumer);
    }

    public final void writeRbs(Consumer<RubyCodeWriter> writerConsumer) {
        this.write(this.rbsFile(), this.nameSpace(), writerConsumer);
    }

    public final void write(String file, String namespace, Consumer<RubyCodeWriter> writerConsumer) {
        this.context.writerDelegator().useFileWriter(file, namespace, writerConsumer);
    }

    public String nameSpace() {
        return this.settings.getModule() + "::" + this.getModule();
    }

    public String rbFile() {
        return Paths.get(this.settings.getGemName(), "lib", this.settings.getGemName(), RubyFormatter.toSnakeCase(this.getModule()) + ".rb").toString();
    }

    public String rbsFile() {
        return Paths.get(this.settings.getGemName(), "sig", this.settings.getGemName(), RubyFormatter.toSnakeCase(this.getModule()) + ".rbs").toString();
    }
}

