/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.IdempotencyTokenTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ParamsGenerator
extends RubyGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(ParamsGenerator.class.getName());

    public ParamsGenerator(ContextualDirective<GenerationContext, RubySettings> directive) {
        super(directive);
    }

    @Override
    String getModule() {
        return "Params";
    }

    public void render() {
        this.write(writer -> ((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().addModule(this.settings.getModule()).apiPrivate().addModule("Params").call(() -> this.renderParams((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).closeAllModules());
        LOGGER.fine("Wrote params to " + this.rbFile());
    }

    private void renderParams(RubyCodeWriter writer) {
        Model modelWithoutTraitShapes = ModelTransformer.create().getModelWithoutTraitShapes(this.model);
        new Walker(modelWithoutTraitShapes).walkShapes((Shape)this.context.service()).stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(shape -> shape.accept((ShapeVisitor)new Visitor(writer)));
    }

    private final class Visitor
    extends ShapeVisitor.Default<Void> {
        private final RubyCodeWriter writer;

        private Visitor(RubyCodeWriter writer) {
            this.writer = writer;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape structureShape) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ParamsGenerator.this.symbolProvider.toSymbol((Shape)structureShape).getName()})).openBlock("def self.build(params, context:)", new Object[0])).call(() -> this.renderBuilderForStructureMembers(ParamsGenerator.this.context.symbolProvider().toSymbol((Shape)structureShape), structureShape.members()))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }

        private void renderBuilderForStructureMembers(Symbol symbol, Collection<MemberShape> members) {
            ((RubyCodeWriter)((RubyCodeWriter)this.writer.write("$T.validate_types!(params, ::Hash, $T, context: context)", new Object[]{Hearth.VALIDATOR, symbol})).write("type = $T.new", new Object[]{symbol})).write("$T.validate_unknown!(type, params, context: context) if params.is_a?(Hash)", new Object[]{Hearth.VALIDATOR});
            members.forEach(member -> {
                Shape target = ParamsGenerator.this.model.expectShape(member.getTarget());
                String memberName = ParamsGenerator.this.symbolProvider.toMemberName(member);
                String memberSetter = "type." + memberName + " = ";
                String symbolName = RubyFormatter.asSymbol(memberName);
                String input = "params[" + symbolName + "]";
                String contextKey = "\"#{context}[" + symbolName + "]\"";
                target.accept((ShapeVisitor)new MemberBuilder(ParamsGenerator.this.model, this.writer, ParamsGenerator.this.context.symbolProvider(), memberSetter, input, contextKey, (MemberShape)member, true));
            });
            this.writer.write("type", new Object[0]);
        }

        public Void listShape(ListShape listShape) {
            Shape memberTarget = ParamsGenerator.this.model.expectShape(listShape.getMember().getTarget());
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ParamsGenerator.this.symbolProvider.toSymbol((Shape)listShape).getName()})).openBlock("def self.build(params, context:)", new Object[0])).write("$T.validate_types!(params, ::Array, context: context)", new Object[]{Hearth.VALIDATOR})).write("data = []", new Object[0])).call(() -> {
                if (this.isComplexShape(memberTarget)) {
                    this.writer.openBlock("params.each_with_index do |element, index|", new Object[0]);
                } else {
                    this.writer.openBlock("params.each do |element|", new Object[0]);
                }
            })).call(() -> memberTarget.accept((ShapeVisitor)new MemberBuilder(ParamsGenerator.this.model, this.writer, ParamsGenerator.this.symbolProvider, "data << ", "element", "\"#{context}[#{index}]\"", listShape.getMember(), !listShape.hasTrait(SparseTrait.class))))).closeBlock("end", new Object[0])).write("data", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape mapShape) {
            Shape valueTarget = ParamsGenerator.this.model.expectShape(mapShape.getValue().getTarget());
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ParamsGenerator.this.symbolProvider.toSymbol((Shape)mapShape).getName()})).openBlock("def self.build(params, context:)", new Object[0])).write("$T.validate_types!(params, ::Hash, context: context)", new Object[]{Hearth.VALIDATOR})).write("data = {}", new Object[0])).openBlock("params.each do |key, value|", new Object[0])).call(() -> valueTarget.accept((ShapeVisitor)new MemberBuilder(ParamsGenerator.this.model, this.writer, ParamsGenerator.this.context.symbolProvider(), "data[key] = ", "value", "\"#{context}[:#{key}]\"", mapShape.getValue(), !mapShape.hasTrait(SparseTrait.class))))).closeBlock("end", new Object[0])).write("data", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            String name = ParamsGenerator.this.symbolProvider.toSymbol((Shape)shape).getName();
            Symbol typeSymbol = ParamsGenerator.this.context.symbolProvider().toSymbol((Shape)shape);
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{name})).openBlock("def self.build(params, context:)", new Object[0])).write("return params if params.is_a?($T)", new Object[]{typeSymbol})).write("$T.validate_types!(params, ::Hash, $T, context: context)", new Object[]{Hearth.VALIDATOR, typeSymbol})).openBlock("unless params.size == 1", new Object[0])).write("raise ArgumentError,", new Object[0])).indent(3)).write("\"Expected #{context} to have exactly one member, got: #{params}\"", new Object[0])).dedent(3)).closeBlock("end", new Object[0])).write("key, value = params.flatten", new Object[0])).write("case key", new Object[0]);
            for (MemberShape member2 : shape.members()) {
                Shape target = ParamsGenerator.this.model.expectShape(member2.getTarget());
                String memberClassName = ParamsGenerator.this.symbolProvider.toMemberName(member2);
                String memberName = RubyFormatter.asSymbol(memberClassName);
                ((RubyCodeWriter)((RubyCodeWriter)this.writer.write("when $L", new Object[]{memberName})).indent()).openBlock("$T.new(", new Object[]{ParamsGenerator.this.context.symbolProvider().toSymbol((Shape)member2)});
                String input = "params[" + memberName + "]";
                String contextString = "\"#{context}[" + memberName + "]\"";
                target.accept((ShapeVisitor)new MemberBuilder(ParamsGenerator.this.model, this.writer, ParamsGenerator.this.symbolProvider, "", input, contextString, member2, false));
                ((RubyCodeWriter)this.writer.closeBlock(")", new Object[0])).dedent();
            }
            String expectedMembers = shape.members().stream().map(member -> RubyFormatter.asSymbol(member.getMemberName())).collect(Collectors.joining(", "));
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("else", new Object[0])).indent()).write("raise ArgumentError,", new Object[0])).indent(3)).write("\"Expected #{context} to have one of $L set\"", new Object[]{expectedMembers})).dedent(4);
            ((RubyCodeWriter)((RubyCodeWriter)this.writer.write("end", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }

        private boolean isComplexShape(Shape shape) {
            return shape.isStructureShape() || shape.isListShape() || shape.isMapShape() || shape.isUnionShape() || shape.isOperationShape();
        }

        private static class MemberBuilder
        extends ShapeVisitor.Default<Void> {
            private final Model model;
            private final RubyCodeWriter writer;
            private final SymbolProvider symbolProvider;
            private final String memberSetter;
            private final String input;
            private final String context;
            private final MemberShape memberShape;
            private final Optional<String> defaultValue;
            private final boolean checkRequired;
            private final String rubySymbol;

            MemberBuilder(Model model, RubyCodeWriter writer, SymbolProvider symbolProvider, String memberSetter, String input, String context, MemberShape memberShape, boolean checkRequired) {
                boolean containsRequiredAndDefaultTraits;
                this.model = model;
                this.writer = writer;
                this.symbolProvider = symbolProvider;
                this.memberSetter = memberSetter;
                this.input = input;
                this.context = context;
                this.memberShape = memberShape;
                this.checkRequired = checkRequired;
                this.rubySymbol = RubyFormatter.asSymbol(symbolProvider.toMemberName(memberShape));
                boolean bl = containsRequiredAndDefaultTraits = memberShape.hasTrait(DefaultTrait.class) && !((DefaultTrait)memberShape.expectTrait(DefaultTrait.class)).toNode().isNullNode() && memberShape.hasTrait(RequiredTrait.class);
                if (containsRequiredAndDefaultTraits) {
                    Shape targetShape = model.expectShape(memberShape.getTarget());
                    String defaultValue = (String)targetShape.accept((ShapeVisitor)new DefaultValueRetriever(memberShape));
                    this.defaultValue = Optional.of(defaultValue);
                } else {
                    this.defaultValue = Optional.empty();
                }
            }

            protected Void getDefault(Shape shape) {
                if (this.defaultValue.isPresent()) {
                    this.writer.write("$1Lparams.fetch($2L, $3L)", new Object[]{this.memberSetter, this.rubySymbol, this.defaultValue.get()});
                } else {
                    this.writer.write("$L$L", new Object[]{this.memberSetter, this.input});
                }
                return null;
            }

            public Void floatShape(FloatShape shape) {
                if (this.defaultValue.isPresent()) {
                    this.writer.write("$1Lparams.fetch($2L, $3L).to_f", new Object[]{this.memberSetter, this.rubySymbol, this.defaultValue.get()});
                } else {
                    this.writer.write("$L$L&.to_f", new Object[]{this.memberSetter, this.input});
                }
                return null;
            }

            public Void doubleShape(DoubleShape shape) {
                if (this.defaultValue.isPresent()) {
                    this.writer.write("$1Lparams.fetch($2L, $3L).to_f", new Object[]{this.memberSetter, this.rubySymbol, this.defaultValue.get()});
                } else {
                    this.writer.write("$L$L&.to_f", new Object[]{this.memberSetter, this.input});
                }
                return null;
            }

            public Void blobShape(BlobShape shape) {
                if (shape.hasTrait(StreamingTrait.class)) {
                    ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("io = $L || StringIO.new", new Object[]{this.input})).openBlock("unless io.respond_to?(:read) || io.respond_to?(:readpartial)", new Object[0])).write("io = StringIO.new(io)", new Object[0])).closeBlock("end", new Object[0])).write("$Lio", new Object[]{this.memberSetter});
                } else {
                    this.getDefault((Shape)shape);
                }
                return null;
            }

            public Void stringShape(StringShape shape) {
                if (this.memberShape.hasTrait(IdempotencyTokenTrait.class) || shape.hasTrait(IdempotencyTokenTrait.class)) {
                    this.writer.write("$L$L || $T.uuid", new Object[]{this.memberSetter, this.input, RubyImportContainer.SECURE_RANDOM});
                } else {
                    this.getDefault((Shape)shape);
                }
                return null;
            }

            public Void listShape(ListShape shape) {
                this.defaultComplex((Shape)shape);
                return null;
            }

            public Void mapShape(MapShape shape) {
                this.defaultComplex((Shape)shape);
                return null;
            }

            public Void structureShape(StructureShape shape) {
                this.defaultComplex((Shape)shape);
                return null;
            }

            public Void unionShape(UnionShape shape) {
                this.defaultComplex((Shape)shape);
                return null;
            }

            private void defaultComplex(Shape shape) {
                if (this.defaultValue.isPresent()) {
                    if (this.checkRequired) {
                        this.writer.write("$1L$2L.build(params.fetch($3L, $5L), context: $4L)", new Object[]{this.memberSetter, this.symbolProvider.toSymbol(shape).getName(), this.rubySymbol, this.context, this.defaultValue.get()});
                    } else {
                        this.writer.write("$1L($2L.build(params.fetch($3L, $5L), context: $4L))", new Object[]{this.memberSetter, this.symbolProvider.toSymbol(shape).getName(), this.rubySymbol, this.context, this.defaultValue.get()});
                    }
                    return;
                }
                if (this.checkRequired) {
                    this.writer.write("$1L$2L.build($3L, context: $4L) unless $3L.nil?", new Object[]{this.memberSetter, this.symbolProvider.toSymbol(shape).getName(), this.input, this.context});
                } else {
                    this.writer.write("$1L($2L.build($3L, context: $4L) unless $3L.nil?)", new Object[]{this.memberSetter, this.symbolProvider.toSymbol(shape).getName(), this.input, this.context});
                }
            }
        }

        private static final class DefaultValueRetriever
        extends ShapeVisitor.Default<String> {
            private final Node defaultNode;

            private DefaultValueRetriever(MemberShape memberShape) {
                this.defaultNode = ((DefaultTrait)memberShape.expectTrait(DefaultTrait.class)).toNode();
            }

            protected String getDefault(Shape shape) {
                return "nil";
            }

            public String blobShape(BlobShape shape) {
                return this.getDefaultString();
            }

            public String booleanShape(BooleanShape shape) {
                return this.getDefaultBoolean();
            }

            public String stringShape(StringShape shape) {
                return this.getDefaultString();
            }

            public String byteShape(ByteShape shape) {
                return String.valueOf(this.getDefaultNumber().byteValue());
            }

            public String shortShape(ShortShape shape) {
                return String.valueOf(this.getDefaultNumber().shortValue());
            }

            public String integerShape(IntegerShape shape) {
                return String.valueOf(this.getDefaultNumber().intValue());
            }

            public String longShape(LongShape shape) {
                return String.valueOf(this.getDefaultNumber().longValue());
            }

            public String floatShape(FloatShape shape) {
                return String.valueOf(this.getDefaultNumber().shortValue());
            }

            public String doubleShape(DoubleShape shape) {
                return String.valueOf(this.getDefaultNumber().doubleValue());
            }

            public String bigIntegerShape(BigIntegerShape shape) {
                return String.valueOf(this.getDefaultNumber().intValue());
            }

            public String bigDecimalShape(BigDecimalShape shape) {
                return String.valueOf(this.getDefaultNumber().floatValue());
            }

            public String enumShape(EnumShape shape) {
                return this.getDefaultString();
            }

            public String intEnumShape(IntEnumShape shape) {
                return String.valueOf(this.getDefaultNumber().intValue());
            }

            public String listShape(ListShape shape) {
                if (this.defaultNode.asArrayNode().isPresent()) {
                    return "[]";
                }
                return "nil";
            }

            public String mapShape(MapShape shape) {
                if (this.defaultNode.asObjectNode().isPresent()) {
                    return "{}";
                }
                return "nil";
            }

            public String documentShape(DocumentShape shape) {
                if (this.defaultNode.asNumberNode().isPresent()) {
                    return this.getDefaultNumber().toString();
                }
                if (this.defaultNode.asBooleanNode().isPresent()) {
                    return this.getDefaultBoolean();
                }
                if (this.defaultNode.asStringNode().isPresent()) {
                    return this.getDefaultString();
                }
                if (this.defaultNode.asArrayNode().isPresent()) {
                    return "[]";
                }
                if (this.defaultNode.asObjectNode().isPresent()) {
                    return "{}";
                }
                return "nil";
            }

            public String timestampShape(TimestampShape shape) {
                if (this.defaultNode.isStringNode()) {
                    return this.getDefaultString();
                }
                if (this.defaultNode.isNumberNode()) {
                    return String.valueOf(this.getDefaultNumber());
                }
                return "nil";
            }

            private String getDefaultString() {
                return String.format("\"%s\"", this.defaultNode.expectStringNode().getValue());
            }

            private String getDefaultBoolean() {
                return String.valueOf(this.defaultNode.expectBooleanNode().getValue());
            }

            private Number getDefaultNumber() {
                return this.defaultNode.expectNumberNode().getValue();
            }
        }
    }
}

