/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.GenerateServiceDirective;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareBuilder;
import software.amazon.smithy.ruby.codegen.util.Streaming;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class MiddlewareGenerator
extends RubyGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(MiddlewareGenerator.class.getName());
    private final Set<OperationShape> operations;
    private final MiddlewareBuilder middlewareBuilder;

    public MiddlewareGenerator(GenerateServiceDirective<GenerationContext, RubySettings> directive, MiddlewareBuilder middlewareBuilder) {
        super((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.operations = directive.operations();
        this.middlewareBuilder = middlewareBuilder;
    }

    @Override
    String getModule() {
        return "Middleware";
    }

    public void render() {
        List<String> additionalFiles = this.middlewareBuilder.writeAdditionalFiles(this.context);
        additionalFiles.sort(String::compareTo);
        this.write(writer -> ((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().writeRequireRelativeAdditionalFiles(additionalFiles).addModule(this.settings.getModule()).apiPrivate().addModule("Middleware").call(() -> this.renderOperations((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).closeAllModules());
        LOGGER.fine("Wrote middleware to " + this.rbFile());
    }

    private void renderOperations(RubyCodeWriter writer) {
        this.operations.stream().filter(o -> !Streaming.isEventStreaming(this.model, o)).sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> this.renderOperation(writer, (OperationShape)o));
    }

    private void renderOperation(RubyCodeWriter writer, OperationShape operation) {
        String operationName = this.symbolProvider.toSymbol((Shape)operation).getName();
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).openBlock("class $L", new Object[]{operationName})).openBlock("def self.build(config)", new Object[0])).write("stack = $T.new", new Object[]{Hearth.MIDDLEWARE_STACK})).call(() -> this.middlewareBuilder.render(writer, this.context, operation))).write("stack", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
    }
}

