/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.WriteAdditionalFiles;
import software.amazon.smithy.ruby.codegen.util.RubySource;
import software.amazon.smithy.utils.SmithyBuilder;

public class RubyRuntimePlugin {
    private final RenderAdd renderAdd;
    private final WriteAdditionalFiles writeAdditionalFiles;

    public RubyRuntimePlugin(Builder builder) {
        this.renderAdd = Objects.requireNonNull(builder.renderAdd);
        this.writeAdditionalFiles = builder.writeAdditionalFiles;
    }

    public String renderAdd(GenerationContext context) {
        return this.renderAdd.renderAdd(context);
    }

    public List<String> writeAdditionalFiles(GenerationContext context) {
        return this.writeAdditionalFiles.writeAdditionalFiles(context);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements SmithyBuilder<RubyRuntimePlugin> {
        private WriteAdditionalFiles writeAdditionalFiles = context -> Collections.emptyList();
        private RenderAdd renderAdd;

        public Builder rubySource(String rubyFileName) {
            this.writeAdditionalFiles = RubySource.rubySource(rubyFileName, "plugins/");
            return this;
        }

        public Builder pluginClass(String pluginClass) {
            this.renderAdd = context -> pluginClass + ".new";
            return this;
        }

        public Builder renderAdd(RenderAdd r) {
            this.renderAdd = Objects.requireNonNull(r);
            return this;
        }

        public Builder writeAdditionalFiles(WriteAdditionalFiles w) {
            this.writeAdditionalFiles = Objects.requireNonNull(w);
            return this;
        }

        public RubyRuntimePlugin build() {
            return new RubyRuntimePlugin(this);
        }
    }

    @FunctionalInterface
    public static interface RenderAdd {
        public String renderAdd(GenerationContext var1);
    }
}

