/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.ruby.codegen.ClientFragment;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.auth.AuthScheme;
import software.amazon.smithy.ruby.codegen.auth.factories.HttpApiKeyAuthSchemeFactory;
import software.amazon.smithy.ruby.codegen.auth.factories.HttpBasicAuthSchemeFactory;
import software.amazon.smithy.ruby.codegen.auth.factories.HttpBearerAuthSchemeFactory;
import software.amazon.smithy.ruby.codegen.auth.factories.HttpDigestAuthSchemeFactory;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.factories.BuildMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.ContentLengthMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.ContentMD5MiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.ParseMiddlewareFactory;
import software.amazon.smithy.ruby.codegen.middleware.factories.RequestCompressionMiddlewareFactory;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class ApplicationTransport {
    private final String name;
    private final ClientFragment request;
    private final ClientFragment response;
    private final ClientFragment transportClient;
    private final MiddlewareList defaultMiddleware;
    private final List<AuthScheme> defaultAuthSchemes;

    public ApplicationTransport(String name, ClientFragment request, ClientFragment response, ClientFragment transportClient, MiddlewareList defaultMiddleware, List<AuthScheme> defaultAuthSchemes) {
        this.name = name;
        this.request = request;
        this.response = response;
        this.transportClient = transportClient;
        this.defaultMiddleware = defaultMiddleware;
        this.defaultAuthSchemes = defaultAuthSchemes;
    }

    public static ApplicationTransport createDefaultHttpApplicationTransport() {
        ClientFragment request = ClientFragment.builder().render((self, ctx) -> "Hearth::HTTP::Request.new(uri: URI(''))").build();
        ClientFragment response = ClientFragment.builder().render((self, ctx) -> "Hearth::HTTP::Response.new(body: response_body)").build();
        ClientConfig httpClient = ClientConfig.builder().name("http_client").documentation("The HTTP Client to use for request transport.").documentationRbsAndValidationType("Hearth::HTTP::Client").defaultDynamicValue("Hearth::HTTP::Client.new(logger: cfg[:logger])").documentationDefaultValue("Hearth::HTTP::Client.new").build();
        ClientFragment client = ClientFragment.builder().addConfig(httpClient).render((self, ctx) -> httpClient.renderGetConfigValue()).build();
        MiddlewareList defaultMiddleware = (transport, context) -> {
            ArrayList<Middleware> middleware = new ArrayList<Middleware>();
            middleware.add(BuildMiddlewareFactory.build(context));
            middleware.add(ContentLengthMiddlewareFactory.build(context));
            middleware.add(ContentMD5MiddlewareFactory.build(context));
            middleware.add(RequestCompressionMiddlewareFactory.build(context));
            middleware.add(ParseMiddlewareFactory.build(context));
            return middleware;
        };
        List<AuthScheme> defaultAuthSchemes = List.of(HttpApiKeyAuthSchemeFactory.build(), HttpBasicAuthSchemeFactory.build(), HttpBearerAuthSchemeFactory.build(), HttpDigestAuthSchemeFactory.build());
        return new ApplicationTransport("http", request, response, client, defaultMiddleware, defaultAuthSchemes);
    }

    public String getName() {
        return this.name;
    }

    public boolean isHttpTransport() {
        return this.getName().startsWith("http");
    }

    public ClientFragment getRequest() {
        return this.request;
    }

    public ClientFragment getResponse() {
        return this.response;
    }

    public ClientFragment getTransportClient() {
        return this.transportClient;
    }

    public String getErrorInspector() {
        return Hearth.HTTP_ERROR_INSPECTOR.toString();
    }

    public List<Middleware> defaultMiddleware(GenerationContext context) {
        return this.defaultMiddleware.list(this, context);
    }

    public List<AuthScheme> defaultAuthSchemes() {
        return this.defaultAuthSchemes;
    }

    public Set<ClientConfig> getClientConfig() {
        HashSet<ClientConfig> config = new HashSet<ClientConfig>();
        config.addAll(this.request.getClientConfig());
        config.addAll(this.response.getClientConfig());
        config.addAll(this.transportClient.getClientConfig());
        return config;
    }

    public String toString() {
        return "ApplicationTransport<" + this.getName() + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationTransport)) {
            return false;
        }
        ApplicationTransport that = (ApplicationTransport)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @FunctionalInterface
    public static interface MiddlewareList {
        public List<Middleware> list(ApplicationTransport var1, GenerationContext var2);
    }
}

