/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.util;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.util.NodeToHash;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public class ParamsToHash
extends ShapeVisitor.Default<String> {
    private final Node node;
    private final Model model;
    private final SymbolProvider symbolProvider;

    public ParamsToHash(Model model, Node node, SymbolProvider symbolProvider) {
        this.node = node;
        this.model = model;
        this.symbolProvider = symbolProvider;
    }

    protected String getDefault(Shape shape) {
        return "";
    }

    public String stringShape(StringShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        StringNode stringNode = this.node.expectStringNode();
        return StringUtils.escapeJavaString((Object)stringNode.getValue(), (String)"");
    }

    public String blobShape(BlobShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        StringNode stringNode = this.node.expectStringNode();
        return "'" + stringNode.getValue() + "'";
    }

    public String booleanShape(BooleanShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        BooleanNode booleanNode = this.node.expectBooleanNode();
        return booleanNode.getValue() ? "true" : "false";
    }

    public String byteShape(ByteShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        NumberNode numberNode = this.node.expectNumberNode();
        return numberNode.getValue().toString();
    }

    public String shortShape(ShortShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        NumberNode numberNode = this.node.expectNumberNode();
        return numberNode.getValue().toString();
    }

    public String integerShape(IntegerShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        NumberNode numberNode = this.node.expectNumberNode();
        return numberNode.getValue().toString();
    }

    public String longShape(LongShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        NumberNode numberNode = this.node.expectNumberNode();
        return numberNode.getValue().toString();
    }

    public String floatShape(FloatShape shape) {
        return this.rubyFloat();
    }

    public String doubleShape(DoubleShape shape) {
        return this.rubyFloat();
    }

    private String rubyFloat() {
        if (this.node.isNullNode()) {
            return "nil";
        }
        if (this.node.isStringNode()) {
            StringNode stringNode = this.node.expectStringNode();
            switch (stringNode.getValue()) {
                case "NaN": {
                    return "Float::NAN";
                }
                case "Infinity": {
                    return "Float::INFINITY";
                }
                case "-Infinity": {
                    return "-Float::INFINITY";
                }
            }
            throw new CodegenException("Unexpected string value for Float shape: " + this.node + " from: " + this.node.getSourceLocation());
        }
        NumberNode numberNode = this.node.expectNumberNode();
        return numberNode.getValue().toString();
    }

    public String bigIntegerShape(BigIntegerShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        NumberNode numberNode = this.node.expectNumberNode();
        return numberNode.getValue().toString();
    }

    public String bigDecimalShape(BigDecimalShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        NumberNode numberNode = this.node.expectNumberNode();
        return numberNode.getValue().toString();
    }

    public String timestampShape(TimestampShape shape) {
        if (this.node.isNullNode()) {
            return "";
        }
        if (this.node.isNumberNode()) {
            if (this.node.expectNumberNode().isFloatingPointNumber()) {
                Double n = this.node.expectNumberNode().getValue().doubleValue();
                long seconds = (long)Math.floor(n);
                long ms = Math.round((n - Math.floor(n)) * 1000.0);
                return "Time.at(" + seconds + ", " + ms + ", :millisecond)";
            }
            return "Time.at(" + this.node.expectNumberNode().getValue().toString() + ")";
        }
        return "Time.parse('" + this.node + "')";
    }

    public String listShape(ListShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        ArrayNode arrayNode = this.node.expectArrayNode();
        Shape target = this.model.expectShape(shape.getMember().getTarget());
        String elements = arrayNode.getElements().stream().map(element -> (String)target.accept((ShapeVisitor)new ParamsToHash(this.model, (Node)element, this.symbolProvider))).collect(Collectors.joining(",\n"));
        return "[\n" + this.indent(elements) + "\n]";
    }

    public String mapShape(MapShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        ObjectNode objectNode = this.node.expectObjectNode();
        Shape target = this.model.expectShape(shape.getValue().getTarget());
        Map members = objectNode.getMembers();
        String memberStr = members.keySet().stream().map(k -> "'" + k.toString() + "' => " + (String)target.accept((ShapeVisitor)new ParamsToHash(this.model, (Node)members.get(k), this.symbolProvider))).collect(Collectors.joining(",\n"));
        return "{\n" + this.indent(memberStr) + "\n}";
    }

    public String structureShape(StructureShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        ObjectNode objectNode = this.node.expectObjectNode();
        Map members = objectNode.getMembers();
        Map shapeMembers = shape.getAllMembers();
        String memberStr = members.keySet().stream().map(k -> {
            MemberShape member = (MemberShape)shapeMembers.get(k.toString());
            return this.symbolProvider.toMemberName(member) + ": " + (String)this.model.expectShape(member.getTarget()).accept((ShapeVisitor)new ParamsToHash(this.model, (Node)members.get(k), this.symbolProvider));
        }).collect(Collectors.joining(",\n"));
        return "{\n" + this.indent(memberStr) + "\n}";
    }

    public String unionShape(UnionShape shape) {
        if (this.node.isNullNode()) {
            return "nil";
        }
        ObjectNode objectNode = this.node.expectObjectNode();
        Map members = objectNode.getMembers();
        Map shapeMembers = shape.getAllMembers();
        String memberStr = members.keySet().stream().map(k -> {
            MemberShape member = (MemberShape)shapeMembers.get(k.toString());
            return RubyFormatter.toSnakeCase(this.symbolProvider.toMemberName(member)) + ": " + (String)this.model.expectShape(member.getTarget()).accept((ShapeVisitor)new ParamsToHash(this.model, (Node)members.get(k), this.symbolProvider));
        }).collect(Collectors.joining(", "));
        return "{\n" + this.indent(memberStr) + "\n}";
    }

    private String indent(String s) {
        return Arrays.stream(s.split("\n")).map(l -> "  " + l).collect(Collectors.joining("\n"));
    }

    public String documentShape(DocumentShape shape) {
        return (String)this.node.accept((NodeVisitor)new NodeToHash());
    }
}

