/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.GenerateUnionDirective;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.ruby.codegen.generators.docs.ShapeDocumentationGenerator;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class UnionGenerator
extends RubyGeneratorBase {
    private final UnionShape shape;

    public UnionGenerator(GenerateUnionDirective<GenerationContext, RubySettings> directive) {
        super((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.shape = (UnionShape)directive.shape();
    }

    @Override
    String getModule() {
        return "Types";
    }

    public void render() {
        this.write(writer -> {
            ((RubyCodeWriter)writer.call(() -> new ShapeDocumentationGenerator(this.model, (RubyCodeWriter)((Object)writer), this.symbolProvider, (Shape)this.shape).render())).openBlock("class $T < $T", new Object[]{this.symbolProvider.toSymbol((Shape)this.shape), Hearth.UNION});
            for (MemberShape memberShape : this.shape.members()) {
                ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.call(() -> new ShapeDocumentationGenerator(this.model, (RubyCodeWriter)((Object)writer), this.symbolProvider, (Shape)memberShape).render())).openBlock("class $L < $T", new Object[]{this.symbolProvider.toMemberName(memberShape), this.symbolProvider.toSymbol((Shape)this.shape)})).openBlock("def to_h", new Object[0])).write("{ $L: super(__getobj__) }", new Object[]{RubyFormatter.toSnakeCase(this.symbolProvider.toMemberName(memberShape))})).closeBlock("end", new Object[0])).call(() -> this.renderUnionToSMethod((RubyCodeWriter)((Object)writer), memberShape))).closeBlock("end\n", new Object[0]);
            }
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class Unknown < $T", new Object[]{this.symbolProvider.toSymbol((Shape)this.shape)})).openBlock("def to_h", new Object[0])).write("{ unknown: super(__getobj__) }", new Object[0])).closeBlock("end\n", new Object[0])).openBlock("def to_s", new Object[0])).write("\"#<$L::Types::Unknown #{__getobj__ || 'nil'}>\"", new Object[]{this.settings.getModule()})).closeBlock("end", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end\n", new Object[0]);
        });
        this.writeRbs(writer -> {
            Symbol symbol = this.symbolProvider.toSymbol((Shape)this.shape);
            writer.openBlock("class $T < $T", new Object[]{symbol, Hearth.UNION});
            for (MemberShape memberShape : this.shape.members()) {
                String memberName = this.symbolProvider.toMemberName(memberShape);
                Shape target = this.model.expectShape(memberShape.getTarget());
                ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class $L < $T", new Object[]{memberName, symbol})).write("def to_h: () -> { $L: $L }", new Object[]{RubyFormatter.toSnakeCase(memberName), target.accept((ShapeVisitor)new UnionToHValueRbsVisitor())})).write("def to_s: () -> String", new Object[0])).closeBlock("end\n", new Object[0]);
            }
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class Unknown < $T", new Object[]{symbol})).write("def to_h: () -> { unknown: { name: String, value: untyped } }", new Object[0])).write("def to_s: () -> String", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end\n", new Object[0]);
        });
    }

    private void renderUnionToSMethod(RubyCodeWriter writer, MemberShape memberShape) {
        String fullQualifiedShapeName = this.settings.getModule() + "::Types::" + this.symbolProvider.toMemberName(memberShape);
        ((RubyCodeWriter)writer.write("", new Object[0])).openBlock("def to_s", new Object[0]);
        if (memberShape.getMemberTrait(this.model, SensitiveTrait.class).isPresent()) {
            writer.write("\"#<$L [SENSITIVE]>\"", new Object[]{fullQualifiedShapeName});
        } else {
            writer.write("\"#<$L #{__getobj__ || 'nil'}>\"", new Object[]{fullQualifiedShapeName});
        }
        writer.closeBlock("end", new Object[0]);
    }

    private class UnionToHValueRbsVisitor
    extends ShapeVisitor.Default<String> {
        private UnionToHValueRbsVisitor() {
        }

        protected String getDefault(Shape shape) {
            Symbol symbol = UnionGenerator.this.symbolProvider.toSymbol(shape);
            return symbol.getProperty("rbsType").orElse("untyped").toString();
        }

        public String listShape(ListShape shape) {
            Shape target = UnionGenerator.this.model.expectShape(shape.getMember().getTarget());
            return "::Array[" + (String)target.accept((ShapeVisitor)this) + "]";
        }

        public String mapShape(MapShape shape) {
            Shape target = UnionGenerator.this.model.expectShape(shape.getValue().getTarget());
            return "::Hash[::Symbol, " + (String)target.accept((ShapeVisitor)this) + "]";
        }

        public String structureShape(StructureShape shape) {
            return "::Hash[::Symbol, untyped]";
        }

        public String unionShape(UnionShape shape) {
            return "::Hash[::Symbol, untyped]";
        }
    }
}

