/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.GenerateIntEnumDirective;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class IntEnumGenerator
extends RubyGeneratorBase {
    private final IntEnumShape shape;

    public IntEnumGenerator(GenerateIntEnumDirective<GenerationContext, RubySettings> directive) {
        super((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.shape = (IntEnumShape)directive.shape();
    }

    @Override
    String getModule() {
        return "Types";
    }

    public void render() {
        this.write(writer -> {
            if (this.shape.getEnumValues().size() > 0) {
                String shapeName = this.symbolProvider.toSymbol((Shape)this.shape).getName();
                writer.writeDocstring("Includes enum constants for " + shapeName).addModule(shapeName);
                this.shape.getEnumValues().forEach((enumName, enumValue) -> writer.write("$L = $L\n", new Object[]{enumName, enumValue}));
                ((RubyCodeWriter)writer.unwrite("\n", new Object[0])).closeModule();
            }
        });
    }
}

