/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.RetryableTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public abstract class ErrorsGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(ErrorsGeneratorBase.class.getName());
    protected final GenerationContext context;
    protected final RubySettings settings;
    protected final Model model;
    protected final RubyCodeWriter writer;
    protected final RubyCodeWriter rbsWriter;
    protected final SymbolProvider symbolProvider;
    protected final List<Shape> errorShapes;

    public ErrorsGeneratorBase(GenerationContext context) {
        this.context = context;
        this.settings = context.settings();
        this.model = context.model();
        this.writer = new RubyCodeWriter(context.settings().getModule() + "::Errors");
        this.rbsWriter = new RubyCodeWriter(context.settings().getModule() + "::Errors");
        this.symbolProvider = context.symbolProvider();
        this.errorShapes = this.getErrorShapes();
    }

    protected List<Shape> getErrorShapes() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        return topDownIndex.getContainedOperations((ToShapeId)this.context.service()).stream().map(OperationShape::getErrors).flatMap(Collection::stream).collect(Collectors.toSet()).stream().sorted(Comparator.comparing(o -> o.getName())).map(arg_0 -> ((Model)this.model).expectShape(arg_0)).collect(Collectors.toCollection(ArrayList::new));
    }

    public void render(FileManifest fileManifest) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.preamble().includeRequires().openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("module Errors", new Object[0])).openBlock("def self.error_code(resp)", new Object[0])).call(() -> this.renderErrorCodeBody())).closeBlock("end", new Object[0])).call(() -> this.renderBaseErrors())).call(() -> this.renderServiceModelErrors((ShapeVisitor<Void>)new ErrorsVisitor()))).write("", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/errors.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.info("Wrote errors to " + fileName);
    }

    public void renderRbs(FileManifest fileManifest) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.rbsWriter.preamble().openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("module Errors", new Object[0])).write("", new Object[0])).call(() -> this.renderRbsErrorCode())).call(() -> this.renderRbsBaseErrors())).call(() -> this.renderServiceModelErrors((ShapeVisitor<Void>)new ErrorsRbsVisitor()))).write("", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/sig/" + this.settings.getGemName() + "/errors.rbs";
        fileManifest.writeFile(fileName, this.rbsWriter.toString());
        LOGGER.info("Wrote errors rbs to " + fileName);
    }

    private void renderBaseErrors() {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("\n# Base class for all errors returned by this service", new Object[0])).write("class ApiError < $T; end", new Object[]{Hearth.HTTP_API_ERROR})).write("\n# Base class for all errors returned where the client is at fault.", new Object[0])).write("# These are generally errors with 4XX HTTP status codes.", new Object[0])).write("class ApiClientError < ApiError; end", new Object[0])).write("\n# Base class for all errors returned where the server is at fault.", new Object[0])).write("# These are generally errors with 5XX HTTP status codes.", new Object[0])).write("class ApiServerError < ApiError; end", new Object[0])).write("\n# Base class for all errors returned where the service returned", new Object[0])).write("# a 3XX redirection.", new Object[0])).openBlock("class ApiRedirectError < ApiError", new Object[0])).openBlock("def initialize(location:, **kwargs)", new Object[0])).write("@location = location", new Object[0])).write("super(**kwargs)", new Object[0])).closeBlock("end", new Object[0])).write("", new Object[0])).write("# @return [String] location", new Object[0])).write("attr_reader :location", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderRbsBaseErrors() {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.rbsWriter.write("\nclass ApiError < $T", new Object[]{Hearth.HTTP_API_ERROR})).write("end", new Object[0])).write("\nclass ApiClientError < ApiError", new Object[0])).write("end", new Object[0])).write("\nclass ApiServerError < ApiError", new Object[0])).write("end", new Object[0])).openBlock("\nclass ApiRedirectError < ApiError", new Object[0])).write("def initialize: (location: String, **untyped kwargs) -> void\n", new Object[0])).write("attr_reader location: String", new Object[0])).closeBlock("end", new Object[0]);
    }

    public abstract void renderErrorCodeBody();

    public void renderRbsErrorCode() {
        this.rbsWriter.write("def self.error_code: (Hearth::HTTP::Response) -> String", new Object[0]);
    }

    private void renderServiceModelErrors(ShapeVisitor<Void> visitor) {
        this.errorShapes.forEach(error -> error.accept(visitor));
    }

    private String getApiErrorType(ErrorTrait errorTrait) {
        String apiErrorType = errorTrait.isClientError() ? "ApiClientError" : (errorTrait.isServerError() ? "ApiServerError" : "Hearth::HTTP::ApiError");
        return apiErrorType;
    }

    private class ErrorsRbsVisitor
    extends ShapeVisitor.Default<Void> {
        private ErrorsRbsVisitor() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            String apiErrorType = ErrorsGeneratorBase.this.getApiErrorType((ErrorTrait)shape.expectTrait(ErrorTrait.class));
            String shapeName = ErrorsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            boolean retryable = shape.hasTrait(RetryableTrait.class);
            boolean throttling = retryable && ((RetryableTrait)shape.expectTrait(RetryableTrait.class)).getThrottling();
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)ErrorsGeneratorBase.this.rbsWriter.write("", new Object[0])).openBlock("class $L < $L", new Object[]{shapeName, apiErrorType})).write("def initialize: (http_resp: Hearth::HTTP::Response, **untyped kwargs) -> void\n", new Object[0])).write("attr_reader data: Types::$L", new Object[]{shapeName})).call(() -> {
                if (retryable) {
                    ErrorsGeneratorBase.this.rbsWriter.write("def retryable?: () -> true", new Object[0]);
                }
            })).call(() -> {
                if (throttling) {
                    ErrorsGeneratorBase.this.rbsWriter.write("def throttling?: () -> true", new Object[0]);
                }
            })).closeBlock("end", new Object[0]);
            return null;
        }
    }

    private class ErrorsVisitor
    extends ShapeVisitor.Default<Void> {
        private ErrorsVisitor() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            String errorName = ErrorsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            String apiErrorType = ErrorsGeneratorBase.this.getApiErrorType((ErrorTrait)shape.expectTrait(ErrorTrait.class));
            boolean retryable = shape.hasTrait(RetryableTrait.class);
            boolean throttling = retryable && ((RetryableTrait)shape.expectTrait(RetryableTrait.class)).getThrottling();
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)ErrorsGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L < $L", new Object[]{ErrorsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName(), apiErrorType})).openBlock("def initialize(http_resp:, **kwargs)", new Object[0])).write("@data = Parsers::$L.parse(http_resp)", new Object[]{ErrorsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName()})).write("kwargs[:message] = @data.message if @data.respond_to?(:message)\n", new Object[0])).write("super(http_resp: http_resp, **kwargs)", new Object[0])).closeBlock("end", new Object[0])).write("", new Object[0])).writeYardReturn("Types::" + errorName, "").write("attr_reader :data", new Object[0])).call(() -> {
                if (retryable) {
                    ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)ErrorsGeneratorBase.this.writer.write("", new Object[0])).openBlock("def retryable?", new Object[0])).write("true", new Object[0])).closeBlock("end", new Object[0]);
                }
            })).call(() -> {
                if (throttling) {
                    ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)ErrorsGeneratorBase.this.writer.write("", new Object[0])).openBlock("def throttling?", new Object[0])).write("true", new Object[0])).closeBlock("end", new Object[0]);
                }
            })).closeBlock("end", new Object[0]);
            return null;
        }
    }
}

