/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.auth.factories;

import software.amazon.smithy.model.traits.HttpDigestAuthTrait;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.auth.AuthScheme;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;

public final class HttpDigestAuthSchemeFactory {
    private HttpDigestAuthSchemeFactory() {
    }

    public static AuthScheme build() {
        String identityResolverDocumentation = "A %s that returns a %s for operations modeled with the %s auth scheme.\n";
        String defaultIdentity = Hearth.IDENTITIES + "::HTTPLogin.new(username: 'stubbed username', password: 'stubbed password')";
        String defaultConfigValue = "cfg[:stub_responses] ? %s.new(proc { %s }) : nil".formatted(Hearth.IDENTITY_RESOLVER, defaultIdentity);
        String identityType = Hearth.IDENTITIES + "::HTTPLogin";
        ClientConfig identityResolverConfig = ClientConfig.builder().name("http_login_identity_resolver").type(Hearth.IDENTITY_RESOLVER.toString()).documentation(identityResolverDocumentation.formatted(Hearth.IDENTITY_RESOLVER, identityType, HttpDigestAuthTrait.ID)).defaultDynamicValue(defaultConfigValue).build();
        return AuthScheme.builder().shapeId(HttpDigestAuthTrait.ID).rubyAuthScheme(Hearth.AUTH_SCHEMES + "::HTTPDigest.new").rubyIdentityType(identityType).identityResolverConfig(identityResolverConfig).build();
    }
}

