/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.waiters.Acceptor;
import software.amazon.smithy.waiters.AcceptorState;
import software.amazon.smithy.waiters.Matcher;
import software.amazon.smithy.waiters.WaitableTrait;
import software.amazon.smithy.waiters.Waiter;

@SmithyInternalApi
public class WaitersGenerator {
    private static final Logger LOGGER = Logger.getLogger(WaitersGenerator.class.getName());
    private final GenerationContext context;
    private final RubySettings settings;
    private final Model model;
    private final RubyCodeWriter writer;
    private final RubyCodeWriter rbsWriter;
    private final RubySymbolProvider symbolProvider;

    public WaitersGenerator(GenerationContext context) {
        this.context = context;
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.writer = new RubyCodeWriter();
        this.rbsWriter = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(context.getModel(), this.settings, "Waiters", false);
    }

    public void render() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.writer.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Waiters", new Object[0]).call(() -> this.renderWaiters(false)).write((Object)"", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/waiters.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote waiters to " + fileName);
    }

    public void renderRbs() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.rbsWriter.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Waiters", new Object[0]).call(() -> this.renderWaiters(true)).write((Object)"", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String typesFile = this.settings.getGemName() + "/sig/" + this.settings.getGemName() + "/waiters.rbs";
        fileManifest.writeFile(typesFile, this.rbsWriter.toString());
        LOGGER.fine("Wrote waiters rbs to " + typesFile);
    }

    private void renderWaiters(Boolean rbs) {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        topDownIndex.getContainedOperations((ToShapeId)this.context.getService()).stream().forEach(operation -> {
            if (operation.hasTrait(WaitableTrait.class)) {
                Map waiters = ((WaitableTrait)operation.getTrait(WaitableTrait.class).get()).getWaiters();
                Iterator iterator = waiters.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String waiterName = (String)entry.getKey();
                    Waiter waiter = (Waiter)entry.getValue();
                    if (rbs.booleanValue()) {
                        this.renderRbsWaiter(waiterName);
                    } else {
                        this.renderWaiter(waiterName, waiter, (OperationShape)operation);
                    }
                    if (!iterator.hasNext()) continue;
                    this.writer.write("", new Object[0]);
                }
            }
        });
    }

    private void renderWaiter(String waiterName, Waiter waiter, OperationShape operation) {
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        this.writer.write("", new Object[0]).call(() -> this.renderWaiterDocumentation(waiter)).openBlock("class $L", new Object[]{waiterName}).call(() -> this.renderWaiterInitializeDocumentation(waiter)).openBlock("def initialize(client, options = {})", new Object[0]).write((Object)"@client = client", new Object[0]).openBlock("@waiter = Seahorse::Waiters::Waiter.new({", new Object[0]).write((Object)"max_wait_time: options[:max_wait_time],", new Object[0]).write((Object)"min_delay: $L || options[:min_delay],", new Object[]{waiter.getMinDelay()}).write((Object)"max_delay: $L || options[:max_delay],", new Object[]{waiter.getMaxDelay()}).openBlock("poller: Seahorse::Waiters::Poller.new(", new Object[0]).write((Object)"operation_name: :$L,", new Object[]{operationName}).call(() -> this.renderAcceptors(waiter)).closeBlock(")", new Object[0]).closeBlock("}.merge(options))", new Object[0]).call(() -> this.renderWaiterTags(waiter)).closeBlock("end", new Object[0]).write((Object)"", new Object[0]).write((Object)"attr_reader :tags", new Object[0]).write((Object)"", new Object[0]).call(() -> this.renderWaiterWaitDocumentation(operation, operationName)).openBlock("def wait(params = {}, options = {})", new Object[0]).write((Object)"@waiter.wait(@client, params, options)", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated waiter " + waiterName + " for operation: " + operationName);
    }

    private void renderRbsWaiter(String waiterName) {
        this.rbsWriter.write("", new Object[0]).openBlock("class $L", new Object[]{waiterName}).write((Object)"def initialize: (untyped client, ?::Hash[untyped, untyped] options) -> void\n", new Object[0]).write((Object)"attr_reader tags: untyped\n", new Object[0]).write((Object)"def wait: (?::Hash[untyped, untyped] params, ?::Hash[untyped, untyped] options) -> untyped", new Object[0]).closeBlock("end", new Object[0]);
    }

    private void renderWaiterDocumentation(Waiter waiter) {
        if (waiter.getDocumentation().isPresent()) {
            this.writer.writeDocstring((String)waiter.getDocumentation().get());
        }
        if (waiter.isDeprecated()) {
            this.writer.writeYardDeprecated("This waiter is deprecated.", "");
        }
    }

    private void renderWaiterTags(Waiter waiter) {
        String tags = waiter.getTags().stream().map(tag -> "\"" + tag + "\"").collect(Collectors.joining(", "));
        this.writer.write("@tags = [$L]", new Object[]{tags});
    }

    private void renderAcceptors(Waiter waiter) {
        List acceptorsList = waiter.getAcceptors();
        if (acceptorsList.isEmpty()) {
            this.writer.write("acceptors: []", new Object[0]);
        } else {
            this.writer.openBlock("acceptors: [", new Object[0]);
            Iterator iterator = acceptorsList.iterator();
            while (iterator.hasNext()) {
                Acceptor acceptor = (Acceptor)iterator.next();
                Matcher matcher = acceptor.getMatcher();
                AcceptorState state = acceptor.getState();
                this.writer.openBlock("{", new Object[0]).write((Object)"state: '$L',", new Object[]{state}).openBlock("matcher: {", new Object[0]).call(() -> matcher.accept((Matcher.Visitor)new AcceptorVisitor())).closeBlock("}", new Object[0]);
                if (iterator.hasNext()) {
                    this.writer.closeBlock("},", new Object[0]);
                    continue;
                }
                this.writer.closeBlock("}", new Object[0]);
            }
            this.writer.closeBlock("]", new Object[0]);
        }
    }

    private String translatePath(String path) {
        return Arrays.stream(path.split("[.]")).map(m -> RubyFormatter.toSnakeCase(m)).collect(Collectors.joining("."));
    }

    private void renderWaiterWaitDocumentation(OperationShape operation, String operationName) {
        String operationReturnType = "Types::" + this.symbolProvider.toSymbol((Shape)operation).getName();
        String operationReference = "(see Client#" + operationName + ")";
        this.writer.writeYardParam("Hash", "params", operationReference).writeYardParam("Hash", "options", operationReference).writeYardReturn(operationReturnType, operationReference);
    }

    private void renderWaiterInitializeDocumentation(Waiter waiter) {
        this.writer.writeYardParam("Client", "client", "").writeYardParam("Hash", "options", "").writeYardOption("options", "required, Integer", ":max_wait_time", "", "The maximum time in seconds to wait before the waiter gives up.").writeYardOption("options", "Integer", ":min_delay", "" + waiter.getMinDelay(), "The minimum time in seconds to delay polling attempts.").writeYardOption("options", "Integer", ":max_delay", "" + waiter.getMaxDelay(), "The maximum time in seconds to delay polling attempts.");
    }

    private class AcceptorVisitor
    implements Matcher.Visitor<Void> {
        private AcceptorVisitor() {
        }

        private void renderPathMatcher(String memberName, String path, String comparator, String expected) {
            WaitersGenerator.this.writer.openBlock("$L: {", new Object[]{memberName}).write((Object)"path: \"$L\",", new Object[]{WaitersGenerator.this.translatePath(path)}).write((Object)"comparator: \"$L\",", new Object[]{comparator}).write((Object)"expected: '$L'", new Object[]{expected}).closeBlock("}", new Object[0]);
        }

        public Void visitOutput(Matcher.OutputMember outputPath) {
            this.renderPathMatcher(outputPath.getMemberName(), outputPath.getValue().getPath(), outputPath.getValue().getComparator().toString(), outputPath.getValue().getExpected());
            return null;
        }

        public Void visitInputOutput(Matcher.InputOutputMember inputOutputPath) {
            this.renderPathMatcher(inputOutputPath.getMemberName(), inputOutputPath.getValue().getPath(), inputOutputPath.getValue().getComparator().toString(), inputOutputPath.getValue().getExpected());
            return null;
        }

        public Void visitSuccess(Matcher.SuccessMember success) {
            WaitersGenerator.this.writer.write("$L: $L", new Object[]{success.getMemberName(), success.getValue() != false ? "true" : "false"});
            return null;
        }

        public Void visitErrorType(Matcher.ErrorTypeMember errorType) {
            WaitersGenerator.this.writer.write("$L: '$L'", new Object[]{errorType.getMemberName(), errorType.getValue()});
            return null;
        }

        public Void visitUnknown(Matcher.UnknownMember unknown) {
            return null;
        }
    }
}

