/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.generators.docs.ShapeDocumentationGenerator;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class TypesGenerator {
    private static final Logger LOGGER = Logger.getLogger(TypesGenerator.class.getName());
    private final GenerationContext context;
    private final RubySettings settings;
    private final Model model;
    private final RubyCodeWriter writer;
    private final RubyCodeWriter rbsWriter;
    private final SymbolProvider symbolProvider;

    public TypesGenerator(GenerationContext context) {
        this.context = context;
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.writer = new RubyCodeWriter();
        this.rbsWriter = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(this.model, this.settings, "Types", false);
    }

    public void render() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.writer.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Types", new Object[0]).write((Object)"", new Object[0]).call(() -> this.renderTypes((ShapeVisitor<Void>)new TypesVisitor())).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/types.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote types to " + fileName);
    }

    public void renderRbs() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.rbsWriter.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Types", new Object[0]).write((Object)"", new Object[0]).call(() -> this.renderTypes((ShapeVisitor<Void>)new TypesRbsVisitor())).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String typesFile = this.settings.getGemName() + "/sig/" + this.settings.getGemName() + "/types.rbs";
        fileManifest.writeFile(typesFile, this.rbsWriter.toString());
        LOGGER.fine("Wrote types rbs to " + typesFile);
    }

    private void renderTypes(ShapeVisitor<Void> visitor) {
        Model modelWithoutTraitShapes = ModelTransformer.create().getModelWithoutTraitShapes(this.model);
        new Walker(modelWithoutTraitShapes).walkShapes((Shape)this.context.getService()).stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(shape -> {
            Void cfr_ignored_0 = (Void)shape.accept(visitor);
        });
    }

    private class TypesRbsVisitor
    extends ShapeVisitor.Default<Void> {
        private TypesRbsVisitor() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            Symbol symbol = TypesGenerator.this.symbolProvider.toSymbol((Shape)shape);
            String shapeName = symbol.getName();
            TypesGenerator.this.rbsWriter.write(shapeName + ": untyped\n", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            Symbol symbol = TypesGenerator.this.symbolProvider.toSymbol((Shape)shape);
            String shapeName = symbol.getName();
            TypesGenerator.this.rbsWriter.openBlock("class $L < Seahorse::Union", new Object[]{shapeName});
            for (MemberShape memberShape : shape.members()) {
                TypesGenerator.this.rbsWriter.openBlock("class $L < $L", new Object[]{TypesGenerator.this.symbolProvider.toMemberName(memberShape), shapeName}).write((Object)"def to_h: () -> { $L: Hash[Symbol,$L] }", new Object[]{RubyFormatter.toSnakeCase(TypesGenerator.this.symbolProvider.toMemberName(memberShape)), shapeName}).closeBlock("end\n", new Object[0]);
            }
            TypesGenerator.this.rbsWriter.openBlock("class Unknown < $L", new Object[]{shapeName}).write((Object)"def to_h: () -> { unknown: Hash[Symbol,$L] }", new Object[]{shapeName}).closeBlock("end", new Object[0]).closeBlock("end\n", new Object[0]);
            return null;
        }
    }

    private class TypesVisitor
    extends ShapeVisitor.Default<Void> {
        private TypesVisitor() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            String shapeName = TypesGenerator.this.symbolProvider.toSymbol((Shape)shape).getName();
            String membersBlock = "nil";
            if (!shape.members().isEmpty()) {
                membersBlock = shape.members().stream().map(memberShape -> RubyFormatter.asSymbol(TypesGenerator.this.symbolProvider.toMemberName(memberShape))).collect(Collectors.joining(",\n"));
            }
            membersBlock = membersBlock + ",";
            String documentation = new ShapeDocumentationGenerator(TypesGenerator.this.model, TypesGenerator.this.symbolProvider, (Shape)shape).render();
            TypesGenerator.this.writer.writeInline(documentation, new Object[0]);
            shape.members().forEach(memberShape -> {
                String attribute = TypesGenerator.this.symbolProvider.toMemberName(memberShape);
                Shape target = TypesGenerator.this.model.expectShape(memberShape.getTarget());
                String returnType = (String)TypesGenerator.this.symbolProvider.toSymbol(target).getProperty("yardType").orElseThrow(IllegalArgumentException::new);
                String memberDocumentation = new ShapeDocumentationGenerator(TypesGenerator.this.model, TypesGenerator.this.symbolProvider, (Shape)memberShape).render();
                TypesGenerator.this.writer.writeYardAttribute(attribute, () -> {
                    TypesGenerator.this.writer.writeInline(memberDocumentation, new Object[0]);
                    TypesGenerator.this.writer.writeYardReturn(returnType, "");
                });
            });
            TypesGenerator.this.writer.openBlock(shapeName + " = ::Struct.new(", new Object[0]).write((Object)membersBlock, new Object[0]).write((Object)"keyword_init: true", new Object[0]).closeBlock(") do", new Object[0]).indent().write((Object)"include Seahorse::Structure", new Object[0]).call(() -> this.renderStructureToSMethod(shape)).closeBlock("end\n", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            String documentation = new ShapeDocumentationGenerator(TypesGenerator.this.model, TypesGenerator.this.symbolProvider, (Shape)shape).render();
            String shapeName = TypesGenerator.this.symbolProvider.toSymbol((Shape)shape).getName();
            TypesGenerator.this.writer.writeInline(documentation, new Object[0]);
            TypesGenerator.this.writer.openBlock("class $L < Seahorse::Union", new Object[]{shapeName});
            for (MemberShape memberShape : shape.members()) {
                String memberDocumentation = new ShapeDocumentationGenerator(TypesGenerator.this.model, TypesGenerator.this.symbolProvider, (Shape)memberShape).render();
                TypesGenerator.this.writer.writeInline(memberDocumentation, new Object[0]).openBlock("class $L < $L", new Object[]{TypesGenerator.this.symbolProvider.toMemberName(memberShape), shapeName}).openBlock("def to_h", new Object[0]).write((Object)"{ $L: super(__getobj__) }", new Object[]{RubyFormatter.toSnakeCase(TypesGenerator.this.symbolProvider.toMemberName(memberShape))}).closeBlock("end", new Object[0]).call(() -> this.renderUnionToSMethod(memberShape)).closeBlock("end\n", new Object[0]);
            }
            TypesGenerator.this.writer.writeDocstring("Handles unknown future members").openBlock("class Unknown < $L", new Object[]{shapeName}).openBlock("def to_h", new Object[0]).write((Object)"{ unknown: super(__getobj__) }", new Object[0]).closeBlock("end\n", new Object[0]).openBlock("def to_s", new Object[0]).write((Object)"\"#<$L::Types::Unknown #{__getobj__ || 'nil'}>\"", new Object[]{TypesGenerator.this.settings.getModule()}).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            TypesGenerator.this.writer.closeBlock("end\n", new Object[0]);
            return null;
        }

        private void renderStructureToSMethod(StructureShape structureShape) {
            String fullQualifiedShapeName = TypesGenerator.this.settings.getModule() + "::Types::" + TypesGenerator.this.symbolProvider.toSymbol((Shape)structureShape).getName();
            Boolean hasSensitiveMember = structureShape.members().stream().anyMatch(memberShape -> memberShape.getMemberTrait(TypesGenerator.this.model, SensitiveTrait.class).isPresent());
            if (structureShape.hasTrait(SensitiveTrait.class)) {
                TypesGenerator.this.writer.write("", new Object[0]).openBlock("def to_s", new Object[0]).write((Object)"\"#<struct $L [SENSITIVE]>\"", new Object[]{fullQualifiedShapeName}).closeBlock("end", new Object[0]);
            } else if (hasSensitiveMember.booleanValue()) {
                Iterator iterator = structureShape.members().iterator();
                TypesGenerator.this.writer.write("", new Object[0]).openBlock("def to_s", new Object[0]).write((Object)"\"#<struct $L \"\\", new Object[]{fullQualifiedShapeName}).indent();
                while (iterator.hasNext()) {
                    MemberShape memberShape2 = (MemberShape)iterator.next();
                    String key = TypesGenerator.this.symbolProvider.toMemberName(memberShape2);
                    String value = "#{" + key + " || 'nil'}";
                    if (memberShape2.isBlobShape() || memberShape2.isStringShape()) {
                        value = "\"" + value + "\"";
                    } else if (memberShape2.getMemberTrait(TypesGenerator.this.model, SensitiveTrait.class).isPresent()) {
                        value = "\\\"[SENSITIVE]\\\"";
                    }
                    if (iterator.hasNext()) {
                        TypesGenerator.this.writer.write("\"$L=$L, \"\\", new Object[]{key, value});
                        continue;
                    }
                    TypesGenerator.this.writer.write("\"$L=$L>\"", new Object[]{key, value});
                }
                TypesGenerator.this.writer.dedent().closeBlock("end", new Object[0]);
            }
        }

        private void renderUnionToSMethod(MemberShape memberShape) {
            String fullQualifiedShapeName = TypesGenerator.this.settings.getModule() + "::Types::" + TypesGenerator.this.symbolProvider.toMemberName(memberShape);
            TypesGenerator.this.writer.write("", new Object[0]).openBlock("def to_s", new Object[0]);
            if (memberShape.getMemberTrait(TypesGenerator.this.model, SensitiveTrait.class).isPresent()) {
                TypesGenerator.this.writer.write("\"#<$L [SENSITIVE]>\"", new Object[]{fullQualifiedShapeName});
            } else {
                TypesGenerator.this.writer.write("\"#<$L #{__getobj__ || 'nil'}>\"", new Object[]{fullQualifiedShapeName});
            }
            TypesGenerator.this.writer.closeBlock("end", new Object[0]);
        }
    }
}

