/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ParamsGenerator
extends ShapeVisitor.Default<Void> {
    private static final Logger LOGGER = Logger.getLogger(ParamsGenerator.class.getName());
    private final GenerationContext context;
    private final RubySettings settings;
    private final Model model;
    private final RubyCodeWriter writer;
    private final SymbolProvider symbolProvider;

    public ParamsGenerator(GenerationContext context) {
        this.context = context;
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.writer = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(this.model, this.settings, "Params", true);
    }

    public void render() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.writer.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Params", new Object[0]).call(() -> this.renderParams()).write((Object)"", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/params.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote params to " + fileName);
    }

    private void renderParams() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        OperationIndex operationIndex = OperationIndex.of((Model)this.model);
        Walker walker = new Walker(this.model);
        Set inputShapes = topDownIndex.getContainedOperations((ToShapeId)this.context.getService()).stream().flatMap(operation -> OptionalUtils.stream((Optional)operationIndex.getInputShape((ToShapeId)operation))).flatMap(input -> walker.walkShapes((Shape)input).stream()).collect(Collectors.toSet());
        inputShapes.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(inputShape -> {
            Void cfr_ignored_0 = (Void)inputShape.accept((ShapeVisitor)this);
        });
    }

    protected Void getDefault(Shape shape) {
        return null;
    }

    public Void structureShape(StructureShape structureShape) {
        Symbol symbol = this.symbolProvider.toSymbol((Shape)structureShape);
        String shapeName = symbol.getName();
        this.writer.write("", new Object[0]).openBlock("module $L", new Object[]{shapeName}).openBlock("def self.build(params, context: '')", new Object[0]).call(() -> this.renderBuilderForStructureMembers(shapeName, structureShape.members())).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    private void renderBuilderForStructureMembers(String shapeName, Collection<MemberShape> members) {
        this.writer.write("Seahorse::Validator.validate!(params, ::Hash, Types::$L, context: context)", new Object[]{shapeName}).write((Object)"type = Types::$L.new", new Object[]{shapeName});
        members.forEach(member -> {
            Shape target = this.model.expectShape(member.getTarget());
            String memberName = this.symbolProvider.toMemberName(member);
            String memberSetter = "type." + memberName + " = ";
            String symbolName = RubyFormatter.asSymbol(memberName);
            String input = "params[" + symbolName + "]";
            String context = "\"#{context}[" + symbolName + "]\"";
            target.accept((ShapeVisitor)new MemberBuilder(this.writer, this.symbolProvider, memberSetter, input, context, true));
        });
        this.writer.write("type", new Object[0]);
    }

    public Void listShape(ListShape listShape) {
        String shapeName = listShape.getId().getName();
        Shape memberTarget = this.model.expectShape(listShape.getMember().getTarget());
        this.writer.write("", new Object[0]).openBlock("module $L", new Object[]{shapeName}).openBlock("def self.build(params, context: '')", new Object[0]).write((Object)"Seahorse::Validator.validate!(params, ::Array, context: context)", new Object[0]).write((Object)"data = []", new Object[0]).openBlock("params.each_with_index do |element, index|", new Object[0]).call(() -> {
            Void cfr_ignored_0 = (Void)memberTarget.accept((ShapeVisitor)new MemberBuilder(this.writer, this.symbolProvider, "data << ", "element", "\"#{context}[#{index}]\"", true));
        }).closeBlock("end", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    public Void setShape(SetShape setShape) {
        String shapeName = this.symbolProvider.toSymbol((Shape)setShape).getName();
        Shape memberTarget = this.model.expectShape(setShape.getMember().getTarget());
        this.writer.write("", new Object[0]).openBlock("module $L", new Object[]{shapeName}).openBlock("def self.build(params, context: '')", new Object[0]).write((Object)"Seahorse::Validator.validate!(params, ::Set, ::Array, context: context)", new Object[0]).write((Object)"data = Set.new", new Object[0]).openBlock("params.each_with_index do |element, index|", new Object[0]).call(() -> {
            Void cfr_ignored_0 = (Void)memberTarget.accept((ShapeVisitor)new MemberBuilder(this.writer, this.symbolProvider, "data << ", "element", "\"#{context}[#{index}]\"", true));
        }).closeBlock("end", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    public Void mapShape(MapShape mapShape) {
        String shapeName = this.symbolProvider.toSymbol((Shape)mapShape).getName();
        Shape valueTarget = this.model.expectShape(mapShape.getValue().getTarget());
        this.writer.write("", new Object[0]).openBlock("module $L", new Object[]{shapeName}).openBlock("def self.build(params, context: '')", new Object[0]).write((Object)"Seahorse::Validator.validate!(params, ::Hash, context: context)", new Object[0]).write((Object)"data = {}", new Object[0]).openBlock("params.each do |key, value|", new Object[0]).call(() -> {
            Void cfr_ignored_0 = (Void)valueTarget.accept((ShapeVisitor)new MemberBuilder(this.writer, this.symbolProvider, "data[key] = ", "value", "\"#{context}[:#{key}]\"", true));
        }).closeBlock("end", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    public Void unionShape(UnionShape shape) {
        Symbol symbol = this.symbolProvider.toSymbol((Shape)shape);
        String shapeName = symbol.getName();
        this.writer.write("", new Object[0]).openBlock("module $L", new Object[]{shapeName}).openBlock("def self.build(params, context: '')", new Object[0]).write((Object)"return params if params.is_a?(Types::$L)", new Object[]{shapeName}).write((Object)"Seahorse::Validator.validate!(params, ::Hash, Types::$L, context: context)", new Object[]{shapeName}).openBlock("unless params.size == 1", new Object[0]).write((Object)"raise ArgumentError,", new Object[0]).indent(3).write((Object)"\"Expected #{context} to have exactly one member, got: #{params}\"", new Object[0]).dedent(3).closeBlock("end", new Object[0]).write((Object)"key, value = params.flatten", new Object[0]).write((Object)"case key", new Object[0]);
        for (MemberShape member2 : shape.members()) {
            Shape target = this.model.expectShape(member2.getTarget());
            String memberClassName = this.symbolProvider.toMemberName(member2);
            String memberName = RubyFormatter.asSymbol(memberClassName);
            this.writer.write("when $L", new Object[]{memberName}).indent().openBlock("Types::$L::$L.new(", new Object[]{shapeName, memberClassName});
            String input = "params[" + memberName + "]";
            String context = "\"#{context}[" + memberName + "]\"";
            target.accept((ShapeVisitor)new MemberBuilder(this.writer, this.symbolProvider, "", input, context, false));
            this.writer.closeBlock(")", new Object[0]).dedent();
        }
        String expectedMembers = shape.members().stream().map(member -> RubyFormatter.asSymbol(member.getMemberName())).collect(Collectors.joining(", "));
        this.writer.write("else", new Object[0]).indent().write((Object)"raise ArgumentError,", new Object[0]).indent(3).write((Object)"\"Expected #{context} to have one of $L set\"", new Object[]{expectedMembers}).dedent(4);
        this.writer.write("end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    private static class MemberBuilder
    extends ShapeVisitor.Default<Void> {
        private final RubyCodeWriter writer;
        private final SymbolProvider symbolProvider;
        private final String memberSetter;
        private final String input;
        private final String context;
        private final boolean checkRequired;

        MemberBuilder(RubyCodeWriter writer, SymbolProvider symbolProvider, String memberSetter, String input, String context, boolean checkRequired) {
            this.writer = writer;
            this.symbolProvider = symbolProvider;
            this.memberSetter = memberSetter;
            this.input = input;
            this.context = context;
            this.checkRequired = checkRequired;
        }

        private String checkRequired() {
            if (this.checkRequired) {
                return " unless " + this.input + ".nil?";
            }
            return "";
        }

        protected Void getDefault(Shape shape) {
            this.writer.write(this.memberSetter + this.input, new Object[0]);
            return null;
        }

        public Void listShape(ListShape shape) {
            String shapeName = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("$1L$2L.build($3L, context: $4L)$5L", new Object[]{this.memberSetter, shapeName, this.input, this.context, this.checkRequired()});
            return null;
        }

        public Void setShape(SetShape shape) {
            String shapeName = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("$1L$2L.build($3L, context: $4L)$5L", new Object[]{this.memberSetter, shapeName, this.input, this.context, this.checkRequired()});
            return null;
        }

        public Void mapShape(MapShape shape) {
            String shapeName = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("$1L$2L.build($3L, context: $4L)$5L", new Object[]{this.memberSetter, shapeName, this.input, this.context, this.checkRequired()});
            return null;
        }

        public Void structureShape(StructureShape shape) {
            String shapeName = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("$1L$2L.build($3L, context: $4L)$5L", new Object[]{this.memberSetter, shapeName, this.input, this.context, this.checkRequired()});
            return null;
        }

        public Void unionShape(UnionShape shape) {
            String shapeName = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("$1L$2L.build($3L, context: $4L)$5L", new Object[]{this.memberSetter, shapeName, this.input, this.context, this.checkRequired()});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            this.writer.write(this.memberSetter + this.input, new Object[0]);
            return null;
        }
    }
}

