/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpResponseCodeTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public abstract class HttpParserGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(HttpParserGeneratorBase.class.getName());
    protected final GenerationContext context;
    protected final RubySettings settings;
    protected final Model model;
    protected final Set<ShapeId> generatedParsers;
    protected final SymbolProvider symbolProvider;
    protected final RubyCodeWriter writer;

    public HttpParserGeneratorBase(GenerationContext context) {
        this.context = context;
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.generatedParsers = new HashSet<ShapeId>();
        this.writer = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(this.model, this.settings, "Params", true);
    }

    protected abstract void renderPayloadBodyParser(Shape var1, MemberShape var2, Shape var3);

    protected abstract void renderNoPayloadBodyParser(Shape var1);

    protected abstract void renderUnionMemberParser(UnionShape var1, MemberShape var2);

    protected abstract String unionMemberDataName(UnionShape var1, MemberShape var2);

    protected abstract void renderMapMemberParser(MapShape var1);

    protected abstract void renderSetMemberParser(SetShape var1);

    protected abstract void renderListMemberParser(ListShape var1);

    protected abstract void renderStructureMemberParsers(StructureShape var1);

    public void render(FileManifest fileManifest) {
        this.writer.writePreamble().write("require 'base64'\n", new Object[0]).openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Parsers", new Object[0]).call(() -> this.renderParsers()).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/parsers.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote parsers to " + fileName);
    }

    protected void renderParsers() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        TreeSet containedOperations = new TreeSet(topDownIndex.getContainedOperations((ToShapeId)this.context.getService()));
        containedOperations.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> {
            Shape outputShape = this.model.expectShape(o.getOutputShape());
            this.renderParsersForOperation((OperationShape)o, outputShape);
            this.generatedParsers.add(o.toShapeId());
            this.generatedParsers.add(outputShape.toShapeId());
            Iterator it = new Walker(this.model).iterateShapes(outputShape);
            while (it.hasNext()) {
                Shape s = (Shape)it.next();
                if (this.generatedParsers.contains(s.getId())) continue;
                this.generatedParsers.add(s.getId());
                s.accept((ShapeVisitor)new ParserClassGenerator());
            }
            for (ShapeId errorShapeId : o.getErrors()) {
                Iterator errIt = new Walker(this.model).iterateShapes(this.model.expectShape(errorShapeId));
                while (errIt.hasNext()) {
                    Shape s = (Shape)errIt.next();
                    if (this.generatedParsers.contains(s.getId())) continue;
                    this.generatedParsers.add(s.getId());
                    if (s.hasTrait(ErrorTrait.class)) {
                        this.renderErrorParser(s);
                        continue;
                    }
                    s.accept((ShapeVisitor)new ParserClassGenerator());
                }
            }
        });
    }

    protected void renderParsersForOperation(OperationShape operation, Shape outputShape) {
        this.writer.write("", new Object[0]).write((Object)"# Operation Parser for $L", new Object[]{operation.getId().getName()}).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol((Shape)operation).getName()}).openBlock("def self.parse(http_resp)", new Object[0]).write((Object)"data = Types::$L.new", new Object[]{this.symbolProvider.toSymbol(outputShape).getName()}).call(() -> this.renderHeaderParsers(outputShape)).call(() -> this.renderPrefixHeaderParsers(outputShape)).call(() -> this.renderResponseCodeParser(outputShape)).call(() -> this.renderOperationBodyParser(outputShape)).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated parser class for " + operation.getId().getName());
    }

    protected void renderErrorParser(Shape s) {
        this.writer.write("", new Object[0]).write((Object)"# Error Parser for $L", new Object[]{s.getId().getName()}).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol(s).getName()}).openBlock("def self.parse(http_resp)", new Object[0]).write((Object)"data = Types::$L.new", new Object[]{this.symbolProvider.toSymbol(s).getName()}).call(() -> this.renderHeaderParsers(s)).call(() -> this.renderPrefixHeaderParsers(s)).call(() -> this.renderOperationBodyParser(s)).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated Error parser for " + s.getId().getName());
    }

    protected void renderHeaderParsers(Shape outputShape) {
        List headerMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpHeaderTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpHeaderTrait headerTrait = (HttpHeaderTrait)m2.expectTrait(HttpHeaderTrait.class);
            String symbolName = this.symbolProvider.toMemberName(m2);
            String dataSetter = "data." + symbolName + " = ";
            String valueGetter = "http_resp.headers['" + headerTrait.getValue() + "']";
            this.model.expectShape(m2.getTarget()).accept((ShapeVisitor)new HeaderDeserializer(m2, dataSetter, valueGetter));
            LOGGER.finest("Generated header parser for " + m2.getMemberName());
        }
    }

    protected void renderPrefixHeaderParsers(Shape outputShape) {
        List headerMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpPrefixHeadersTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpPrefixHeadersTrait headerTrait = (HttpPrefixHeadersTrait)m2.expectTrait(HttpPrefixHeadersTrait.class);
            String prefix = headerTrait.getValue();
            MapShape targetShape = (MapShape)this.model.expectShape(m2.getTarget(), MapShape.class);
            Shape valueShape = this.model.expectShape(targetShape.getValue().getTarget());
            String symbolName = this.symbolProvider.toMemberName(m2);
            String dataSetter = "data." + symbolName + "[key.delete_prefix('" + prefix + "')] = ";
            this.writer.write("data.$L = {}", new Object[]{symbolName}).openBlock("http_resp.headers.each do |key, value|", new Object[0]).openBlock("if key.start_with?('$L')", new Object[]{prefix}).call(() -> {
                Void cfr_ignored_0 = (Void)valueShape.accept((ShapeVisitor)new HeaderDeserializer(m2, dataSetter, "value"));
            }).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            LOGGER.finest("Generated prefix header parser for " + m2.getMemberName());
        }
    }

    protected void renderResponseCodeParser(Shape outputShape) {
        List responseCodeMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpResponseCodeTrait.class)).collect(Collectors.toList());
        if (responseCodeMembers.size() == 1) {
            MemberShape responseCodeMember = (MemberShape)responseCodeMembers.get(0);
            this.writer.write("data.$L = http_resp.status", new Object[]{this.symbolProvider.toMemberName(responseCodeMember)});
            LOGGER.finest("Generated response code parser for " + responseCodeMember.getMemberName());
        }
    }

    protected void renderOperationBodyParser(Shape outputShape) {
        List httpPayloadMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpPayloadTrait.class)).collect(Collectors.toList());
        if (httpPayloadMembers.size() == 0) {
            this.renderNoPayloadBodyParser(outputShape);
        } else if (httpPayloadMembers.size() == 1) {
            MemberShape payloadMember = (MemberShape)httpPayloadMembers.get(0);
            Shape target = this.model.expectShape(payloadMember.getTarget());
            this.renderPayloadBodyParser(outputShape, payloadMember, target);
        }
    }

    private class HeaderListMemberDeserializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;

        HeaderListMemberDeserializer(MemberShape memberShape) {
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void stringShape(StringShape shape) {
            HttpParserGeneratorBase.this.writer.write(".map { |s| s.to_s }", new Object[0]);
            return null;
        }

        public Void booleanShape(BooleanShape shape) {
            HttpParserGeneratorBase.this.writer.write(".map { |s| s == 'true' }", new Object[0]);
            return null;
        }

        public Void integerShape(IntegerShape shape) {
            HttpParserGeneratorBase.this.writer.write(".map { |s| s.to_i }", new Object[0]);
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        HttpParserGeneratorBase.this.writer.write(".map { |s| Time.at(s.to_i) }", new Object[0]);
                        break;
                    }
                    default: {
                        HttpParserGeneratorBase.this.writer.write(".map { |s| Time.parse(s) }", new Object[0]);
                        break;
                    }
                }
            } else {
                HttpParserGeneratorBase.this.writer.write(".map { |s| Time.parse(s) }", new Object[0]);
            }
            return null;
        }
    }

    private class HeaderDeserializer
    extends ShapeVisitor.Default<Void> {
        private final String valueGetter;
        private final String dataSetter;
        private final MemberShape memberShape;

        HeaderDeserializer(MemberShape memberShape, String dataSetter, String valueGetter) {
            this.valueGetter = valueGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            HttpParserGeneratorBase.this.writer.write("$L$L", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void booleanShape(BooleanShape shape) {
            HttpParserGeneratorBase.this.writer.write("$1L$2L == 'true' unless $2L.nil?", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void integerShape(IntegerShape shape) {
            HttpParserGeneratorBase.this.writer.write("$1L$2L&.to_i", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void byteShape(ByteShape shape) {
            HttpParserGeneratorBase.this.writer.write("$1L$2L&.to_i", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void longShape(LongShape shape) {
            HttpParserGeneratorBase.this.writer.write("$1L$2L&.to_i", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void shortShape(ShortShape shape) {
            HttpParserGeneratorBase.this.writer.write("$1L$2L&.to_i", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void floatShape(FloatShape shape) {
            HttpParserGeneratorBase.this.writer.write("$1L$2L&.to_f", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void doubleShape(DoubleShape shape) {
            HttpParserGeneratorBase.this.writer.write("$1L$2L&.to_f", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (shape.hasTrait(MediaTypeTrait.class)) {
                HttpParserGeneratorBase.this.writer.write("$1LBase64::decode64($2L).strip unless $2L.nil?", new Object[]{this.dataSetter, this.valueGetter});
            } else {
                HttpParserGeneratorBase.this.writer.write("$1L$2L", new Object[]{this.dataSetter, this.valueGetter});
            }
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (!format.isPresent()) {
                format = shape.getTrait(TimestampFormatTrait.class);
            }
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        HttpParserGeneratorBase.this.writer.write("$1LTime.at($2L.to_i) if $2L", new Object[]{this.dataSetter, this.valueGetter});
                        break;
                    }
                    default: {
                        HttpParserGeneratorBase.this.writer.write("$1LTime.parse($2L) if $2L", new Object[]{this.dataSetter, this.valueGetter});
                        break;
                    }
                }
            } else {
                HttpParserGeneratorBase.this.writer.write("$1LTime.parse($2L) if $2L", new Object[]{this.dataSetter, this.valueGetter});
            }
            return null;
        }

        public Void listShape(ListShape shape) {
            HttpParserGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.valueGetter}).write((Object)"$1L$2L", new Object[]{this.dataSetter, this.valueGetter}).indent().write((Object)".split(', ')", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)HttpParserGeneratorBase.this.model.expectShape(shape.getMember().getTarget()).accept((ShapeVisitor)new HeaderListMemberDeserializer(shape.getMember()));
            }).dedent().closeBlock("end", new Object[0]);
            return null;
        }

        public Void setShape(SetShape shape) {
            HttpParserGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.valueGetter}).write((Object)"$1LSet.new($2L", new Object[]{this.dataSetter, this.valueGetter}).indent().write((Object)".split(', ')", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)HttpParserGeneratorBase.this.model.expectShape(shape.getMember().getTarget()).accept((ShapeVisitor)new HeaderListMemberDeserializer(shape.getMember()));
            }).dedent().write((Object)")", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }
    }

    private class ParserClassGenerator
    extends ShapeVisitor.Default<Void> {
        private ParserClassGenerator() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape s) {
            HttpParserGeneratorBase.this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{HttpParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()}).openBlock("def self.parse(map)", new Object[0]).write((Object)"data = Types::$L.new", new Object[]{HttpParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()}).call(() -> HttpParserGeneratorBase.this.renderStructureMemberParsers(s)).write((Object)"return data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void listShape(ListShape s) {
            HttpParserGeneratorBase.this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{HttpParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()}).openBlock("def self.parse(list)", new Object[0]).openBlock("list.map do |value|", new Object[0]).call(() -> HttpParserGeneratorBase.this.renderListMemberParser(s)).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void setShape(SetShape s) {
            HttpParserGeneratorBase.this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{HttpParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()}).openBlock("def self.parse(list)", new Object[0]).openBlock("data = list.map do |value|", new Object[0]).call(() -> HttpParserGeneratorBase.this.renderSetMemberParser(s)).closeBlock("end", new Object[0]).write((Object)"Set.new(data)", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape s) {
            HttpParserGeneratorBase.this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{HttpParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()}).openBlock("def self.parse(map)", new Object[0]).write((Object)"data = {}", new Object[0]).openBlock("map.map do |key, value|", new Object[0]).call(() -> HttpParserGeneratorBase.this.renderMapMemberParser(s)).closeBlock("end", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape s) {
            HttpParserGeneratorBase.this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{HttpParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()}).openBlock("def self.parse(map)", new Object[0]).write((Object)"key, value = map.flatten", new Object[0]).write((Object)"case key", new Object[0]).call(() -> s.members().forEach(member -> HttpParserGeneratorBase.this.writer.write("when '$L'", new Object[]{HttpParserGeneratorBase.this.unionMemberDataName(s, (MemberShape)member)}).indent().call(() -> HttpParserGeneratorBase.this.renderUnionMemberParser(s, (MemberShape)member)).write((Object)"Types::$L::$L.new(value) if value", new Object[]{HttpParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName(), HttpParserGeneratorBase.this.symbolProvider.toMemberName(member)}).dedent())).openBlock("else", new Object[0]).write((Object)"Types::$L::Unknown.new({name: key, value: value})", new Object[]{s.getId().getName()}).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }
    }
}

