/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.ruby.codegen.ClientConfig;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.generators.docs.ShapeDocumentationGenerator;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareBuilder;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public class ClientGenerator {
    private static final Logger LOGGER = Logger.getLogger(ClientGenerator.class.getName());
    private final GenerationContext context;
    private final RubySettings settings;
    private final MiddlewareBuilder middlewareBuilder;
    private final List<ClientConfig> clientConfig;
    private final SymbolProvider symbolProvider;
    private final Model model;
    private final RubyCodeWriter writer;
    private final RubyCodeWriter rbsWriter;

    public ClientGenerator(GenerationContext context) {
        this.context = context;
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.writer = new RubyCodeWriter();
        this.rbsWriter = new RubyCodeWriter();
        this.middlewareBuilder = new MiddlewareBuilder();
        this.middlewareBuilder.addDefaultMiddleware(context);
        context.getIntegrations().forEach(integration -> {
            this.middlewareBuilder.register(integration.getClientMiddleware());
            LOGGER.fine("Integration " + integration + " registered middleware: " + integration.getClientMiddleware().stream().map(m -> m.toString()).collect(Collectors.joining(",")));
        });
        Set<ClientConfig> unorderedConfig = ClientConfig.defaultConfig();
        unorderedConfig.addAll(context.getApplicationTransport().getClientConfig());
        unorderedConfig.addAll(this.middlewareBuilder.getClientConfig(context));
        unorderedConfig.addAll(context.getIntegrations().stream().map(i -> i.getAdditionalClientConfig()).flatMap(Collection::stream).collect(Collectors.toList()));
        this.clientConfig = unorderedConfig.stream().sorted(Comparator.comparing(ClientConfig::getName)).collect(Collectors.toList());
        LOGGER.fine("Client config: " + this.clientConfig.stream().map(m -> m.toString()).collect(Collectors.joining(",")));
        this.symbolProvider = new RubySymbolProvider(this.model, context.getRubySettings(), "Client", false);
    }

    public void render() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.writer.writePreamble();
        List<String> additionalFiles = this.middlewareBuilder.writeAdditionalFiles(this.context);
        for (String require : additionalFiles) {
            this.writer.write("require_relative '$L'", new Object[]{this.removeRbExtension(require)});
            LOGGER.finer("Adding client require: " + require);
        }
        if (additionalFiles.size() > 0) {
            this.writer.write("", new Object[0]);
        }
        this.writer.openBlock("module $L", new Object[]{this.settings.getModule()}).write((Object)"# An API client for $L", new Object[]{this.settings.getService().getName()}).write((Object)"# See {#initialize} for a full list of supported configuration options", new Object[0]);
        String documentation = new ShapeDocumentationGenerator(this.model, this.symbolProvider, (Shape)this.context.getService()).render();
        this.writer.writeInline(documentation, new Object[0]).openBlock("class Client", new Object[0]).write((Object)"include Seahorse::ClientStubs", new Object[0]).write((Object)"\n@middleware = Seahorse::MiddlewareBuilder.new", new Object[0]).openBlock("\ndef self.middleware", new Object[0]).write((Object)"@middleware", new Object[0]).closeBlock("end", new Object[0]).call(() -> this.renderInitializeMethod()).call(() -> this.renderOperations()).write((Object)"\nprivate", new Object[0]).call(() -> this.renderApplyMiddlewareMethod()).call(() -> this.renderOutputStreamMethod()).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/client.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote client to " + fileName);
    }

    public void renderRbs() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.rbsWriter.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("class Client", new Object[0]).write((Object)"include Seahorse::ClientStubs\n", new Object[0]).write((Object)"def self.middleware: () -> untyped\n", new Object[0]).write((Object)"def initialize: (?::Hash[untyped, untyped] options) -> void", new Object[0]).call(() -> this.renderRbsOperations()).write((Object)"", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String typesFile = this.settings.getGemName() + "/sig/" + this.settings.getGemName() + "/client.rbs";
        fileManifest.writeFile(typesFile, this.rbsWriter.toString());
        LOGGER.fine("Wrote client rbs to " + typesFile);
    }

    private Object removeRbExtension(String s) {
        if (s != null && s.endsWith(".rb")) {
            return s.split(".rb")[0];
        }
        return s;
    }

    private void renderInitializeMethod() {
        this.writer.call(() -> this.renderInitializeDocumentation()).openBlock("def initialize(options = {})", new Object[0]).call(() -> this.clientConfig.forEach(cfg -> {
            if (StringUtils.isNotBlank((CharSequence)cfg.getInitializationCustomization())) {
                this.writer.writeWithNoFormatting(cfg.getInitializationCustomization());
            } else if (StringUtils.isEmpty((CharSequence)cfg.getDefaultValue())) {
                this.writer.write("@$1L = options[:$1L]", new Object[]{cfg.getName()});
            } else {
                this.writer.write("@$1L = options.fetch(:$1L, $2L)", new Object[]{cfg.getName(), cfg.getDefaultValue()});
            }
        })).write((Object)"", new Object[0]).call(() -> this.clientConfig.forEach(cfg -> {
            if (StringUtils.isNotBlank((CharSequence)cfg.getPostInitializeCustomization())) {
                this.writer.writeWithNoFormatting(cfg.getPostInitializeCustomization());
            }
        })).closeBlock("end", new Object[0]);
    }

    private void renderInitializeDocumentation() {
        this.writer.write("", new Object[0]);
        this.writer.doc(() -> {
            this.writer.write("@overload initialize(options)", new Object[0]);
            this.writer.write("@param [Hash] options", new Object[0]);
            this.clientConfig.forEach(cfg -> {
                if (StringUtils.isNotBlank((CharSequence)cfg.getDocumentation())) {
                    this.writer.write("@option options [$L] :$L $L", new Object[]{cfg.getType(), cfg.getName(), StringUtils.isNotBlank((CharSequence)cfg.getDefaultValue()) ? "(" + cfg.getDefaultValue() + ")" : ""});
                    this.writer.write("  $L", new Object[]{cfg.getDocumentation()});
                    this.writer.write("", new Object[0]);
                }
            });
        });
    }

    private void renderOperations() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        TreeSet containedOperations = new TreeSet(topDownIndex.getContainedOperations((ToShapeId)this.context.getService()));
        containedOperations.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> this.renderOperation((OperationShape)o));
    }

    private void renderRbsOperations() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        TreeSet containedOperations = new TreeSet(topDownIndex.getContainedOperations((ToShapeId)this.context.getService()));
        containedOperations.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> this.renderRbsOperation((OperationShape)o));
    }

    private void renderOperation(OperationShape operation) {
        Symbol symbol = this.symbolProvider.toSymbol((Shape)operation);
        ShapeId inputShapeId = operation.getInputShape();
        Shape inputShape = this.model.expectShape(inputShapeId);
        String operationName = RubyFormatter.toSnakeCase(symbol.getName());
        String documentation = new ShapeDocumentationGenerator(this.model, this.symbolProvider, (Shape)operation).render();
        this.writer.write("", new Object[0]).writeInline((Object)documentation, new Object[0]).openBlock("def $L(params = {}, options = {}, &block)", new Object[]{operationName}).write((Object)"stack = Seahorse::MiddlewareStack.new", new Object[0]).write((Object)"input = Params::$L.build(params)", new Object[]{this.symbolProvider.toSymbol(inputShape).getName()}).call(() -> this.middlewareBuilder.render(this.writer, this.context, operation)).write((Object)"apply_middleware(stack, options[:middleware])\n", new Object[0]).openBlock("resp = stack.run(", new Object[0]).write((Object)"input: input,", new Object[0]).openBlock("context: Seahorse::Context.new(", new Object[0]).write((Object)"request: $L,", new Object[]{this.context.getApplicationTransport().getRequest().render(this.context)}).write((Object)"response: $L,", new Object[]{this.context.getApplicationTransport().getResponse().render(this.context)}).write((Object)"params: params,", new Object[0]).write((Object)"logger: @logger,", new Object[0]).write((Object)"operation_name: :$L", new Object[]{operationName}).closeBlock(")", new Object[0]).closeBlock(")", new Object[0]).write((Object)"raise resp.error if resp.error", new Object[0]).write((Object)"resp.data", new Object[0]).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated client operation method " + operationName);
    }

    private void renderRbsOperation(OperationShape operation) {
        Symbol symbol = this.symbolProvider.toSymbol((Shape)operation);
        String operationName = RubyFormatter.toSnakeCase(symbol.getName());
        this.rbsWriter.write("def $L: (?::Hash[untyped, untyped] params, ?::Hash[untyped, untyped] options){ () -> untyped } -> untyped", new Object[]{operationName});
    }

    private void renderApplyMiddlewareMethod() {
        this.writer.openBlock("\ndef apply_middleware(middleware_stack, middleware)", new Object[0]).write((Object)"Client.middleware.apply(middleware_stack)", new Object[0]).write((Object)"@middleware.apply(middleware_stack)", new Object[0]).write((Object)"Seahorse::MiddlewareBuilder.new(middleware).apply(middleware_stack)", new Object[0]).closeBlock("end", new Object[0]);
    }

    private void renderOutputStreamMethod() {
        this.writer.openBlock("\ndef output_stream(options = {}, &block)", new Object[0]).write((Object)"return options[:output_stream] if options[:output_stream]", new Object[0]).write((Object)"return Seahorse::BlockIO.new(block) if block", new Object[0]).write((Object)"\nStringIO.new", new Object[0]).closeBlock("end", new Object[0]);
    }
}

