/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.ReservedWordSymbolProvider;
import software.amazon.smithy.codegen.core.ReservedWords;
import software.amazon.smithy.codegen.core.ReservedWordsBuilder;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.utils.CaseUtils;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyUnstableApi
public class RubySymbolProvider
implements SymbolProvider,
ShapeVisitor<Symbol> {
    private final Model model;
    private final RubySettings settings;
    private final String rootModuleName;
    private final String moduleName;
    private final boolean complexTypes;
    private final ReservedWordSymbolProvider.Escaper escaper;

    public RubySymbolProvider(Model model, RubySettings settings, String moduleName, boolean complexTypes) {
        this.model = model;
        this.settings = settings;
        this.rootModuleName = settings.getModule();
        this.moduleName = this.rootModuleName + "::" + moduleName;
        this.complexTypes = complexTypes;
        this.escaper = ReservedWordSymbolProvider.builder().nameReservedWords(this.rubyReservedNames()).memberReservedWords(this.memberReservedNames()).buildEscaper();
    }

    private ReservedWords rubyReservedNames() {
        String[] reserved;
        ReservedWordsBuilder reservedNames = new ReservedWordsBuilder();
        for (String w : reserved = new String[]{"alias", "break", "BEGIN", "case", "class", "def", "do", "else", "elsif", "end", "ensure", "for", "if", "in", "next", "nil", "module"}) {
            reservedNames.put(w, w + "_");
        }
        return reservedNames.build();
    }

    private ReservedWords memberReservedNames() {
        String[] reserved;
        ReservedWordsBuilder reservedNames = new ReservedWordsBuilder();
        for (String w : reserved = new String[]{"allocate", "superclass", "new", "included_modules", "name", "ancestors", "attr", "attr_reader", "attr_writer", "attr_accessor", "instance_methods", "public_instance_methods", "protected_instance_methods", "private_instance_methods", "constants", "const_get", "const_set", "class_variables", "remove_class_variable", "class_variable_get", "class_variable_set", "freeze", "inspect", "private_constant", "public_constant", "const_missing", "deprecate_constant", "include", "prepend", "module_exec", "module_eval", "class_eval", "remove_method", "undef_method", "class_exec", "alias_method", "to_s", "private_class_method", "public_class_method", "autoload", "instance_method", "public_instance_method", "define_method", "remove_instance_variable", "tap", "instance_variable_set", "protected_methods", "instance_variables", "instance_variable_get", "public_methods", "private_methods", "method", "public_method", "public_send", "singleton_method", "define_singleton_method", "extend", "to_enum", "enum_for", "object_id", "send", "display", "hash", "class", "singleton_class", "clone", "dup", "itself", "yield_self", "then", "taint", "untaint", "untrust", "trust", "methods", "singleton_methods", "instance_exec", "instance_eval", "__id__", "__send__"}) {
            reservedNames.put(w, "member_" + w);
        }
        return reservedNames.build();
    }

    public Symbol toSymbol(Shape shape) {
        Symbol symbol = (Symbol)shape.accept((ShapeVisitor)this);
        return this.escaper.escapeSymbol(shape, symbol);
    }

    public String toMemberName(MemberShape shape) {
        Shape container = this.model.expectShape(shape.getContainer());
        if (container.isUnionShape()) {
            String memberName = CaseUtils.toPascalCase((String)this.getDefaultMemberName(shape));
            if (memberName.equals("Unknown")) {
                return "MemberUnknown";
            }
            return memberName;
        }
        return this.getDefaultMemberName(shape);
    }

    private String getDefaultMemberName(MemberShape shape) {
        return this.prefixLeadingInvalidIdentCharacters(this.escaper.escapeMemberName(RubyFormatter.toSnakeCase(shape.getMemberName())), "member_");
    }

    private String getDefaultShapeName(Shape shape, String prefix) {
        ServiceShape serviceShape = (ServiceShape)this.model.expectShape(this.settings.getService(), ServiceShape.class);
        return StringUtils.capitalize((String)this.prefixLeadingInvalidIdentCharacters(shape.getId().getName(serviceShape), prefix));
    }

    private String prefixLeadingInvalidIdentCharacters(String value, String prefix) {
        if (!Character.isLetter(value.charAt(0))) {
            return prefix + value;
        }
        return value;
    }

    private Symbol.Builder createSymbolBuilder(Shape shape, String type, String rbsType, String yardType) {
        return ((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)Symbol.builder().putProperty("shape", (Object)shape)).putProperty("rbsType", (Object)rbsType)).putProperty("yardType", (Object)yardType)).name(type);
    }

    private Symbol.Builder createSymbolBuilder(Shape shape, String type, String rbsType, String yardType, String namespace) {
        return this.createSymbolBuilder(shape, type, rbsType, yardType).namespace(namespace, "::");
    }

    public Symbol stringShape(StringShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "String", "String").build();
    }

    public Symbol blobShape(BlobShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "String", "String").build();
    }

    public Symbol booleanShape(BooleanShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "bool", "Boolean").build();
    }

    public Symbol byteShape(ByteShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "Integer", "Integer").build();
    }

    public Symbol shortShape(ShortShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "Integer", "Integer").build();
    }

    public Symbol integerShape(IntegerShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "Integer", "Integer").build();
    }

    public Symbol longShape(LongShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "Integer", "Integer").build();
    }

    public Symbol floatShape(FloatShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "Float", "Float").build();
    }

    public Symbol doubleShape(DoubleShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "Float", "Float").build();
    }

    public Symbol bigIntegerShape(BigIntegerShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "Integer", "Integer").build();
    }

    public Symbol bigDecimalShape(BigDecimalShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "BigDecimal", "BigDecimal").addDependency((SymbolDependencyContainer)RubyDependency.BIG_DECIMAL).build();
    }

    public Symbol timestampShape(TimestampShape shape) {
        RubyDependency d = RubyDependency.TIME;
        return this.createSymbolBuilder((Shape)shape, "", "Time", "Time").addDependency((SymbolDependencyContainer)d).build();
    }

    public Symbol listShape(ListShape shape) {
        if (this.complexTypes) {
            return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "List"), "", "", this.moduleName).definitionFile("types.rb").build();
        }
        Symbol member = this.toSymbol(this.model.expectShape(shape.getMember().getTarget()));
        String rbsType = "Array[" + member.getProperty("rbsType").get() + "]";
        String yardType = "Array<" + member.getProperty("yardType").get() + ">";
        return this.createSymbolBuilder((Shape)shape, "", rbsType, yardType).build();
    }

    public Symbol setShape(SetShape shape) {
        if (this.complexTypes) {
            return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "Set"), "", "", this.moduleName).definitionFile("types.rb").build();
        }
        Symbol member = this.toSymbol(this.model.expectShape(shape.getMember().getTarget()));
        String rbsType = "Set[" + member.getProperty("rbsType").get() + "]";
        String yardType = "Set<" + member.getProperty("yardType").get() + ">";
        return this.createSymbolBuilder((Shape)shape, "", rbsType, yardType).build();
    }

    public Symbol mapShape(MapShape shape) {
        if (this.complexTypes) {
            return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "Map"), "", "", this.moduleName).definitionFile("types.rb").build();
        }
        Symbol key = this.toSymbol(this.model.expectShape(shape.getKey().getTarget()));
        Symbol value = this.toSymbol(this.model.expectShape(shape.getValue().getTarget()));
        String rbsType = "Hash[" + key.getProperty("rbsType").get() + ", " + value.getProperty("rbsType").get() + "]";
        String yardType = "Hash<" + key.getProperty("yardType").get() + ", " + value.getProperty("yardType").get() + ">";
        return this.createSymbolBuilder((Shape)shape, "", rbsType, yardType).build();
    }

    public Symbol documentShape(DocumentShape shape) {
        if (this.complexTypes) {
            return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "Document"), "", "", this.moduleName).definitionFile("types.rb").build();
        }
        String rbsType = "document";
        String yardType = "Hash,Array,String,Boolean,Numeric";
        return this.createSymbolBuilder((Shape)shape, "", rbsType, yardType).build();
    }

    public Symbol serviceShape(ServiceShape shape) {
        return this.createSymbolBuilder((Shape)shape, "Client", "", "").namespace(this.rootModuleName, "::").definitionFile("client.rb").build();
    }

    public Symbol structureShape(StructureShape shape) {
        String name = this.getDefaultShapeName((Shape)shape, "Struct");
        return this.createSymbolBuilder((Shape)shape, name, name, name, this.moduleName).definitionFile("types.rb").build();
    }

    public Symbol unionShape(UnionShape shape) {
        String name = this.getDefaultShapeName((Shape)shape, "Union");
        return this.createSymbolBuilder((Shape)shape, name, name, name, this.moduleName).definitionFile("types.rb").build();
    }

    public Symbol memberShape(MemberShape shape) {
        Shape targetShape = this.model.expectShape(shape.getTarget());
        return this.toSymbol(targetShape);
    }

    public Symbol operationShape(OperationShape shape) {
        return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "Operation"), "", "", this.moduleName).definitionFile("types.rb").build();
    }

    public Symbol resourceShape(ResourceShape shape) {
        throw new CodegenException("Resources are not currently supported");
    }
}

