/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import software.amazon.smithy.utils.CodeWriter;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public class RubyCodeWriter
extends CodeWriter {
    public RubyCodeWriter() {
        this.trimTrailingSpaces();
        this.trimBlankLines();
        this.setIndentText("  ");
    }

    public RubyCodeWriter writePreamble() {
        this.write("# frozen_string_literal: true\n", new Object[0]);
        this.write("# WARNING ABOUT GENERATED CODE", new Object[0]);
        this.write("#", new Object[0]);
        this.write("# This file was code generated using smithy-ruby.", new Object[0]);
        this.write("# https://github.com/awslabs/smithy-ruby", new Object[0]);
        this.write("#", new Object[0]);
        this.write("# WARNING ABOUT GENERATED CODE\n", new Object[0]);
        return this;
    }

    public RubyCodeWriter doc(Runnable task) {
        this.pushState();
        this.setNewlinePrefix("# ");
        task.run();
        this.popState();
        return this;
    }

    public RubyCodeWriter writeYardAttribute(String attribute, Runnable task) {
        this.doc(() -> {
            this.write("@!attribute $L", new Object[]{attribute});
            this.pushFilteredState(s -> s.replace("#", " "));
            task.run();
            this.popState();
        });
        return this;
    }

    public RubyCodeWriter writeDocstring(String docstring) {
        this.doc(() -> {
            this.write(docstring, new Object[0]);
            this.write("", new Object[0]);
        });
        return this;
    }

    public RubyCodeWriter writeYardParam(String returnType, String param, String documentation) {
        this.doc(() -> {
            this.write("@param [$L] $L", new Object[]{returnType, param});
            this.writeIndentedParts(documentation);
            this.write("", new Object[0]);
        });
        return this;
    }

    public RubyCodeWriter writeYardOption(String param, String type, String option, String defaultValue, String documentation) {
        this.doc(() -> {
            this.writeInline("@option $L [$L] $L", new Object[]{param, type, option});
            if (!defaultValue.isEmpty()) {
                this.write(" ($L)", new Object[]{defaultValue});
            } else {
                this.write("", new Object[0]);
            }
            this.writeIndentedParts(documentation);
            this.write("", new Object[0]);
        });
        return this;
    }

    public RubyCodeWriter writeYardReturn(String returnType, String documentation) {
        this.doc(() -> {
            this.write("@return [$L]", new Object[]{returnType});
            this.writeIndentedParts(documentation);
            this.write("", new Object[0]);
        });
        return this;
    }

    public RubyCodeWriter writeYardExample(String title, String block) {
        this.doc(() -> {
            this.write("@example $L", new Object[]{title});
            this.write("", new Object[0]);
            this.writeIndentedParts(block);
            this.write("", new Object[0]);
        });
        return this;
    }

    public RubyCodeWriter writeYardDeprecated(String message, String since) {
        this.doc(() -> {
            this.write("@deprecated", new Object[0]);
            this.writeIndentedParts(message);
            if (!since.isEmpty()) {
                this.write("  Since: $L", new Object[]{since});
            }
            this.write("", new Object[0]);
        });
        return this;
    }

    public RubyCodeWriter writeYardSee(String url, String description) {
        this.doc(() -> {
            this.write("@see $L $L", new Object[]{url, description});
            this.write("", new Object[0]);
        });
        return this;
    }

    public RubyCodeWriter writeYardNote(String note) {
        this.doc(() -> {
            this.write("@note", new Object[0]);
            this.writeIndentedParts(note);
            this.write("", new Object[0]);
        });
        return this;
    }

    public RubyCodeWriter writeYardSince(String since) {
        this.doc(() -> {
            this.write("@since $L", new Object[]{since});
            this.write("", new Object[0]);
        });
        return this;
    }

    private void writeIndentedParts(String documentation) {
        if (!documentation.isEmpty()) {
            String[] docstringParts = documentation.split("\n");
            for (int i = 0; i < docstringParts.length; ++i) {
                this.write("  $L", new Object[]{docstringParts[i]});
            }
        }
    }
}

