/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.TitleTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.ruby.codegen.ApplicationTransport;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.ProtocolGenerator;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubyIntegration;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.ClientGenerator;
import software.amazon.smithy.ruby.codegen.generators.GemspecGenerator;
import software.amazon.smithy.ruby.codegen.generators.HttpProtocolTestGenerator;
import software.amazon.smithy.ruby.codegen.generators.ModuleGenerator;
import software.amazon.smithy.ruby.codegen.generators.PaginatorsGenerator;
import software.amazon.smithy.ruby.codegen.generators.ParamsGenerator;
import software.amazon.smithy.ruby.codegen.generators.TypesGenerator;
import software.amazon.smithy.ruby.codegen.generators.ValidatorsGenerator;
import software.amazon.smithy.ruby.codegen.generators.WaitersGenerator;
import software.amazon.smithy.utils.CodeWriter;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class CodegenOrchestrator {
    private static final Logger LOGGER = Logger.getLogger(CodegenOrchestrator.class.getName());
    private final GenerationContext context;

    public CodegenOrchestrator(PluginContext pluginContext) {
        RubySettings rubySettings = RubySettings.from(pluginContext.getSettings());
        ServiceLoader<RubyIntegration> integrationServiceLoader = ServiceLoader.load(RubyIntegration.class, pluginContext.getPluginClassLoader().orElse(this.getClass().getClassLoader()));
        LOGGER.info("Loading integrations");
        List<RubyIntegration> integrations = StreamSupport.stream(integrationServiceLoader.spliterator(), false).peek(i -> LOGGER.info("Loaded RubyIntegration: " + i.getClass().getName())).sorted(Comparator.comparing(RubyIntegration::getOrder)).collect(Collectors.toList());
        LOGGER.info("Loaded integrations: " + integrations.size());
        Model resolvedModel = pluginContext.getModel();
        for (RubyIntegration integration2 : integrations) {
            resolvedModel = integration2.preprocessModel(pluginContext, resolvedModel, rubySettings);
        }
        ServiceShape service = (ServiceShape)resolvedModel.expectShape(rubySettings.getService()).asServiceShape().orElseThrow(() -> new CodegenException("Shape is not a service"));
        Model finalResolvedModel = resolvedModel = ModelTransformer.create().createDedicatedInputAndOutput(resolvedModel, "Input", "Output");
        integrations = integrations.stream().filter(integration -> integration.includeFor(service, finalResolvedModel)).collect(Collectors.toList());
        HashSet<ShapeId> supportedProtocols = new HashSet<ShapeId>();
        for (RubyIntegration integration3 : integrations) {
            supportedProtocols.addAll(integration3.getProtocolGenerators().stream().map(g -> g.getProtocol()).peek(s -> LOGGER.info(integration3.getClass().getSimpleName() + " registered protocolGenerator for: " + s.getName() + " -> " + s)).collect(Collectors.toSet()));
        }
        ShapeId protocol = rubySettings.resolveServiceProtocol(service, resolvedModel, supportedProtocols);
        Optional<ProtocolGenerator> protocolGenerator = this.resolveProtocolGenerator(protocol, integrations);
        ApplicationTransport applicationTransport = protocolGenerator.isPresent() ? protocolGenerator.get().getApplicationTransport() : ApplicationTransport.createDefaultHttpApplicationTransport();
        LOGGER.info("Resolved ApplicationTransport: " + applicationTransport);
        this.context = new GenerationContext(rubySettings, pluginContext.getFileManifest(), integrations, resolvedModel, service, protocol, protocolGenerator, applicationTransport);
    }

    private Optional<ProtocolGenerator> resolveProtocolGenerator(ShapeId protocol, List<RubyIntegration> integrations) {
        for (RubyIntegration integration : integrations) {
            Optional<ProtocolGenerator> pg = integration.getProtocolGenerators().stream().filter(p -> p.getProtocol().equals((Object)protocol)).findFirst();
            if (!pg.isPresent()) continue;
            return pg;
        }
        return Optional.empty();
    }

    public void execute() {
        this.context.getIntegrations().forEach(integration -> integration.processFinalizedModel(this.context));
        this.generateTypes();
        this.generateParams();
        this.generateValidators();
        this.generateProtocolTests();
        if (this.context.getProtocolGenerator().isPresent()) {
            ProtocolGenerator protocolGenerator = this.context.getProtocolGenerator().get();
            protocolGenerator.generateBuilders(this.context);
            protocolGenerator.generateParsers(this.context);
            protocolGenerator.generateErrors(this.context);
            protocolGenerator.generateStubs(this.context);
        }
        this.generateClient();
        this.generateWaiters();
        this.generatePaginators();
        this.generateModule();
        this.generateGemSpec();
        this.generateYardOpts();
    }

    private void generateTypes() {
        TypesGenerator typesGenerator = new TypesGenerator(this.context);
        typesGenerator.render();
        typesGenerator.renderRbs();
        LOGGER.info("generated types");
    }

    private void generateParams() {
        ParamsGenerator paramsGenerator = new ParamsGenerator(this.context);
        paramsGenerator.render();
        LOGGER.info("generated params");
    }

    private void generateValidators() {
        ValidatorsGenerator validatorsGenerator = new ValidatorsGenerator(this.context);
        validatorsGenerator.render();
        LOGGER.info("generated validators");
    }

    private void generateProtocolTests() {
        if (this.context.getApplicationTransport().isHttpTransport()) {
            HttpProtocolTestGenerator testGenerator = new HttpProtocolTestGenerator(this.context);
            testGenerator.render();
            LOGGER.info("generated protocol tests");
        }
    }

    private void generateClient() {
        ClientGenerator clientGenerator = new ClientGenerator(this.context);
        clientGenerator.render();
        clientGenerator.renderRbs();
        LOGGER.info("generated client");
    }

    private void generateModule() {
        List<String> additionalFiles = this.context.getIntegrations().stream().map(integration -> integration.writeAdditionalFiles(this.context)).flatMap(Collection::stream).collect(Collectors.toList());
        ModuleGenerator moduleGenerator = new ModuleGenerator(this.context);
        moduleGenerator.render(additionalFiles);
        LOGGER.info("generated module");
    }

    private void generateGemSpec() {
        List<RubyDependency> additionalDependencies = this.context.getIntegrations().stream().map(integration -> integration.additionalGemDependencies(this.context)).flatMap(Collection::stream).collect(Collectors.toList());
        GemspecGenerator gemspecGenerator = new GemspecGenerator(this.context);
        gemspecGenerator.render(additionalDependencies);
        LOGGER.info("generated .gemspec");
    }

    private void generateYardOpts() {
        Optional title = this.context.getService().getTrait(TitleTrait.class);
        if (title.isPresent()) {
            FileManifest fileManifest = this.context.getFileManifest();
            CodeWriter writer = new CodeWriter();
            writer.write((Object)"--title \"$L\"", new Object[]{((TitleTrait)title.get()).getValue()});
            writer.write((Object)"--hide-api private", new Object[0]);
            String fileName = this.context.getRubySettings().getGemName() + "/.yardopts";
            fileManifest.writeFile(fileName, writer.toString());
        }
    }

    private void generateWaiters() {
        WaitersGenerator waitersGenerator = new WaitersGenerator(this.context);
        waitersGenerator.render();
        waitersGenerator.renderRbs();
        LOGGER.info("generated waiters");
    }

    private void generatePaginators() {
        PaginatorsGenerator paginatorsGenerator = new PaginatorsGenerator(this.context);
        paginatorsGenerator.render();
        paginatorsGenerator.renderRbs();
        LOGGER.info("generated paginators");
    }
}

