/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.ruby.codegen.ClientConfig;
import software.amazon.smithy.ruby.codegen.ClientFragment;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class ApplicationTransport {
    private final String name;
    private final ClientFragment request;
    private final ClientFragment response;
    private final ClientFragment transportClient;
    private final MiddlewareList defaultMiddleware;

    public ApplicationTransport(String name, ClientFragment request, ClientFragment response, ClientFragment transportClient, MiddlewareList defaultMiddleware) {
        this.name = name;
        this.request = request;
        this.response = response;
        this.transportClient = transportClient;
        this.defaultMiddleware = defaultMiddleware;
    }

    public static ApplicationTransport createDefaultHttpApplicationTransport() {
        ClientConfig endpoint = new ClientConfig.Builder().name("endpoint").type("string").documentation("Endpoint of the service").build();
        ClientFragment request = new ClientFragment.Builder().addConfig(endpoint).render((self, ctx) -> "Seahorse::HTTP::Request.new(url: options.fetch(:endpoint, @endpoint))").build();
        ClientFragment response = new ClientFragment.Builder().render((self, ctx) -> "Seahorse::HTTP::Response.new(body: output_stream(options, &block))").build();
        ClientConfig wireTrace = new ClientConfig.Builder().name("http_wire_trace").type("bool").defaultValue("false").documentation("Enable debug wire trace on http requests.").build();
        ClientConfig logger = new ClientConfig.Builder().name("logger").type("Logger").defaultValue("stdout").initializationCustomization("@logger = options.fetch(:logger, Logger.new($stdout, level: @log_level))").documentation("Logger to use for output").build();
        ClientConfig logLevel = new ClientConfig.Builder().name("log_level").type("symbol").defaultValue(":info").documentation("Default log level to use").build();
        ClientFragment client = new ClientFragment.Builder().addConfig(wireTrace).addConfig(logger).addConfig(logLevel).render((self, ctx) -> "Seahorse::HTTP::Client.new(logger: @logger, http_wire_trace: options.fetch(:http_wire_trace, @http_wire_trace))").build();
        MiddlewareList defaultMiddleware = (transport, context) -> {
            ArrayList<Middleware> middleware = new ArrayList<Middleware>();
            middleware.add(new Middleware.Builder().klass("Seahorse::HTTP::Middleware::ContentLength").step(MiddlewareStackStep.BUILD).build());
            middleware.add(new Middleware.Builder().klass("Seahorse::Middleware::Parse").step(MiddlewareStackStep.DESERIALIZE).operationParams((ctx, operation) -> {
                RubySymbolProvider symbolProvider = new RubySymbolProvider(ctx.getModel(), ctx.getRubySettings(), "Client", false);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("data_parser", "Parsers::" + symbolProvider.toSymbol((Shape)operation).getName());
                String successCode = "200";
                Optional httpTrait = operation.getTrait(HttpTrait.class);
                if (httpTrait.isPresent()) {
                    successCode = "" + ((HttpTrait)httpTrait.get()).getCode();
                }
                String errors = operation.getErrors().stream().map(error -> "Errors::" + symbolProvider.toSymbol(ctx.getModel().expectShape(error)).getName()).collect(Collectors.joining(", "));
                params.put("error_parser", "Seahorse::HTTP::ErrorParser.new(error_module: Errors, error_code_fn: Errors.method(:error_code), success_status: " + successCode + ", errors: [" + errors + "])");
                return params;
            }).build());
            return middleware;
        };
        return new ApplicationTransport("http", request, response, client, defaultMiddleware);
    }

    public String getName() {
        return this.name;
    }

    public boolean isHttpTransport() {
        return this.getName().startsWith("http");
    }

    public ClientFragment getRequest() {
        return this.request;
    }

    public ClientFragment getResponse() {
        return this.response;
    }

    public ClientFragment getTransportClient() {
        return this.transportClient;
    }

    public List<Middleware> defaultMiddleware(GenerationContext context) {
        return this.defaultMiddleware.list(this, context);
    }

    public Set<ClientConfig> getClientConfig() {
        HashSet<ClientConfig> config = new HashSet<ClientConfig>();
        config.addAll(this.request.getClientConfig());
        config.addAll(this.response.getClientConfig());
        config.addAll(this.transportClient.getClientConfig());
        return config;
    }

    public String toString() {
        return "ApplicationTransport<" + this.getName() + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationTransport)) {
            return false;
        }
        ApplicationTransport that = (ApplicationTransport)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @FunctionalInterface
    public static interface MiddlewareList {
        public List<Middleware> list(ApplicationTransport var1, GenerationContext var2);
    }
}

