/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.core;

import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\b\u0010\b\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\f"}, d2={"KOTLIN_COMPILER_VERSION", "", "getKOTLIN_COMPILER_VERSION", "()Ljava/lang/String;", "RUNTIME_GROUP", "RUNTIME_ROOT_NS", "RUNTIME_VERSION", "getRUNTIME_VERSION", "getDefaultRuntimeVersion", "isValidVersion", "", "version", "smithy-kotlin-codegen"})
public final class KotlinDependencyKt {
    @NotNull
    public static final String RUNTIME_ROOT_NS = "aws.smithy.kotlin.runtime";
    @NotNull
    public static final String RUNTIME_GROUP = "aws.smithy.kotlin";
    @NotNull
    private static final String RUNTIME_VERSION;
    @NotNull
    private static final String KOTLIN_COMPILER_VERSION;

    public static final boolean isValidVersion(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Regex re = new Regex("\\d+\\.\\d+\\.\\d[a-z0-9A-Z.-]*$");
        return re.matches((CharSequence)version2);
    }

    private static final String getDefaultRuntimeVersion() {
        try {
            String string;
            URL uRL = new Object(){}.getClass().getResource("sdk-version.txt");
            if (uRL == null) {
                string = null;
            } else {
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                string = new String(byArray, charset);
            }
            if (string == null) {
                throw new CodegenException("sdk-version.txt does not exist");
            }
            String version2 = string;
            if (!KotlinDependencyKt.isValidVersion(version2)) {
                boolean bl = false;
                String string2 = "Version parsed from sdk-version.txt '" + version2 + "' is not a valid version string";
                throw new IllegalStateException(string2.toString());
            }
            return version2;
        }
        catch (Exception ex) {
            throw new CodegenException("failed to load sdk-version.txt which sets the default client-runtime version", (Throwable)ex);
        }
    }

    @NotNull
    public static final String getRUNTIME_VERSION() {
        return RUNTIME_VERSION;
    }

    @NotNull
    public static final String getKOTLIN_COMPILER_VERSION() {
        return KOTLIN_COMPILER_VERSION;
    }

    static {
        String string = System.getProperty("smithy.kotlin.codegen.clientRuntimeVersion", KotlinDependencyKt.getDefaultRuntimeVersion());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"smithy.kotl\u2026tDefaultRuntimeVersion())");
        RUNTIME_VERSION = string;
        string = System.getProperty("smithy.kotlin.codegen.kotlinCompilerVersion", "1.6.10");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"smithy.kotl\u2026mpilerVersion\", \"1.6.10\")");
        KOTLIN_COMPILER_VERSION = string;
    }
}

