/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RenderingContext;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.ExceptionBaseClassGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.StructureGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.ClientErrorCorrection;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.RetryableTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0002J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0002J\b\u0010 \u001a\u00020\u0012H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u0012H\u0002J\b\u0010%\u001a\u00020\u0012H\u0002J\b\u0010&\u001a\u00020\u0012H\u0002J\b\u0010'\u001a\u00020\u0012H\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u0012H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/StructureGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/StructureShape;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;)V", "shape", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "symbolProvider", "Lsoftware/amazon/smithy/codegen/core/SymbolProvider;", "model", "Lsoftware/amazon/smithy/model/Model;", "symbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "kotlin.jvm.PlatformType", "render", "", "sortedMembers", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "memberNameSymbolIndex", "", "Lkotlin/Pair;", "", "renderStructure", "renderImmutableProperties", "renderImmutableProperty", "memberName", "memberSymbol", "renderCompanionObject", "renderToString", "renderHashCode", "selectHashFunctionForShape", "member", "renderEquals", "renderCopy", "renderBuilder", "renderError", "renderRetryable", "isThrottling", "", "renderErrorType", "errorTrait", "Lsoftware/amazon/smithy/model/traits/ErrorTrait;", "checkForConflictsInHierarchy", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nStructureGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructureGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/StructureGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n1056#2:398\n1285#2,2:399\n1299#2,4:401\n1869#2,2:405\n1563#2:411\n1634#2,3:412\n1761#2,3:415\n1878#2,3:418\n1869#2,2:421\n774#2:424\n865#2,2:425\n827#2:427\n855#2:428\n856#2:430\n1869#2,2:431\n774#2:433\n865#2,2:434\n73#3:407\n78#3:408\n83#3:409\n73#3:423\n73#3:429\n1#4:410\n*S KotlinDebug\n*F\n+ 1 StructureGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/StructureGenerator\n*L\n41#1:398\n43#1:399,2\n43#1:401,4\n70#1:405,2\n382#1:411\n382#1:412,3\n384#1:415,3\n113#1:418,3\n137#1:421,2\n295#1:424\n295#1:425,2\n300#1:427\n300#1:428\n300#1:430\n304#1:431,2\n272#1:433\n272#1:434,2\n163#1:407\n317#1:408\n319#1:409\n196#1:423\n302#1:429\n*E\n"})
public final class StructureGenerator {
    @NotNull
    private final RenderingContext<StructureShape> ctx;
    @NotNull
    private final StructureShape shape;
    @NotNull
    private final KotlinWriter writer;
    @NotNull
    private final SymbolProvider symbolProvider;
    @NotNull
    private final Model model;
    private final Symbol symbol;
    @NotNull
    private final List<MemberShape> sortedMembers;
    @NotNull
    private final Map<MemberShape, Pair<String, Symbol>> memberNameSymbolIndex;

    /*
     * WARNING - void declaration
     */
    public StructureGenerator(@NotNull RenderingContext<StructureShape> ctx) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.ctx = ctx;
        StructureShape structureShape = this.ctx.getShape();
        if (structureShape == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.shape = structureShape;
        this.writer = this.ctx.getWriter();
        this.symbolProvider = this.ctx.getSymbolProvider();
        this.model = this.ctx.getModel();
        this.symbol = this.ctx.getSymbolProvider().toSymbol((Shape)this.ctx.getShape());
        Iterable $this$sortedBy$iv = this.shape.getAllMembers().values();
        boolean $i$f$sortedBy = false;
        this.sortedMembers = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MemberShape it = (MemberShape)a;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Comparable comparable = (Comparable)((Object)NamingKt.defaultName(it));
                it = (MemberShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                Intrinsics.checkNotNull((Object)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)NamingKt.defaultName(it))));
            }
        });
        $this$sortedBy$iv = this.sortedMembers;
        StructureGenerator structureGenerator = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void member;
            MemberShape memberShape = (MemberShape)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)this.symbolProvider.toMemberName((MemberShape)member), (Object)this.symbolProvider.toSymbol((Shape)member));
            map.put(t, pair);
        }
        structureGenerator.memberNameSymbolIndex = result$iv;
    }

    public final void render() {
        this.writer.renderDocumentation((Shape)this.shape);
        this.writer.renderAnnotations((Shape)this.shape);
        if (!ShapeExtKt.isError((Shape)this.shape)) {
            this.renderStructure();
        } else {
            this.renderError();
        }
    }

    private final void renderStructure() {
        Object[] objectArray = new Object[]{this.ctx.getSettings().getApi().getVisibility(), this.symbol};
        ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)this.writer.openBlock("#L class #T private constructor(builder: Builder) {", objectArray)).call(() -> StructureGenerator.renderStructure$lambda$2(this))).write("", new Object[0])).call(() -> StructureGenerator.renderStructure$lambda$3(this))).call(() -> StructureGenerator.renderStructure$lambda$4(this))).call(() -> StructureGenerator.renderStructure$lambda$5(this))).call(() -> StructureGenerator.renderStructure$lambda$6(this))).call(() -> StructureGenerator.renderStructure$lambda$7(this))).call(() -> StructureGenerator.renderStructure$lambda$8(this))).closeBlock("}", new Object[0])).write("", new Object[0]);
    }

    private final void renderImmutableProperties() {
        Iterable $this$forEach$iv = this.sortedMembers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair<String, Symbol> pair;
            MemberShape it = (MemberShape)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(this.memberNameSymbolIndex.get(it));
            String memberName = (String)pair.component1();
            Symbol memberSymbol = (Symbol)pair.component2();
            if (ShapeExtKt.isError((Shape)this.shape) && Intrinsics.areEqual((Object)memberName, (Object)"message")) {
                Shape targetShape = this.model.expectShape(it.getTarget());
                if (targetShape.isStringShape()) continue;
                throw new CodegenException("message is a reserved name for exception types and cannot be used for any other property");
            }
            this.writer.renderMemberDocumentation(this.model, it);
            this.writer.renderAnnotations((Shape)it);
            this.renderImmutableProperty(memberName, memberSymbol);
        }
    }

    private final void renderImmutableProperty(String memberName, Symbol memberSymbol) {
        KotlinWriter kotlinWriter;
        if (SymbolExtKt.isRequiredWithNoDefault(memberSymbol)) {
            Object[] objectArray = new Object[]{memberName, memberSymbol};
            kotlinWriter = (KotlinWriter)this.writer.write("public val #1L: #2F = requireNotNull(builder.#1L) { \"A non-null value must be provided for #1L\" }", objectArray);
        } else {
            Object[] objectArray = new Object[]{memberName, memberSymbol};
            kotlinWriter = (KotlinWriter)this.writer.write("public val #1L: #2F = builder.#1L", objectArray);
        }
    }

    private final void renderCompanionObject() {
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public companion object {", "}", new Object[0], arg_0 -> StructureGenerator.renderCompanionObject$lambda$10(this, arg_0));
    }

    private final void renderToString() {
        this.writer.write("", new Object[0]);
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getString()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "override fun toString(): #Q = buildString {", "}", objectArray, arg_0 -> StructureGenerator.renderToString$lambda$12(this, arg_0));
    }

    private final void renderHashCode() {
        this.writer.write("", new Object[0]);
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getInt()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "override fun hashCode(): #Q {", "}", objectArray, arg_0 -> StructureGenerator.renderHashCode$lambda$14(this, arg_0));
    }

    private final String selectHashFunctionForShape(MemberShape member) {
        String string;
        Shape targetShape = this.model.expectShape(member.getTarget());
        Pair<String, Symbol> pair = this.memberNameSymbolIndex.get(member);
        Intrinsics.checkNotNull(pair);
        boolean isNullable = SymbolExtKt.isNullable((Symbol)pair.getSecond());
        ShapeType shapeType = targetShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 1: {
                if (isNullable) {
                    string = " ?: 0";
                    break;
                }
                string = "";
                break;
            }
            case 2: {
                if (isNullable) {
                    string = "?.toInt() ?: 0";
                    break;
                }
                string = ".toInt()";
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)targetShape);
                Shape $this$hasTrait$iv = targetShape;
                boolean $i$f$hasTrait = false;
                String hashFn = $this$hasTrait$iv.hasTrait(StreamingTrait.class) ? "hashCode()" : "contentHashCode()";
                boolean bl = isNullable;
                if (bl) {
                    string = "?." + hashFn + " ?: 0";
                    break;
                }
                if (!bl) {
                    string = '.' + hashFn;
                    break;
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                string = isNullable ? "?.hashCode() ?: 0" : ".hashCode()";
            }
        }
        return string;
    }

    private final void renderEquals() {
        this.writer.write("", new Object[0]);
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getAny(), KotlinTypes.INSTANCE.getBoolean()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "override fun equals(other: #Q?): #Q {", "}", objectArray, arg_0 -> StructureGenerator.renderEquals$lambda$15(this, arg_0));
    }

    private final void renderCopy() {
        if (this.sortedMembers.isEmpty()) {
            return;
        }
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getUnit(), this.symbol};
        ((KotlinWriter)((KotlinWriter)this.writer.write("", new Object[0])).write("public inline fun copy(block: Builder.() -> #Q = {}): #Q = Builder(this).apply(block).build()", objectArray)).write("", new Object[0]);
    }

    private final void renderBuilder() {
        Object[] objectArray = new Object[]{RuntimeTypes.Core.INSTANCE.getSdkDsl()};
        AbstractCodeWriter abstractCodeWriter = ((KotlinWriter)this.writer.write("", new Object[0])).write("@#T", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)abstractCodeWriter, (String)"write(...)");
        AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "public class Builder {", "}", new Object[0], arg_0 -> StructureGenerator.renderBuilder$lambda$22(this, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private final void renderError() {
        block5: {
            $this$expectTrait$iv = (Shape)this.shape;
            $i$f$expectTrait = false;
            v0 = $this$expectTrait$iv.expectTrait(ErrorTrait.class);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"expectTrait(...)");
            errorTrait = (ErrorTrait)v0;
            var4_6 = (Shape)this.shape;
            $i$f$getTrait = false;
            v1 = $this$getTrait$iv.getTrait(RetryableTrait.class);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getTrait(...)");
            $i$f$expectTrait = (RetryableTrait)((Trait)OptionalExtKt.getOrNull(v1));
            if ($i$f$expectTrait == null) ** GOTO lbl-1000
            it = $i$f$expectTrait;
            $i$a$-let-StructureGenerator$renderError$1 = false;
            $this$getTrait$iv = TuplesKt.to((Object)true, (Object)it.getThrottling());
            if ($this$getTrait$iv != null) {
                v2 = $this$getTrait$iv;
            } else lbl-1000:
            // 2 sources

            {
                v2 = TuplesKt.to((Object)false, (Object)false);
            }
            var2_1 = v2;
            isRetryable = (Boolean)var2_1.component1();
            isThrottling = (Boolean)var2_1.component2();
            this.checkForConflictsInHierarchy();
            exceptionBaseClass = ExceptionBaseClassGenerator.INSTANCE.baseExceptionSymbol(this.ctx.getSettings());
            KotlinWriter.addImport$default(this.writer, exceptionBaseClass, null, 2, null);
            v3 = this.shape.members();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"members(...)");
            var9_13 = v3;
            for (T var11_15 : var9_13) {
                it = (MemberShape)var11_15;
                $i$a$-find-StructureGenerator$renderError$superParam$1 = false;
                if (!Intrinsics.areEqual((Object)this.symbolProvider.toMemberName(it), (Object)"message")) continue;
                v4 = var11_15;
                break block5;
            }
            v4 = null;
        }
        var7_12 = v4;
        if (var7_12 != null) {
            it = var7_12;
            $i$a$-let-StructureGenerator$renderError$superParam$2 = false;
            v5 = "builder.message";
        } else {
            v5 = "";
        }
        superParam = v5;
        var8_19 = new Object[]{this.ctx.getSettings().getApi().getVisibility(), this.symbol, exceptionBaseClass.getName(), superParam};
        v6 = ((KotlinWriter)((KotlinWriter)((KotlinWriter)this.writer.openBlock("#L class #T private constructor(builder: Builder) : #L(#L) {", var8_19)).write("", new Object[0])).call((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, renderError$lambda$26(software.amazon.smithy.kotlin.codegen.rendering.StructureGenerator ), ()V)((StructureGenerator)this))).write("", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"write(...)");
        ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)AbstractCodeWriterExtKt.withBlock(v6, "init {", "}", new Object[0], (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, renderError$lambda$29(boolean software.amazon.smithy.kotlin.codegen.rendering.StructureGenerator boolean software.amazon.smithy.model.traits.ErrorTrait software.amazon.smithy.kotlin.codegen.core.KotlinWriter ), (Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;)Lkotlin/Unit;)((boolean)isRetryable, (StructureGenerator)this, (boolean)isThrottling, (ErrorTrait)errorTrait))).write("", new Object[0])).call((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, renderError$lambda$30(software.amazon.smithy.kotlin.codegen.rendering.StructureGenerator ), ()V)((StructureGenerator)this))).call((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, renderError$lambda$31(software.amazon.smithy.kotlin.codegen.rendering.StructureGenerator ), ()V)((StructureGenerator)this))).call((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, renderError$lambda$32(software.amazon.smithy.kotlin.codegen.rendering.StructureGenerator ), ()V)((StructureGenerator)this))).call((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, renderError$lambda$33(software.amazon.smithy.kotlin.codegen.rendering.StructureGenerator ), ()V)((StructureGenerator)this))).call((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, renderError$lambda$34(software.amazon.smithy.kotlin.codegen.rendering.StructureGenerator ), ()V)((StructureGenerator)this))).call((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, renderError$lambda$35(software.amazon.smithy.kotlin.codegen.rendering.StructureGenerator ), ()V)((StructureGenerator)this))).closeBlock("}", new Object[0])).write("", new Object[0]);
    }

    private final void renderRetryable(boolean isThrottling) {
        this.writer.write("sdkErrorMetadata.attributes[ErrorMetadata.Retryable] = true", new Object[0]);
        Object[] objectArray = new Object[]{isThrottling};
        this.writer.write("sdkErrorMetadata.attributes[ErrorMetadata.ThrottlingError] = #L", objectArray);
        KotlinWriter.addImport$default(this.writer, RuntimeTypes.Core.INSTANCE.getErrorMetadata(), null, 2, null);
    }

    private final void renderErrorType(ErrorTrait errorTrait) {
        String string;
        if (errorTrait.isClientError()) {
            string = "ErrorType.Client";
        } else if (errorTrait.isServerError()) {
            string = "ErrorType.Server";
        } else {
            throw new CodegenException("Errors must be either of client or server type");
        }
        String errorType = string;
        this.writer.write("sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = " + errorType, new Object[0]);
        KotlinWriter.addImport$default(this.writer, RuntimeTypes.Core.INSTANCE.getServiceErrorMetadata(), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForConflictsInHierarchy() {
        boolean hasConflictWithBaseClass;
        block5: {
            boolean bl;
            void $this$mapTo$iv$iv;
            Set baseExceptionProperties = SetsKt.setOf((Object)"sdkErrorMetadata");
            Iterable $this$map$iv = this.sortedMembers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MemberShape memberShape = (MemberShape)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.symbolProvider.toMemberName((MemberShape)it));
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!baseExceptionProperties.contains(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = hasConflictWithBaseClass = false;
            }
        }
        if (hasConflictWithBaseClass) {
            throw new CodegenException("`sdkErrorMetadata` conflicts with property of same name inherited from SdkBaseException. Apply a rename customization/projection to fix.");
        }
    }

    private static final void renderStructure$lambda$2(StructureGenerator this$0) {
        this$0.renderImmutableProperties();
    }

    private static final void renderStructure$lambda$3(StructureGenerator this$0) {
        this$0.renderCompanionObject();
    }

    private static final void renderStructure$lambda$4(StructureGenerator this$0) {
        this$0.renderToString();
    }

    private static final void renderStructure$lambda$5(StructureGenerator this$0) {
        this$0.renderHashCode();
    }

    private static final void renderStructure$lambda$6(StructureGenerator this$0) {
        this$0.renderEquals();
    }

    private static final void renderStructure$lambda$7(StructureGenerator this$0) {
        this$0.renderCopy();
    }

    private static final void renderStructure$lambda$8(StructureGenerator this$0) {
        this$0.renderBuilder();
    }

    private static final Unit renderCompanionObject$lambda$10(StructureGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getUnit(), this$0.symbol};
        $this$withBlock.write("public operator fun invoke(block: Builder.() -> #Q): #Q = Builder().apply(block).build()", objectArray);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renderToString$lambda$12(StructureGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{this$0.symbol};
        $this$withBlock.write("append(\"#T(\")", objectArray);
        if (StructureGeneratorKt.access$isSensitive((Shape)this$0.shape, this$0.model)) {
            objectArray = new Object[]{"*** Sensitive Data Redacted ***"};
            $this$withBlock.write("append(#S)", objectArray);
        } else {
            Iterable $this$forEachIndexed$iv = this$0.sortedMembers;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void memberShape;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                MemberShape memberShape2 = (MemberShape)item$iv;
                int index = n;
                boolean bl = false;
                Pair<String, Symbol> pair = this$0.memberNameSymbolIndex.get(memberShape);
                Intrinsics.checkNotNull(pair);
                String memberName = (String)pair.component1();
                boolean isSensitive = StructureGeneratorKt.access$isSensitive((Shape)memberShape, this$0.model);
                String value = isSensitive ? "*** Sensitive Data Redacted ***" : '$' + memberName;
                String separator = index < this$0.sortedMembers.size() - 1 ? "," : "";
                Object[] objectArray2 = new Object[]{NamingKt.defaultName((MemberShape)memberShape), value, separator};
                $this$withBlock.write("append(\"#L=#L#L\")", objectArray2);
            }
        }
        $this$withBlock.write("append(\")\")", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderHashCode$lambda$14(StructureGenerator this$0, KotlinWriter $this$withBlock) {
        KotlinWriter kotlinWriter;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        if (this$0.sortedMembers.isEmpty()) {
            kotlinWriter = (KotlinWriter)$this$withBlock.write("return this::class.hashCode()", new Object[0]);
        } else {
            Object[] objectArray = new Object[2];
            Pair<String, Symbol> pair = this$0.memberNameSymbolIndex.get(this$0.sortedMembers.get(0));
            Intrinsics.checkNotNull(pair);
            objectArray[0] = pair.getFirst();
            objectArray[1] = this$0.selectHashFunctionForShape(this$0.sortedMembers.get(0));
            $this$withBlock.write("var result = #1L#2L", objectArray);
            if (this$0.sortedMembers.size() > 1) {
                Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)this$0.sortedMembers, (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MemberShape memberShape = (MemberShape)element$iv;
                    boolean bl = false;
                    Object[] objectArray2 = new Object[2];
                    Pair<String, Symbol> pair2 = this$0.memberNameSymbolIndex.get(memberShape);
                    Intrinsics.checkNotNull(pair2);
                    objectArray2[0] = pair2.getFirst();
                    objectArray2[1] = this$0.selectHashFunctionForShape(memberShape);
                    $this$withBlock.write("result = 31 * result + (#1L#2L)", objectArray2);
                }
            }
            kotlinWriter = (KotlinWriter)$this$withBlock.write("return result", new Object[0]);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderEquals$lambda$15(StructureGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("if (this === other) return true", new Object[0]);
        $this$withBlock.write("if (other == null || this::class != other::class) return false", new Object[0]);
        $this$withBlock.write("", new Object[0]);
        Object[] objectArray = new Object[]{this$0.symbol};
        $this$withBlock.write("other as #T", objectArray);
        $this$withBlock.write("", new Object[0]);
        for (MemberShape memberShape : this$0.sortedMembers) {
            KotlinWriter kotlinWriter;
            Object[] objectArray2;
            Shape target = this$0.model.expectShape(memberShape.getTarget());
            Pair<String, Symbol> pair = this$0.memberNameSymbolIndex.get(memberShape);
            Intrinsics.checkNotNull(pair);
            String memberName = (String)pair.getFirst();
            if (target instanceof BlobShape) {
                Shape $this$hasTrait$iv = target;
                boolean $i$f$hasTrait = false;
                if (!$this$hasTrait$iv.hasTrait(StreamingTrait.class)) {
                    objectArray2 = new Object[]{memberName};
                    KotlinWriter kotlinWriter2 = (KotlinWriter)$this$withBlock.openBlock("if (#1L != null) {", objectArray2);
                    objectArray2 = new Object[]{memberName};
                    KotlinWriter kotlinWriter3 = (KotlinWriter)kotlinWriter2.write("if (other.#1L == null) return false", objectArray2);
                    objectArray2 = new Object[]{memberName};
                    KotlinWriter kotlinWriter4 = (KotlinWriter)kotlinWriter3.write("if (!#1L.contentEquals(other.#1L)) return false", objectArray2);
                    objectArray2 = new Object[]{memberName};
                    kotlinWriter = (KotlinWriter)kotlinWriter4.closeBlock("} else if (other.#1L != null) return false", objectArray2);
                    continue;
                }
            }
            if (target instanceof ListShape) {
                MemberShape memberShape2 = ((ListShape)target).getMember();
                Intrinsics.checkNotNullExpressionValue((Object)memberShape2, (String)"getMember(...)");
                if (ShapeExtKt.targetOrSelf((Shape)memberShape2, this$0.model).isBlobShape()) {
                    objectArray2 = new Object[]{memberName};
                    KotlinWriter kotlinWriter5 = (KotlinWriter)$this$withBlock.openBlock("if (#L != null) {", objectArray2);
                    objectArray2 = new Object[]{memberName};
                    KotlinWriter kotlinWriter6 = (KotlinWriter)kotlinWriter5.write("if (other.#L == null) return false", objectArray2);
                    objectArray2 = new Object[]{memberName};
                    KotlinWriter kotlinWriter7 = (KotlinWriter)kotlinWriter6.write("if (#1L.size != other.#1L.size) return false", objectArray2);
                    objectArray2 = new Object[]{memberName};
                    KotlinWriter kotlinWriter8 = (KotlinWriter)kotlinWriter7.openBlock("for (i in #L.indices) {", objectArray2);
                    objectArray2 = new Object[]{memberName};
                    KotlinWriter kotlinWriter9 = (KotlinWriter)((KotlinWriter)kotlinWriter8.write("if (!#1L[i].contentEquals(other.#1L[i])) return false", objectArray2)).closeBlock("}", new Object[0]);
                    objectArray2 = new Object[]{memberName};
                    kotlinWriter = (KotlinWriter)kotlinWriter9.closeBlock("} else if (other.#1L != null) return false", objectArray2);
                    continue;
                }
            }
            if (target instanceof DoubleShape || target instanceof FloatShape) {
                objectArray2 = new Object[]{memberName};
                kotlinWriter = (KotlinWriter)$this$withBlock.write("if (!(#1L?.equals(other.#1L) ?: (other.#1L == null))) return false", objectArray2);
                continue;
            }
            objectArray2 = new Object[]{memberName};
            kotlinWriter = (KotlinWriter)$this$withBlock.write("if (#1L != other.#1L) return false", objectArray2);
        }
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.write("return true", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderBuilder$lambda$22$lambda$16(StructureGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        for (MemberShape member : this$0.sortedMembers) {
            Pair<String, Symbol> pair = this$0.memberNameSymbolIndex.get(member);
            Intrinsics.checkNotNull(pair);
            String memberName = (String)pair.component1();
            Object[] objectArray = new Object[]{memberName};
            $this$withBlock.write("this.#1L = x.#1L", objectArray);
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit renderBuilder$lambda$22$lambda$21(StructureGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
        $this$filter$iv = this$0.sortedMembers;
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (MemberShape)element$iv$iv;
            $i$a$-filter-StructureGenerator$renderBuilder$1$2$1 = false;
            v0 = this$0.memberNameSymbolIndex.get(it);
            Intrinsics.checkNotNull(v0);
            memberSymbol = (Symbol)v0.component2();
            if (!SymbolExtKt.isRequiredWithNoDefault(memberSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (MemberShape)element$iv$iv;
            $i$a$-filterNot-StructureGenerator$renderBuilder$1$2$2 = false;
            target = this$0.ctx.getModel().expectShape(it.getTarget());
            Intrinsics.checkNotNull((Object)target);
            if (ShapeExtKt.isStreaming(target)) ** GOTO lbl-1000
            $this$hasTrait$iv = (Shape)it;
            $i$f$hasTrait = false;
            if ($this$hasTrait$iv.hasTrait(ClientOptionalTrait.class)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (MemberShape)element$iv;
            $i$a$-forEach-StructureGenerator$renderBuilder$1$2$3 = false;
            correctedValue = ClientErrorCorrection.INSTANCE.defaultValue(this$0.ctx, it, this$0.writer);
            var9_11 = new Object[]{this$0.ctx.getSymbolProvider().toMemberName(it), correctedValue};
            $this$withBlock.write("if (#1L == null) #1L = #2L", var9_11);
        }
        $this$withBlock.write("return this", new Object[0]);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renderBuilder$lambda$22(StructureGenerator this$0, KotlinWriter $this$withBlock) {
        void $this$filterTo$iv$iv;
        Object object;
        Object memberName;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        for (MemberShape member : this$0.sortedMembers) {
            Symbol symbol;
            Pair<String, Symbol> pair;
            Intrinsics.checkNotNull(this$0.memberNameSymbolIndex.get(member));
            memberName = (String)pair.component1();
            Symbol memberSymbol = (Symbol)pair.component2();
            this$0.writer.renderMemberDocumentation(this$0.model, member);
            this$0.writer.renderAnnotations((Shape)member);
            if (SymbolExtKt.isRequiredWithNoDefault(memberSymbol)) {
                Symbol.Builder builder = memberSymbol.toBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"toBuilder(...)");
                symbol = SymbolExtKt.nullable(builder).build();
            } else {
                symbol = memberSymbol;
            }
            Symbol builderMemberSymbol = symbol;
            object = new Object[]{memberName, builderMemberSymbol};
            $this$withBlock.write("public var #L: #E", (Object[])object);
        }
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.write("@PublishedApi", new Object[0]);
        $this$withBlock.write("internal constructor()", new Object[0]);
        this$0.writer.write("@PublishedApi", new Object[0]);
        AbstractCodeWriter abstractCodeWriter = $this$withBlock;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this$0.symbol, (String)"symbol");
        AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "internal constructor(x: #Q) : this() {", "}", objectArray, arg_0 -> StructureGenerator.renderBuilder$lambda$22$lambda$16(this$0, arg_0));
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.write("@PublishedApi", new Object[0]);
        objectArray = new Object[]{this$0.symbol};
        $this$withBlock.write("internal fun build(): #1Q = #1T(this)", objectArray);
        Iterable $this$filter$iv = this$0.sortedMembers;
        boolean $i$f$filter = false;
        memberName = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MemberShape member = (MemberShape)element$iv$iv;
            boolean bl = false;
            Object t = this$0.model.getShape(member.getTarget()).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            Shape targetShape = (Shape)t;
            if (!targetShape.isStructureShape()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List structMembers = (List)destination$iv$iv;
        for (MemberShape member : structMembers) {
            Pair<String, Symbol> pair;
            this$0.writer.write("", new Object[0]);
            Intrinsics.checkNotNull(this$0.memberNameSymbolIndex.get(member));
            String memberName2 = (String)pair.component1();
            Symbol memberSymbol = (Symbol)pair.component2();
            this$0.writer.dokka("construct an [" + memberSymbol.getFullName() + "] inside the given [block]");
            this$0.writer.renderAnnotations((Shape)member);
            object = new Object[]{memberName2, memberSymbol, KotlinTypes.INSTANCE.getUnit()};
            KotlinWriter kotlinWriter = (KotlinWriter)$this$withBlock.openBlock("public fun #L(block: #Q.Builder.() -> #Q) {", (Object[])object);
            object = new Object[]{memberName2, memberSymbol};
            ((KotlinWriter)kotlinWriter.write("this.#L = #Q.invoke(block)", (Object[])object)).closeBlock("}", new Object[0]);
        }
        $this$withBlock.write("", new Object[0]);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "internal fun correctErrors(): Builder {", "}", new Object[0], arg_0 -> StructureGenerator.renderBuilder$lambda$22$lambda$21(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final void renderError$lambda$26(StructureGenerator this$0) {
        this$0.renderImmutableProperties();
    }

    private static final void renderError$lambda$29$lambda$27(StructureGenerator this$0, boolean $isThrottling) {
        this$0.renderRetryable($isThrottling);
    }

    private static final void renderError$lambda$29$lambda$28(StructureGenerator this$0, ErrorTrait $errorTrait) {
        this$0.renderErrorType($errorTrait);
    }

    private static final Unit renderError$lambda$29(boolean $isRetryable, StructureGenerator this$0, boolean $isThrottling, ErrorTrait $errorTrait, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        if ($isRetryable) {
            $this$withBlock.call(() -> StructureGenerator.renderError$lambda$29$lambda$27(this$0, $isThrottling));
        }
        $this$withBlock.call(() -> StructureGenerator.renderError$lambda$29$lambda$28(this$0, $errorTrait));
        return Unit.INSTANCE;
    }

    private static final void renderError$lambda$30(StructureGenerator this$0) {
        this$0.renderCompanionObject();
    }

    private static final void renderError$lambda$31(StructureGenerator this$0) {
        this$0.renderToString();
    }

    private static final void renderError$lambda$32(StructureGenerator this$0) {
        this$0.renderHashCode();
    }

    private static final void renderError$lambda$33(StructureGenerator this$0) {
        this$0.renderEquals();
    }

    private static final void renderError$lambda$34(StructureGenerator this$0) {
        this$0.renderCopy();
    }

    private static final void renderError$lambda$35(StructureGenerator this$0) {
        this$0.renderBuilder();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeType.values().length];
            try {
                nArray[ShapeType.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BLOB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

