/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.protocol;

import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ApplicationProtocol;", "", "name", "", "requestType", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "responseType", "<init>", "(Ljava/lang/String;Lsoftware/amazon/smithy/codegen/core/Symbol;Lsoftware/amazon/smithy/codegen/core/Symbol;)V", "getName", "()Ljava/lang/String;", "getRequestType", "()Lsoftware/amazon/smithy/codegen/core/Symbol;", "getResponseType", "isHttpProtocol", "", "()Z", "equals", "other", "hashCode", "", "Companion", "smithy-kotlin-codegen"})
public final class ApplicationProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Symbol requestType;
    @NotNull
    private final Symbol responseType;

    public ApplicationProtocol(@NotNull String name, @NotNull Symbol requestType, @NotNull Symbol responseType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)requestType, (String)"requestType");
        Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
        this.name = name;
        this.requestType = requestType;
        this.responseType = responseType;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Symbol getRequestType() {
        return this.requestType;
    }

    @NotNull
    public final Symbol getResponseType() {
        return this.responseType;
    }

    public final boolean isHttpProtocol() {
        return StringsKt.startsWith$default((String)this.name, (String)"http", (boolean)false, (int)2, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ApplicationProtocol)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.requestType, (Object)((ApplicationProtocol)other).requestType) && Intrinsics.areEqual((Object)this.responseType, (Object)((ApplicationProtocol)other).responseType);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.requestType, this.responseType};
        return Objects.hash(objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ApplicationProtocol$Companion;", "", "<init>", "()V", "createDefaultHttpApplicationProtocol", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ApplicationProtocol;", "createHttpSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "symbolName", "", "subnamespace", "smithy-kotlin-codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ApplicationProtocol createDefaultHttpApplicationProtocol() {
            return new ApplicationProtocol("http", this.createHttpSymbol("HttpRequestBuilder", "request"), this.createHttpSymbol("HttpResponse", "response"));
        }

        private final Symbol createHttpSymbol(String symbolName, String subnamespace) {
            Symbol symbol = Symbol.builder().name(symbolName).namespace(KotlinDependency.Companion.getHTTP().getNamespace() + '.' + subnamespace, ".").addDependency((SymbolDependencyContainer)KotlinDependency.Companion.getHTTP()).build();
            Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"build(...)");
            return symbol;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

