/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.smoketests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.rendering.smoketests.SmokeTestAdditionalEnvVars;
import software.amazon.smithy.kotlin.codegen.rendering.smoketests.SmokeTestDefaultConfig;
import software.amazon.smithy.kotlin.codegen.rendering.smoketests.SmokeTestHttpEngineOverride;
import software.amazon.smithy.kotlin.codegen.rendering.smoketests.SmokeTestRegionDefault;
import software.amazon.smithy.kotlin.codegen.rendering.smoketests.SmokeTestsRunner;
import software.amazon.smithy.kotlin.codegen.rendering.smoketests.SmokeTestsRunnerGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.util.NodeKt;
import software.amazon.smithy.kotlin.codegen.utils.CaseUtilsKt;
import software.amazon.smithy.kotlin.codegen.utils.ModelKt;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.kotlin.codegen.utils.StringsKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.smoketests.traits.FailureExpectation;
import software.amazon.smithy.smoketests.traits.SmokeTestCase;
import software.amazon.smithy.smoketests.traits.SmokeTestsTrait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J@\u0010\"\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/smoketests/SmokeTestsRunnerGenerator;", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;)V", "model", "Lsoftware/amazon/smithy/model/Model;", "sdkId", "", "symbolProvider", "Lsoftware/amazon/smithy/codegen/core/SymbolProvider;", "service", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "kotlin.jvm.PlatformType", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "operations", "", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "render", "", "render$smithy_kotlin_codegen", "renderFunctionCalls", "renderFunctions", "renderFunction", "operation", "testCase", "Lsoftware/amazon/smithy/smoketests/traits/SmokeTestCase;", "renderClient", "renderOperation", "renderCatchBlock", "getFailureCriterion", "printTestResult", "errorExpected", "", "statusOverride", "directive", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nSmokeTestsRunnerGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmokeTestsRunnerGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/smoketests/SmokeTestsRunnerGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,194:1\n774#2:195\n865#2:196\n866#2:198\n1863#2:199\n1863#2,2:201\n1864#2:203\n1863#2:204\n1863#2,2:206\n1864#2:208\n72#3:197\n82#3:200\n82#3:205\n434#4:209\n507#4,5:210\n434#4:215\n507#4,5:216\n216#5,2:221\n216#5,2:223\n*S KotlinDebug\n*F\n+ 1 SmokeTestsRunnerGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/smoketests/SmokeTestsRunnerGenerator\n*L\n37#1:195\n37#1:196\n37#1:198\n66#1:199\n67#1:201,2\n66#1:203\n74#1:204\n75#1:206,2\n74#1:208\n37#1:197\n67#1:200\n75#1:205\n154#1:209\n154#1:210,5\n87#1:215\n87#1:216,5\n110#1:221,2\n136#1:223,2\n*E\n"})
public final class SmokeTestsRunnerGenerator {
    @NotNull
    private final KotlinWriter writer;
    @NotNull
    private final Model model;
    @NotNull
    private final String sdkId;
    @NotNull
    private final SymbolProvider symbolProvider;
    private final Symbol service;
    @NotNull
    private final List<OperationShape> operations;

    /*
     * WARNING - void declaration
     */
    public SmokeTestsRunnerGenerator(@NotNull KotlinWriter writer, @NotNull CodegenContext ctx) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.writer = writer;
        this.model = ctx.getModel();
        this.sdkId = ctx.getSettings().getSdkId();
        this.symbolProvider = ctx.getSymbolProvider();
        this.service = this.symbolProvider.toSymbol(this.model.expectShape(ctx.getSettings().getService()));
        Iterable iterable = ModelKt.topDownOperations(ctx.getModel(), ctx.getSettings().getService());
        SmokeTestsRunnerGenerator smokeTestsRunnerGenerator = this;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OperationShape it = (OperationShape)element$iv$iv;
            boolean bl = false;
            Shape $this$hasTrait$iv = (Shape)it;
            boolean $i$f$hasTrait = false;
            if (!$this$hasTrait$iv.hasTrait(SmokeTestsTrait.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        smokeTestsRunnerGenerator.operations = (List)destination$iv$iv;
    }

    public final void render$smithy_kotlin_codegen() {
        AbstractCodeWriterExtKt.declareSection$default(this.writer, SmokeTestsRunner.INSTANCE, null, arg_0 -> SmokeTestsRunnerGenerator.render$lambda$2(this, arg_0), 2, null);
    }

    private final void renderFunctionCalls() {
        Iterable $this$forEach$iv = this.operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape operation = (OperationShape)element$iv;
            boolean bl = false;
            Shape $this$getTrait$iv = (Shape)operation;
            boolean $i$f$getTrait = false;
            Optional optional = $this$getTrait$iv.getTrait(SmokeTestsTrait.class);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(...)");
            Object object = (SmokeTestsTrait)((Trait)OptionalExtKt.getOrNull(optional));
            if (object == null || (object = object.getTestCases()) == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SmokeTestCase testCase = (SmokeTestCase)element$iv2;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                Intrinsics.checkNotNull((Object)testCase);
                this.writer.write(stringBuilder.append(SmokeTestsRunnerGeneratorKt.access$getFunctionName(testCase)).append("()").toString(), new Object[0]);
            }
        }
    }

    private final void renderFunctions() {
        Iterable $this$forEach$iv = this.operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape operation = (OperationShape)element$iv;
            boolean bl = false;
            Shape $this$getTrait$iv = (Shape)operation;
            boolean $i$f$getTrait = false;
            Optional optional = $this$getTrait$iv.getTrait(SmokeTestsTrait.class);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(...)");
            Object object = (SmokeTestsTrait)((Trait)OptionalExtKt.getOrNull(optional));
            if (object == null || (object = object.getTestCases()) == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SmokeTestCase testCase = (SmokeTestCase)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)testCase);
                this.renderFunction(operation, testCase);
                this.writer.write("", new Object[0]);
            }
        }
    }

    private final void renderFunction(OperationShape operation, SmokeTestCase testCase) {
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "private suspend fun " + SmokeTestsRunnerGeneratorKt.access$getFunctionName(testCase) + "() {", "}", new Object[0], arg_0 -> SmokeTestsRunnerGenerator.renderFunction$lambda$12(testCase, this, operation, arg_0));
    }

    private final void renderClient(SmokeTestCase testCase) {
        Object[] objectArray = new Object[]{this.service};
        AbstractCodeWriterExtKt.withInlineBlock((AbstractCodeWriter)this.writer, "#L {", "}", objectArray, arg_0 -> SmokeTestsRunnerGenerator.renderClient$lambda$14(testCase, arg_0));
    }

    private final void renderOperation(OperationShape operation, SmokeTestCase testCase) {
        Symbol operationSymbol = this.symbolProvider.toSymbol((Shape)this.model.getShape((ShapeId)operation.getInput().get()).get());
        Object[] objectArray = new Object[]{RuntimeTypes.Core.IO.INSTANCE.getUse()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, ".#T { client ->", "}", objectArray, arg_0 -> SmokeTestsRunnerGenerator.renderOperation$lambda$18(operation, operationSymbol, testCase, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void renderCatchBlock(SmokeTestCase testCase) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Symbol expected = testCase.getExpectation().isFailure() ? this.getFailureCriterion(testCase) : RuntimeTypes.HttpClient.Interceptors.INSTANCE.getSmokeTestsSuccessException();
        Object object = new Object[]{expected};
        this.writer.write("val success = e is #T", (Object[])object);
        object = new Object[]{"ok", "not ok"};
        this.writer.write("val status = if (success) #S else #S", (Object[])object);
        object = this.sdkId;
        SmokeTestsRunnerGenerator smokeTestsRunnerGenerator = this;
        boolean $i$f$filter = false;
        CharSequence charSequence = (CharSequence)$this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(!CharsKt.isWhitespace((char)it))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = testCase.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        SmokeTestsRunnerGenerator.printTestResult$default(smokeTestsRunnerGenerator, string, string2, testCase.getExpectation().isFailure(), this.writer, null, null, 48, null);
        this.writer.write("if (!success) exitCode = 1", new Object[0]);
    }

    private final Symbol getFailureCriterion(SmokeTestCase testCase) {
        Object object;
        block3: {
            block2: {
                Optional optional = testCase.getExpectation().getFailure();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getFailure(...)");
                object = (FailureExpectation)OptionalsKt.getOrNull((Optional)optional);
                if (object == null || (object = object.getErrorId()) == null || (object = (ShapeId)OptionalsKt.getOrNull((Optional)object)) == null) break block2;
                Object it = object;
                boolean bl = false;
                Symbol symbol = this.symbolProvider.toSymbol((Shape)this.model.getShape((ShapeId)it).get());
                object = symbol;
                if (symbol != null) break block3;
            }
            object = RuntimeTypes.HttpClient.Interceptors.INSTANCE.getSmokeTestsFailureException();
        }
        return object;
    }

    private final void printTestResult(String service, String testCase, boolean errorExpected, KotlinWriter writer, String statusOverride, String directive) {
        String expectation = errorExpected ? "error expected from service" : "no error expected from service";
        String string = statusOverride;
        if (string == null) {
            string = "$status";
        }
        String status = string;
        String testResult = status + ' ' + service + ' ' + testCase + " - " + expectation + ' ' + directive;
        Object[] objectArray = new Object[]{testResult};
        writer.write("println(#S)", objectArray);
    }

    static /* synthetic */ void printTestResult$default(SmokeTestsRunnerGenerator smokeTestsRunnerGenerator, String string, String string2, boolean bl, KotlinWriter kotlinWriter, String string3, String string4, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            string4 = "";
        }
        smokeTestsRunnerGenerator.printTestResult(string, string2, bl, kotlinWriter, string3, string4);
    }

    private static final Unit render$lambda$2$lambda$1(SmokeTestsRunnerGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.renderFunctionCalls();
        Object[] objectArray = new Object[]{RuntimeTypes.Core.SmokeTests.INSTANCE.getExitProcess()};
        $this$withBlock.write("#T(exitCode)", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$2(SmokeTestsRunnerGenerator this$0, KotlinWriter $this$declareSection) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
        $this$declareSection.write("private var exitCode = 0", new Object[0]);
        Object[] objectArray = new Object[]{RuntimeTypes.Core.Utils.INSTANCE.getPlatformProvider(), "AWS_SMOKE_TEST_SKIP_TAGS", ","};
        $this$declareSection.write("private val skipTags = #T.System.getenv(#S)?.let { it.split(#S).map { it.trim() }.toSet() } ?: emptySet()", objectArray);
        objectArray = new Object[]{RuntimeTypes.Core.Utils.INSTANCE.getPlatformProvider(), "AWS_SMOKE_TEST_SERVICE_IDS", ","};
        $this$declareSection.write("private val serviceFilter = #T.System.getenv(#S)?.let { it.split(#S).map { it.trim() }.toSet() } ?: emptySet()", objectArray);
        AbstractCodeWriterExtKt.declareSection$default($this$declareSection, SmokeTestAdditionalEnvVars.INSTANCE, null, null, 6, null);
        $this$declareSection.write("", new Object[0]);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$declareSection, "public suspend fun main() {", "}", new Object[0], arg_0 -> SmokeTestsRunnerGenerator.render$lambda$2$lambda$1(this$0, arg_0));
        $this$declareSection.write("", new Object[0]);
        this$0.renderFunctions();
        return Unit.INSTANCE;
    }

    private static final CharSequence renderFunction$lambda$12$lambda$7(String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.dq(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renderFunction$lambda$12$lambda$9(SmokeTestsRunnerGenerator this$0, SmokeTestCase $testCase, KotlinWriter $this$withBlock) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$testCase, (String)"$testCase");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        String string = this$0.sdkId;
        SmokeTestsRunnerGenerator smokeTestsRunnerGenerator = this$0;
        boolean $i$f$filter = false;
        CharSequence charSequence = (CharSequence)$this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(!CharsKt.isWhitespace((char)it))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = $testCase.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        smokeTestsRunnerGenerator.printTestResult(string2, string3, $testCase.getExpectation().isFailure(), this$0.writer, "ok", "# skip");
        this$0.writer.write("return", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderFunction$lambda$12$lambda$10(SmokeTestsRunnerGenerator this$0, SmokeTestCase $testCase, OperationShape $operation, KotlinWriter $this$withInlineBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$testCase, (String)"$testCase");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withInlineBlock), (String)"$this$withInlineBlock");
        this$0.renderClient($testCase);
        this$0.renderOperation($operation, $testCase);
        return Unit.INSTANCE;
    }

    private static final Unit renderFunction$lambda$12$lambda$11(SmokeTestsRunnerGenerator this$0, SmokeTestCase $testCase, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$testCase, (String)"$testCase");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.renderCatchBlock($testCase);
        return Unit.INSTANCE;
    }

    private static final Unit renderFunction$lambda$12(SmokeTestCase $testCase, SmokeTestsRunnerGenerator this$0, OperationShape $operation, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$testCase, (String)"$testCase");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        StringBuilder stringBuilder = new StringBuilder().append("val tags = setOf<String>(");
        List list = $testCase.getTags();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTags(...)");
        $this$withBlock.write(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, SmokeTestsRunnerGenerator::renderFunction$lambda$12$lambda$7, (int)30, null)).append(')').toString(), new Object[0]);
        Object[] objectArray = new Object[]{this$0.sdkId};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this$0.writer, "if ((serviceFilter.isNotEmpty() && #S !in serviceFilter) || tags.any { it in skipTags }) {", "}", objectArray, arg_0 -> SmokeTestsRunnerGenerator.renderFunction$lambda$12$lambda$9(this$0, $testCase, arg_0));
        $this$withBlock.write("", new Object[0]);
        AbstractCodeWriterExtKt.withInlineBlock((AbstractCodeWriter)$this$withBlock, "try {", "} ", new Object[0], arg_0 -> SmokeTestsRunnerGenerator.renderFunction$lambda$12$lambda$10(this$0, $testCase, $operation, arg_0));
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "catch (e: Exception) {", "}", new Object[0], arg_0 -> SmokeTestsRunnerGenerator.renderFunction$lambda$12$lambda$11(this$0, $testCase, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderClient$lambda$14(SmokeTestCase $testCase, KotlinWriter $this$withInlineBlock) {
        boolean expectingSpecificError;
        Intrinsics.checkNotNullParameter((Object)$testCase, (String)"$testCase");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withInlineBlock), (String)"$this$withInlineBlock");
        if ($testCase.getVendorParams().isPresent()) {
            Map map = ((ObjectNode)$testCase.getVendorParams().get()).getMembers();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getMembers(...)");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                KotlinWriter kotlinWriter;
                Object[] objectArray;
                Map.Entry element$iv;
                Map.Entry vendorParam = element$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)((StringNode)vendorParam.getKey()).getValue(), (Object)"region")) {
                    objectArray = new Object[1];
                    String string = ((StringNode)vendorParam.getKey()).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    objectArray[0] = CaseUtilsKt.toCamelCase(string);
                    $this$withInlineBlock.writeInline("#L = ", objectArray);
                    AbstractCodeWriterExtKt.declareSection$default($this$withInlineBlock, SmokeTestRegionDefault.INSTANCE, null, null, 6, null);
                    objectArray = new Object[1];
                    Object v = vendorParam.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                    objectArray[0] = NodeKt.format((Node)v);
                    kotlinWriter = (KotlinWriter)$this$withInlineBlock.write("#L", objectArray);
                    continue;
                }
                objectArray = new Object[2];
                String string = ((StringNode)vendorParam.getKey()).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                objectArray[0] = CaseUtilsKt.toCamelCase(string);
                Object v = vendorParam.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                objectArray[1] = NodeKt.format((Node)v);
                kotlinWriter = (KotlinWriter)$this$withInlineBlock.write("#L = #L", objectArray);
            }
        } else {
            AbstractCodeWriterExtKt.declareSection$default($this$withInlineBlock, SmokeTestDefaultConfig.INSTANCE, null, null, 6, null);
        }
        Optional optional = $testCase.getExpectation().getFailure();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getFailure(...)");
        Object object = (FailureExpectation)OptionalsKt.getOrNull((Optional)optional);
        boolean bl = expectingSpecificError = (object != null && (object = object.getErrorId()) != null ? (ShapeId)OptionalsKt.getOrNull((Optional)object) : null) != null;
        if (!expectingSpecificError) {
            Object[] objectArray = new Object[]{RuntimeTypes.HttpClient.Interceptors.INSTANCE.getSmokeTestsInterceptor()};
            $this$withInlineBlock.write("interceptors.add(#T())", objectArray);
        }
        AbstractCodeWriterExtKt.declareSection$default($this$withInlineBlock, SmokeTestHttpEngineOverride.INSTANCE, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit renderOperation$lambda$18$lambda$17$lambda$16(SmokeTestCase $testCase, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$testCase, (String)"$testCase");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Map map = ((ObjectNode)$testCase.getParams().get()).getMembers();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getMembers(...)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry member = element$iv = iterator.next();
            boolean bl = false;
            Object[] objectArray = new Object[2];
            String string = ((StringNode)member.getKey()).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            objectArray[0] = CaseUtilsKt.toCamelCase(string);
            Object v = member.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            objectArray[1] = NodeKt.format((Node)v);
            $this$withBlock.write("#L = #L", objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderOperation$lambda$18$lambda$17(Symbol $operationSymbol, SmokeTestCase $testCase, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$testCase, (String)"$testCase");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$operationSymbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "#L {", "}", objectArray, arg_0 -> SmokeTestsRunnerGenerator.renderOperation$lambda$18$lambda$17$lambda$16($testCase, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderOperation$lambda$18(OperationShape $operation, Symbol $operationSymbol, SmokeTestCase $testCase, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        Intrinsics.checkNotNullParameter((Object)$testCase, (String)"$testCase");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{NamingKt.defaultName($operation)};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "client.#L(", ")", objectArray, arg_0 -> SmokeTestsRunnerGenerator.renderOperation$lambda$18$lambda$17($operationSymbol, $testCase, arg_0));
        return Unit.INSTANCE;
    }
}

