/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.NestedIdentifierType;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0006H\u0014J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0004J(\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0016H\u0002J \u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0016H\u0002J8\u0010.\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u00020*2\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u0010'\u001a\u00020\u0016H\u0002J@\u00102\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u0010'\u001a\u00020\u0016H\u0002J@\u00103\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u00104\u001a\u0002052\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u0010'\u001a\u00020\u0016H\u0002J8\u00106\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u00020*2\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u0010'\u001a\u00020\u0016H\u0002J\u0018\u00107\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010 \u001a\u000205H\u0004J(\u00108\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00062\u0006\u00109\u001a\u0002052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0016H\u0002J(\u0010:\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020*2\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u0010'\u001a\u00020\u0016H\u0002J(\u0010;\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010<\u001a\u00020\u0016H\u0002J(\u0010=\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010/\u001a\u0002052\u0006\u0010%\u001a\u00020&2\u0006\u0010>\u001a\u00020\u0016H\u0002J(\u0010?\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020*2\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u0010@\u001a\u00020\u0016H\u0002J\u0010\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020*H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006C"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeStructGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/util/List;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;)V", "getCtx", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getMembers", "()Ljava/util/List;", "getWriter", "()Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "collectionReturnExpression", "", "memberShape", "defaultCollectionName", "deserializationResultName", "defaultName", "render", "", "renderMemberShape", "renderShapeDeserializer", "renderMapMemberDeserializer", "targetShape", "Lsoftware/amazon/smithy/model/shapes/MapShape;", "delegateMapDeserialization", "rootMemberShape", "mapShape", "nestingLevel", "", "parentMemberName", "writeKeyVal", "keyShape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "keySymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "keyName", "renderNestedStructureEntry", "elementShape", "isSparse", "", "renderMapEntry", "renderListEntry", "collectionShape", "Lsoftware/amazon/smithy/model/shapes/CollectionShape;", "renderEntry", "renderListMemberDeserializer", "delegateListDeserialization", "listShape", "renderNestedStructureElement", "renderMapElement", "parentMapMemberName", "renderListElement", "parentListMemberName", "renderElement", "listMemberName", "deserializerForShape", "shape", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nDeserializeStructGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeserializeStructGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeStructGenerator\n+ 2 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,643:1\n72#2:644\n82#2:645\n1053#3:646\n1863#3,2:647\n*S KotlinDebug\n*F\n+ 1 DeserializeStructGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeStructGenerator\n*L\n441#1:644\n615#1:645\n69#1:646\n69#1:647,2\n*E\n"})
public class DeserializeStructGenerator {
    @NotNull
    private final ProtocolGenerator.GenerationContext ctx;
    @NotNull
    private final List<MemberShape> members;
    @NotNull
    private final KotlinWriter writer;
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat;

    public DeserializeStructGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<MemberShape> members, @NotNull KotlinWriter writer, @NotNull TimestampFormatTrait.Format defaultTimestampFormat) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)defaultTimestampFormat, (String)"defaultTimestampFormat");
        this.ctx = ctx;
        this.members = members;
        this.writer = writer;
        this.defaultTimestampFormat = defaultTimestampFormat;
    }

    @NotNull
    protected final ProtocolGenerator.GenerationContext getCtx() {
        return this.ctx;
    }

    @NotNull
    protected final List<MemberShape> getMembers() {
        return this.members;
    }

    @NotNull
    protected final KotlinWriter getWriter() {
        return this.writer;
    }

    @NotNull
    protected final TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @NotNull
    public String collectionReturnExpression(@NotNull MemberShape memberShape, @NotNull String defaultCollectionName) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)defaultCollectionName, (String)"defaultCollectionName");
        return defaultCollectionName;
    }

    @NotNull
    public String deserializationResultName(@NotNull String defaultName) {
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        return defaultName;
    }

    public void render() {
        String string;
        if (!((Collection)this.members).isEmpty()) {
            string = "OBJ_DESCRIPTOR";
        } else {
            KotlinWriter.addImport$default(this.writer, RuntimeTypes.Serde.INSTANCE.getSdkObjectDescriptor(), null, 2, null);
            string = "SdkObjectDescriptor.build {}";
        }
        String objDescriptor = string;
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeStruct()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "deserializer.#T(" + objDescriptor + ") {", "}", objectArray, arg_0 -> DeserializeStructGenerator.render$lambda$4(this, arg_0));
    }

    protected void renderMemberShape(@NotNull MemberShape memberShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Shape targetShape = this.ctx.getModel().expectShape(memberShape.getTarget());
        ShapeType shapeType = targetShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)targetShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
                this.renderListMemberDeserializer(memberShape, (CollectionShape)targetShape);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)targetShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.MapShape");
                this.renderMapMemberDeserializer(memberShape, (MapShape)targetShape);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.renderShapeDeserializer(memberShape);
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected shape type: " + targetShape.getType()).toString());
            }
        }
    }

    public void renderShapeDeserializer(@NotNull MemberShape memberShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        String memberName = this.ctx.getSymbolProvider().toMemberName(memberShape);
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape, null, 1, null);
        String deserialize = this.deserializerForShape((Shape)memberShape);
        this.writer.write(descriptorName + ".index -> builder." + memberName + " = " + deserialize, new Object[0]);
    }

    protected final void renderMapMemberDeserializer(@NotNull MemberShape memberShape, @NotNull MapShape targetShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)targetShape, (String)"targetShape");
        int nestingLevel = 0;
        String memberName = this.ctx.getSymbolProvider().toMemberName(memberShape);
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape, null, 1, null);
        String valueCollector = this.deserializationResultName("builder." + memberName);
        String mutableCollectionName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.MAP);
        String collectionReturnExpression = this.collectionReturnExpression(memberShape, mutableCollectionName);
        AbstractCodeWriter abstractCodeWriter = ((KotlinWriter)this.writer.write(descriptorName + ".index -> " + valueCollector + " = ", new Object[0])).indent();
        Intrinsics.checkNotNullExpressionValue((Object)abstractCodeWriter, (String)"indent(...)");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeMap()};
        ((KotlinWriter)AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "deserializer.#T(" + descriptorName + ") {", "}", objectArray, arg_0 -> DeserializeStructGenerator.renderMapMemberDeserializer$lambda$6(mutableCollectionName, this, targetShape, collectionReturnExpression, memberShape, nestingLevel, arg_0))).dedent();
    }

    private final void delegateMapDeserialization(MemberShape rootMemberShape, MapShape mapShape, int nestingLevel, String parentMemberName) {
        Shape keyShape = this.ctx.getModel().expectShape(mapShape.getKey().getTarget());
        Symbol keySymbol = this.ctx.getSymbolProvider().toSymbol(keyShape);
        Shape elementShape = this.ctx.getModel().expectShape(mapShape.getValue().getTarget());
        boolean isSparse = ShapeExtKt.isSparse((Shape)mapShape);
        ShapeType shapeType = elementShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                Intrinsics.checkNotNull((Object)keyShape);
                Intrinsics.checkNotNull((Object)keySymbol);
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderEntry(keyShape, keySymbol, elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)keyShape);
                Intrinsics.checkNotNull((Object)keySymbol);
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
                this.renderListEntry(rootMemberShape, keyShape, keySymbol, (CollectionShape)elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)keyShape);
                Intrinsics.checkNotNull((Object)keySymbol);
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.MapShape");
                this.renderMapEntry(rootMemberShape, keyShape, keySymbol, (MapShape)elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 4: 
            case 5: {
                Intrinsics.checkNotNull((Object)keyShape);
                Intrinsics.checkNotNull((Object)keySymbol);
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderNestedStructureEntry(keyShape, keySymbol, elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            default: {
                throw new IllegalStateException(("Unhandled type " + elementShape.getType()).toString());
            }
        }
    }

    private final void writeKeyVal(Shape keyShape, Symbol keySymbol, String keyName) {
        KotlinWriter kotlinWriter;
        this.writer.writeInline("val " + keyName + " = ", new Object[0]);
        if (ShapeExtKt.isEnum(keyShape)) {
            Object[] objectArray = new Object[]{keySymbol};
            kotlinWriter = (KotlinWriter)this.writer.write("#T.fromValue(key())", objectArray);
        } else {
            kotlinWriter = (KotlinWriter)this.writer.write("key()", new Object[0]);
        }
    }

    private final void renderNestedStructureEntry(Shape keyShape, Symbol keySymbol, Shape elementShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String populateNullValuePostfix;
        String deserializerFn = this.deserializerForShape(elementShape);
        String keyName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.KEY);
        String valueName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.VALUE);
        String string = populateNullValuePostfix = isSparse ? "" : "; continue";
        if (elementShape.isStructureShape() || elementShape.isUnionShape()) {
            Symbol symbol = this.ctx.getSymbolProvider().toSymbol(elementShape);
            Intrinsics.checkNotNull((Object)symbol);
            KotlinWriter.addImport$default(this.writer, symbol, null, 2, null);
        }
        this.writeKeyVal(keyShape, keySymbol, keyName);
        this.writer.write("val " + valueName + " = if (nextHasValue()) { " + deserializerFn + " } else { deserializeNull()" + populateNullValuePostfix + " }", new Object[0]);
        this.writer.write(parentMemberName + '[' + keyName + "] = " + valueName, new Object[0]);
    }

    private final void renderMapEntry(MemberShape rootMemberShape, Shape keyShape, Symbol keySymbol, MapShape mapShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String keyName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.KEY);
        String valueName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.VALUE);
        String populateNullValuePostfix = isSparse ? "" : "; continue";
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        int nextNestingLevel = nestingLevel + 1;
        String memberName = SerdeExtKt.variableNameFor(nextNestingLevel, NestedIdentifierType.MAP);
        String collectionReturnExpression = this.collectionReturnExpression(rootMemberShape, memberName);
        this.writeKeyVal(keyShape, keySymbol, keyName);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "val " + valueName + " =", "", new Object[0], arg_0 -> DeserializeStructGenerator.renderMapEntry$lambda$10(populateNullValuePostfix, descriptorName, memberName, this, mapShape, collectionReturnExpression, rootMemberShape, nextNestingLevel, arg_0));
        this.writer.write(parentMemberName + '[' + keyName + "] = " + valueName, new Object[0]);
    }

    private final void renderListEntry(MemberShape rootMemberShape, Shape keyShape, Symbol keySymbol, CollectionShape collectionShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String keyName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.KEY);
        String valueName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.VALUE);
        String populateNullValuePostfix = isSparse ? "" : "; continue";
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        int nextNestingLevel = nestingLevel + 1;
        String memberName = SerdeExtKt.variableNameFor(nextNestingLevel, NestedIdentifierType.COLLECTION);
        String collectionReturnExpression = this.collectionReturnExpression(rootMemberShape, memberName);
        this.writeKeyVal(keyShape, keySymbol, keyName);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "val " + valueName + " =", "", new Object[0], arg_0 -> DeserializeStructGenerator.renderListEntry$lambda$14(populateNullValuePostfix, descriptorName, memberName, this, collectionShape, collectionReturnExpression, rootMemberShape, nextNestingLevel, arg_0));
        this.writer.write(parentMemberName + '[' + keyName + "] = " + valueName, new Object[0]);
    }

    private final void renderEntry(Shape keyShape, Symbol keySymbol, Shape elementShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String deserializerFn = this.deserializerForShape(elementShape);
        String keyName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.KEY);
        String valueName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.VALUE);
        String populateNullValuePostfix = isSparse ? "" : "; continue";
        this.writeKeyVal(keyShape, keySymbol, keyName);
        this.writer.write("val " + valueName + " = if (nextHasValue()) { " + deserializerFn + " } else { deserializeNull()" + populateNullValuePostfix + " }", new Object[0]);
        this.writer.write(parentMemberName + '[' + keyName + "] = " + valueName, new Object[0]);
    }

    protected final void renderListMemberDeserializer(@NotNull MemberShape memberShape, @NotNull CollectionShape targetShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)targetShape, (String)"targetShape");
        int nestingLevel = 0;
        String memberName = this.ctx.getSymbolProvider().toMemberName(memberShape);
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape, null, 1, null);
        String valueCollector = this.deserializationResultName("builder." + memberName);
        String mutableCollectionName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.COLLECTION);
        String collectionReturnExpression = this.collectionReturnExpression(memberShape, mutableCollectionName);
        AbstractCodeWriter abstractCodeWriter = ((KotlinWriter)this.writer.write(descriptorName + ".index -> " + valueCollector + " = ", new Object[0])).indent();
        Intrinsics.checkNotNullExpressionValue((Object)abstractCodeWriter, (String)"indent(...)");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeList()};
        ((KotlinWriter)AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "deserializer.#T(" + descriptorName + ") {", "}", objectArray, arg_0 -> DeserializeStructGenerator.renderListMemberDeserializer$lambda$16(mutableCollectionName, this, targetShape, collectionReturnExpression, memberShape, nestingLevel, arg_0))).dedent();
    }

    private final void delegateListDeserialization(MemberShape rootMemberShape, CollectionShape listShape, int nestingLevel, String parentMemberName) {
        Shape elementShape = this.ctx.getModel().expectShape(listShape.getMember().getTarget());
        Shape $this$hasTrait$iv = (Shape)listShape;
        boolean $i$f$hasTrait = false;
        boolean isSparse = $this$hasTrait$iv.hasTrait(SparseTrait.class);
        ShapeType shapeType = elementShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderElement(elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
                this.renderListElement(rootMemberShape, (CollectionShape)elementShape, nestingLevel, parentMemberName);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.MapShape");
                this.renderMapElement(rootMemberShape, (MapShape)elementShape, nestingLevel, parentMemberName);
                break;
            }
            case 4: 
            case 5: {
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderNestedStructureElement(elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            default: {
                throw new IllegalStateException(("Unhandled type " + elementShape.getType()).toString());
            }
        }
    }

    private final void renderNestedStructureElement(Shape elementShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String populateNullValuePostfix;
        String deserializer = this.deserializerForShape(elementShape);
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        String string = populateNullValuePostfix = isSparse ? "" : "; continue";
        if (elementShape.isStructureShape() || elementShape.isUnionShape()) {
            Symbol symbol = this.ctx.getSymbolProvider().toSymbol(elementShape);
            Intrinsics.checkNotNull((Object)symbol);
            KotlinWriter.addImport$default(this.writer, symbol, null, 2, null);
        }
        this.writer.write("val " + elementName + " = if (nextHasValue()) { " + deserializer + " } else { deserializeNull()" + populateNullValuePostfix + " }", new Object[0]);
        this.writer.write(parentMemberName + ".add(" + elementName + ')', new Object[0]);
    }

    private final void renderMapElement(MemberShape rootMemberShape, MapShape mapShape, int nestingLevel, String parentMapMemberName) {
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        int nextNestingLevel = nestingLevel + 1;
        String mapName = SerdeExtKt.variableNameFor(nextNestingLevel, NestedIdentifierType.MAP);
        String collectionReturnExpression = this.collectionReturnExpression(rootMemberShape, mapName);
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeMap()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "val " + elementName + " = deserializer.#T(" + descriptorName + ") {", "}", objectArray, arg_0 -> DeserializeStructGenerator.renderMapElement$lambda$18(mapName, this, mapShape, collectionReturnExpression, rootMemberShape, nextNestingLevel, arg_0));
        this.writer.write(parentMapMemberName + ".add(" + elementName + ')', new Object[0]);
    }

    private final void renderListElement(MemberShape rootMemberShape, CollectionShape elementShape, int nestingLevel, String parentListMemberName) {
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        int nextNestingLevel = nestingLevel + 1;
        String listName = SerdeExtKt.variableNameFor(nextNestingLevel, NestedIdentifierType.COLLECTION);
        String collectionReturnExpression = this.collectionReturnExpression(rootMemberShape, listName);
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeList()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "val " + elementName + " = deserializer.#T(" + descriptorName + ") {", "}", objectArray, arg_0 -> DeserializeStructGenerator.renderListElement$lambda$20(listName, this, elementShape, collectionReturnExpression, rootMemberShape, nextNestingLevel, arg_0));
        this.writer.write(parentListMemberName + ".add(" + elementName + ')', new Object[0]);
    }

    private final void renderElement(Shape elementShape, int nestingLevel, boolean isSparse, String listMemberName) {
        String deserializerFn = this.deserializerForShape(elementShape);
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        String populateNullValuePostfix = isSparse ? "" : "; continue";
        this.writer.write("val " + elementName + " = if (nextHasValue()) { " + deserializerFn + " } else { deserializeNull()" + populateNullValuePostfix + " }", new Object[0]);
        this.writer.write(listMemberName + ".add(" + elementName + ')', new Object[0]);
    }

    @NotNull
    protected final String deserializerForShape(@NotNull Shape shape) {
        String string;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape target = ShapeExtKt.targetOrSelf(shape, this.ctx.getModel());
        if (target.getType() == ShapeType.BOOLEAN) {
            string = "deserializeBoolean()";
        } else if (target.getType() == ShapeType.BYTE) {
            string = "deserializeByte()";
        } else if (target.getType() == ShapeType.SHORT) {
            string = "deserializeShort()";
        } else if (target.getType() == ShapeType.INTEGER) {
            string = "deserializeInt()";
        } else if (target.getType() == ShapeType.LONG) {
            string = "deserializeLong()";
        } else if (target.getType() == ShapeType.FLOAT) {
            string = "deserializeFloat()";
        } else if (target.getType() == ShapeType.DOUBLE) {
            string = "deserializeDouble()";
        } else if (target.getType() == ShapeType.BIG_INTEGER) {
            string = "deserializeBigInteger()";
        } else if (target.getType() == ShapeType.BIG_DECIMAL) {
            string = "deserializeBigDecimal()";
        } else if (target.getType() == ShapeType.DOCUMENT) {
            string = "deserializeDocument()";
        } else if (target.getType() == ShapeType.BLOB) {
            string = "deserializeByteArray()";
        } else if (target.getType() == ShapeType.TIMESTAMP) {
            TimestampFormatTrait trait;
            TimestampFormatTrait timestampFormatTrait;
            KotlinWriter.addImport$default(this.writer, RuntimeTypes.Core.INSTANCE.getInstant(), null, 2, null);
            KotlinWriter.addImport$default(this.writer, RuntimeTypes.Core.INSTANCE.getTimestampFormat(), null, 2, null);
            Shape $this$getTrait$iv = shape;
            boolean $i$f$getTrait = false;
            Optional optional = $this$getTrait$iv.getTrait(TimestampFormatTrait.class);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(...)");
            TimestampFormatTrait timestampFormatTrait2 = (TimestampFormatTrait)((Trait)OptionalExtKt.getOrNull(optional));
            if (timestampFormatTrait2 == null) {
                $this$getTrait$iv = target;
                $i$f$getTrait = false;
                Optional optional2 = $this$getTrait$iv.getTrait(TimestampFormatTrait.class);
                Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getTrait(...)");
                timestampFormatTrait2 = (TimestampFormatTrait)((Trait)OptionalExtKt.getOrNull(optional2));
            }
            if ((timestampFormatTrait = (trait = timestampFormatTrait2)) == null || (timestampFormatTrait = timestampFormatTrait.getFormat()) == null) {
                timestampFormatTrait = this.defaultTimestampFormat;
            }
            TimestampFormatTrait tsFormat = timestampFormatTrait;
            string = "deserializeInstant(" + SerdeExtKt.toRuntimeEnum((TimestampFormatTrait.Format)tsFormat) + ')';
        } else if (ShapeExtKt.isStringEnumShape(target)) {
            Symbol enumSymbol = this.ctx.getSymbolProvider().toSymbol(target);
            Intrinsics.checkNotNull((Object)enumSymbol);
            KotlinWriter.addImport$default(this.writer, enumSymbol, null, 2, null);
            string = "deserializeString().let { " + enumSymbol.getName() + ".fromValue(it) }";
        } else if (target.isIntEnumShape()) {
            Symbol enumSymbol = this.ctx.getSymbolProvider().toSymbol(target);
            Intrinsics.checkNotNull((Object)enumSymbol);
            KotlinWriter.addImport$default(this.writer, enumSymbol, null, 2, null);
            string = "deserializeInt().let { " + enumSymbol.getName() + ".fromValue(it) }";
        } else if (target.getType() == ShapeType.STRING) {
            string = "deserializeString()";
        } else if (target.getType() == ShapeType.STRUCTURE || target.getType() == ShapeType.UNION) {
            Symbol symbol = this.ctx.getSymbolProvider().toSymbol(target);
            Intrinsics.checkNotNull((Object)symbol);
            String deserializerName = SerdeExtKt.documentDeserializerName(symbol);
            string = deserializerName + "(deserializer)";
        } else {
            throw new CodegenException("unknown deserializer for member: " + shape + "; target: " + target);
        }
        return string;
    }

    private static final Unit render$lambda$4$lambda$3$lambda$2(DeserializeStructGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Iterable $this$sortedBy$iv = this$0.members;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MemberShape it = (MemberShape)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (MemberShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MemberShape memberShape = (MemberShape)element$iv;
            boolean bl = false;
            this$0.renderMemberShape(memberShape);
        }
        $this$withBlock.write("null -> break@loop", new Object[0]);
        $this$withBlock.write("else -> skipValue()", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$4$lambda$3(DeserializeStructGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "when (findNextFieldIndex()) {", "}", new Object[0], arg_0 -> DeserializeStructGenerator.render$lambda$4$lambda$3$lambda$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$4(DeserializeStructGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "loop@while (true) {", "}", new Object[0], arg_0 -> DeserializeStructGenerator.render$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderMapMemberDeserializer$lambda$6$lambda$5(DeserializeStructGenerator this$0, MemberShape $memberShape, MapShape $targetShape, int $nestingLevel, String $mutableCollectionName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$memberShape, (String)"$memberShape");
        Intrinsics.checkNotNullParameter((Object)$targetShape, (String)"$targetShape");
        Intrinsics.checkNotNullParameter((Object)$mutableCollectionName, (String)"$mutableCollectionName");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.delegateMapDeserialization($memberShape, $targetShape, $nestingLevel, $mutableCollectionName);
        return Unit.INSTANCE;
    }

    private static final Unit renderMapMemberDeserializer$lambda$6(String $mutableCollectionName, DeserializeStructGenerator this$0, MapShape $targetShape, String $collectionReturnExpression, MemberShape $memberShape, int $nestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$mutableCollectionName, (String)"$mutableCollectionName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$targetShape, (String)"$targetShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$memberShape, (String)"$memberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$mutableCollectionName, KotlinTypes.Collections.INSTANCE.getMutableMapOf(), this$0.ctx.getSymbolProvider().toSymbol((Shape)$targetShape.getKey()), this$0.ctx.getSymbolProvider().toSymbol((Shape)$targetShape.getValue()), SerdeExtKt.nullabilitySuffix(ShapeExtKt.isSparse((Shape)$targetShape))};
        $this$withBlock.write("val #L = #T<#T, #T#L>()", objectArray);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextEntry()) {", "}", new Object[0], arg_0 -> DeserializeStructGenerator.renderMapMemberDeserializer$lambda$6$lambda$5(this$0, $memberShape, $targetShape, $nestingLevel, $mutableCollectionName, arg_0));
        $this$withBlock.write($collectionReturnExpression, new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderMapEntry$lambda$10$lambda$9$lambda$8$lambda$7(DeserializeStructGenerator this$0, MemberShape $rootMemberShape, MapShape $mapShape, int $nextNestingLevel, String $memberName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)$mapShape, (String)"$mapShape");
        Intrinsics.checkNotNullParameter((Object)$memberName, (String)"$memberName");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.delegateMapDeserialization($rootMemberShape, $mapShape, $nextNestingLevel, $memberName);
        return Unit.INSTANCE;
    }

    private static final Unit renderMapEntry$lambda$10$lambda$9$lambda$8(String $memberName, DeserializeStructGenerator this$0, MapShape $mapShape, String $collectionReturnExpression, MemberShape $rootMemberShape, int $nextNestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$memberName, (String)"$memberName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mapShape, (String)"$mapShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$memberName, KotlinTypes.Collections.INSTANCE.getMutableMapOf(), this$0.ctx.getSymbolProvider().toSymbol((Shape)$mapShape.getKey()), this$0.ctx.getSymbolProvider().toSymbol((Shape)$mapShape.getValue()), SerdeExtKt.nullabilitySuffix(ShapeExtKt.isSparse((Shape)$mapShape))};
        $this$withBlock.write("val #L = #T<#T, #T#L>()", objectArray);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextEntry()) {", "}", new Object[0], arg_0 -> DeserializeStructGenerator.renderMapEntry$lambda$10$lambda$9$lambda$8$lambda$7(this$0, $rootMemberShape, $mapShape, $nextNestingLevel, $memberName, arg_0));
        $this$withBlock.write($collectionReturnExpression, new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderMapEntry$lambda$10$lambda$9(String $descriptorName, String $memberName, DeserializeStructGenerator this$0, MapShape $mapShape, String $collectionReturnExpression, MemberShape $rootMemberShape, int $nextNestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$descriptorName, (String)"$descriptorName");
        Intrinsics.checkNotNullParameter((Object)$memberName, (String)"$memberName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mapShape, (String)"$mapShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeMap()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "deserializer.#T(" + $descriptorName + ") {", "}", objectArray, arg_0 -> DeserializeStructGenerator.renderMapEntry$lambda$10$lambda$9$lambda$8($memberName, this$0, $mapShape, $collectionReturnExpression, $rootMemberShape, $nextNestingLevel, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderMapEntry$lambda$10(String $populateNullValuePostfix, String $descriptorName, String $memberName, DeserializeStructGenerator this$0, MapShape $mapShape, String $collectionReturnExpression, MemberShape $rootMemberShape, int $nextNestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$populateNullValuePostfix, (String)"$populateNullValuePostfix");
        Intrinsics.checkNotNullParameter((Object)$descriptorName, (String)"$descriptorName");
        Intrinsics.checkNotNullParameter((Object)$memberName, (String)"$memberName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mapShape, (String)"$mapShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "if (nextHasValue()) {", "} else { deserializeNull()" + $populateNullValuePostfix + " }", new Object[0], arg_0 -> DeserializeStructGenerator.renderMapEntry$lambda$10$lambda$9($descriptorName, $memberName, this$0, $mapShape, $collectionReturnExpression, $rootMemberShape, $nextNestingLevel, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderListEntry$lambda$14$lambda$13$lambda$12$lambda$11(DeserializeStructGenerator this$0, MemberShape $rootMemberShape, CollectionShape $collectionShape, int $nextNestingLevel, String $memberName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)$collectionShape, (String)"$collectionShape");
        Intrinsics.checkNotNullParameter((Object)$memberName, (String)"$memberName");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.delegateListDeserialization($rootMemberShape, $collectionShape, $nextNestingLevel, $memberName);
        return Unit.INSTANCE;
    }

    private static final Unit renderListEntry$lambda$14$lambda$13$lambda$12(String $memberName, DeserializeStructGenerator this$0, CollectionShape $collectionShape, String $collectionReturnExpression, MemberShape $rootMemberShape, int $nextNestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$memberName, (String)"$memberName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$collectionShape, (String)"$collectionShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$memberName, KotlinTypes.Collections.INSTANCE.getMutableListOf(), this$0.ctx.getSymbolProvider().toSymbol((Shape)$collectionShape.getMember()), SerdeExtKt.nullabilitySuffix(ShapeExtKt.isSparse((Shape)$collectionShape))};
        $this$withBlock.write("val #L = #T<#T#L>()", objectArray);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextElement()) {", "}", new Object[0], arg_0 -> DeserializeStructGenerator.renderListEntry$lambda$14$lambda$13$lambda$12$lambda$11(this$0, $rootMemberShape, $collectionShape, $nextNestingLevel, $memberName, arg_0));
        $this$withBlock.write($collectionReturnExpression, new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderListEntry$lambda$14$lambda$13(String $descriptorName, String $memberName, DeserializeStructGenerator this$0, CollectionShape $collectionShape, String $collectionReturnExpression, MemberShape $rootMemberShape, int $nextNestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$descriptorName, (String)"$descriptorName");
        Intrinsics.checkNotNullParameter((Object)$memberName, (String)"$memberName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$collectionShape, (String)"$collectionShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeList()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "deserializer.#T(" + $descriptorName + ") {", "}", objectArray, arg_0 -> DeserializeStructGenerator.renderListEntry$lambda$14$lambda$13$lambda$12($memberName, this$0, $collectionShape, $collectionReturnExpression, $rootMemberShape, $nextNestingLevel, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderListEntry$lambda$14(String $populateNullValuePostfix, String $descriptorName, String $memberName, DeserializeStructGenerator this$0, CollectionShape $collectionShape, String $collectionReturnExpression, MemberShape $rootMemberShape, int $nextNestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$populateNullValuePostfix, (String)"$populateNullValuePostfix");
        Intrinsics.checkNotNullParameter((Object)$descriptorName, (String)"$descriptorName");
        Intrinsics.checkNotNullParameter((Object)$memberName, (String)"$memberName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$collectionShape, (String)"$collectionShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "if (nextHasValue()) {", "} else { deserializeNull()" + $populateNullValuePostfix + " }", new Object[0], arg_0 -> DeserializeStructGenerator.renderListEntry$lambda$14$lambda$13($descriptorName, $memberName, this$0, $collectionShape, $collectionReturnExpression, $rootMemberShape, $nextNestingLevel, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderListMemberDeserializer$lambda$16$lambda$15(DeserializeStructGenerator this$0, MemberShape $memberShape, CollectionShape $targetShape, int $nestingLevel, String $mutableCollectionName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$memberShape, (String)"$memberShape");
        Intrinsics.checkNotNullParameter((Object)$targetShape, (String)"$targetShape");
        Intrinsics.checkNotNullParameter((Object)$mutableCollectionName, (String)"$mutableCollectionName");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.delegateListDeserialization($memberShape, $targetShape, $nestingLevel, $mutableCollectionName);
        return Unit.INSTANCE;
    }

    private static final Unit renderListMemberDeserializer$lambda$16(String $mutableCollectionName, DeserializeStructGenerator this$0, CollectionShape $targetShape, String $collectionReturnExpression, MemberShape $memberShape, int $nestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$mutableCollectionName, (String)"$mutableCollectionName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$targetShape, (String)"$targetShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$memberShape, (String)"$memberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$mutableCollectionName, KotlinTypes.Collections.INSTANCE.getMutableListOf(), this$0.ctx.getSymbolProvider().toSymbol((Shape)$targetShape.getMember()), SerdeExtKt.nullabilitySuffix(ShapeExtKt.isSparse((Shape)$targetShape))};
        $this$withBlock.write("val #L = #T<#T#L>()", objectArray);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextElement()) {", "}", new Object[0], arg_0 -> DeserializeStructGenerator.renderListMemberDeserializer$lambda$16$lambda$15(this$0, $memberShape, $targetShape, $nestingLevel, $mutableCollectionName, arg_0));
        $this$withBlock.write($collectionReturnExpression, new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderMapElement$lambda$18$lambda$17(DeserializeStructGenerator this$0, MemberShape $rootMemberShape, MapShape $mapShape, int $nextNestingLevel, String $mapName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)$mapShape, (String)"$mapShape");
        Intrinsics.checkNotNullParameter((Object)$mapName, (String)"$mapName");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.delegateMapDeserialization($rootMemberShape, $mapShape, $nextNestingLevel, $mapName);
        return Unit.INSTANCE;
    }

    private static final Unit renderMapElement$lambda$18(String $mapName, DeserializeStructGenerator this$0, MapShape $mapShape, String $collectionReturnExpression, MemberShape $rootMemberShape, int $nextNestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$mapName, (String)"$mapName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mapShape, (String)"$mapShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$mapName, KotlinTypes.Collections.INSTANCE.getMutableMapOf(), this$0.ctx.getSymbolProvider().toSymbol((Shape)$mapShape.getKey()), this$0.ctx.getSymbolProvider().toSymbol((Shape)$mapShape.getValue()), SerdeExtKt.nullabilitySuffix(ShapeExtKt.isSparse((Shape)$mapShape))};
        $this$withBlock.write("val #L = #T<#T, #T#L>()", objectArray);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextEntry()) {", "}", new Object[0], arg_0 -> DeserializeStructGenerator.renderMapElement$lambda$18$lambda$17(this$0, $rootMemberShape, $mapShape, $nextNestingLevel, $mapName, arg_0));
        $this$withBlock.write($collectionReturnExpression, new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderListElement$lambda$20$lambda$19(DeserializeStructGenerator this$0, MemberShape $rootMemberShape, CollectionShape $elementShape, int $nextNestingLevel, String $listName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)$elementShape, (String)"$elementShape");
        Intrinsics.checkNotNullParameter((Object)$listName, (String)"$listName");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.delegateListDeserialization($rootMemberShape, $elementShape, $nextNestingLevel, $listName);
        return Unit.INSTANCE;
    }

    private static final Unit renderListElement$lambda$20(String $listName, DeserializeStructGenerator this$0, CollectionShape $elementShape, String $collectionReturnExpression, MemberShape $rootMemberShape, int $nextNestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$listName, (String)"$listName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$elementShape, (String)"$elementShape");
        Intrinsics.checkNotNullParameter((Object)$collectionReturnExpression, (String)"$collectionReturnExpression");
        Intrinsics.checkNotNullParameter((Object)$rootMemberShape, (String)"$rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$listName, KotlinTypes.Collections.INSTANCE.getMutableListOf(), this$0.ctx.getSymbolProvider().toSymbol((Shape)$elementShape.getMember()), SerdeExtKt.nullabilitySuffix(ShapeExtKt.isSparse((Shape)$elementShape))};
        $this$withBlock.write("val #L = #T<#T#L>()", objectArray);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextElement()) {", "}", new Object[0], arg_0 -> DeserializeStructGenerator.renderListElement$lambda$20$lambda$19(this$0, $rootMemberShape, $elementShape, $nextNestingLevel, $listName, arg_0));
        $this$withBlock.write($collectionReturnExpression, new Object[0]);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeType.values().length];
            try {
                nArray[ShapeType.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.MAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.STRUCTURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.UNION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BLOB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BOOLEAN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.STRING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.TIMESTAMP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BYTE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.SHORT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.INTEGER.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.LONG.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.FLOAT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.DOUBLE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.DOCUMENT.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BIG_DECIMAL.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BIG_INTEGER.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.ENUM.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.INT_ENUM.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

